/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.ShowFirstParty;

@ShowFirstParty
@KeepForSdk
public class Hex {
    private static final char[] zza;
    private static final char[] zzb;

    @KeepForSdk
    @RecentlyNonNull
    public static String bytesToStringUppercase(@RecentlyNonNull byte[] byArray) {
        return Hex.bytesToStringUppercase(byArray, false);
    }

    @KeepForSdk
    @RecentlyNonNull
    public static String bytesToStringUppercase(@RecentlyNonNull byte[] byArray, boolean bl) {
        int n = byArray.length;
        StringBuilder stringBuilder = new StringBuilder(n + n);
        for (int i = 0; !(i >= n || bl && i == n + -1 && (byArray[i] & 0xFF) == 0); ++i) {
            stringBuilder.append(zza[(byArray[i] & 0xF0) >>> 4]);
            stringBuilder.append(zza[byArray[i] & 0xF]);
        }
        return stringBuilder.toString();
    }

    @KeepForSdk
    @RecentlyNonNull
    public static String bytesToStringLowercase(@RecentlyNonNull byte[] object) {
        int n = ((byte[])object).length;
        char[] cArray = new char[n + n];
        n = 0;
        for (int i = 0; i < ((byte[])object).length; ++i) {
            int n2 = object[i] & 0xFF;
            int n3 = n + 1;
            cArray[n] = zzb[n2 >>> 4];
            n = n3 + 1;
            cArray[n3] = zzb[n2 & 0xF];
        }
        object = new String;
        object(cArray);
        return object;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static byte[] stringToBytes(@RecentlyNonNull String object) throws IllegalArgumentException {
        int n = ((String)object).length();
        if (n % 2 != 0) {
            object = new IllegalArgumentException("Hex string has odd number of characters");
            throw object;
        }
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 + 2;
            byArray[n2 / 2] = (byte)Integer.parseInt(((String)object).substring(n2, n3), 16);
            n2 = n3;
        }
        return byArray;
    }

    static {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        zza = cArray;
        cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        zzb = cArray;
    }
}

