/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.text.TextUtils;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.Preconditions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

@KeepForSdk
public final class ScopeUtil {
    private ScopeUtil() {
    }

    @KeepForSdk
    @RecentlyNonNull
    public static Set<Scope> fromScopeString(@RecentlyNonNull Collection<String> collection) {
        Preconditions.checkNotNull(collection, "scopeStrings can't be null.");
        return ScopeUtil.fromScopeString(collection.toArray(new String[collection.size()]));
    }

    @KeepForSdk
    @RecentlyNonNull
    public static Set<Scope> fromScopeString(String ... stringArray) {
        Preconditions.checkNotNull(stringArray, "scopeStrings can't be null.");
        int n = stringArray.length;
        HashSet<Scope> hashSet = new HashSet<Scope>(n);
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i];
            if (TextUtils.isEmpty((CharSequence)string2)) continue;
            Scope scope = new Scope(string2);
            hashSet.add(scope);
        }
        return hashSet;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static String[] toScopeString(@RecentlyNonNull Scope[] scopeArray) {
        Preconditions.checkNotNull(scopeArray, "scopes can't be null.");
        String[] stringArray = new String[scopeArray.length];
        for (int i = 0; i < scopeArray.length; ++i) {
            stringArray[i] = scopeArray[i].getScopeUri();
        }
        return stringArray;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static String[] toScopeString(@RecentlyNonNull Set<Scope> set) {
        Preconditions.checkNotNull(set, "scopes can't be null.");
        return ScopeUtil.toScopeString(set.toArray(new Scope[set.size()]));
    }
}

