/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamic;

import android.annotation.SuppressLint;
import android.app.Fragment;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IFragmentWrapper;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;

@SuppressLint(value={"NewApi"})
@KeepForSdk
public final class FragmentWrapper
extends IFragmentWrapper.Stub {
    private Fragment zza;

    @RecentlyNullable
    @KeepForSdk
    public static FragmentWrapper wrap(@Nullable Fragment fragment) {
        if (fragment != null) {
            FragmentWrapper fragmentWrapper = new FragmentWrapper(fragment);
            return fragmentWrapper;
        }
        return null;
    }

    private FragmentWrapper(Fragment fragment) {
        this.zza = fragment;
    }

    @Override
    @RecentlyNonNull
    public final IObjectWrapper zzb() {
        return ObjectWrapper.wrap(this.zza.getActivity());
    }

    @Override
    @RecentlyNonNull
    public final Bundle zzc() {
        return this.zza.getArguments();
    }

    @Override
    public final int zzd() {
        return this.zza.getId();
    }

    @Override
    @RecentlyNullable
    public final IFragmentWrapper zze() {
        return FragmentWrapper.wrap(this.zza.getParentFragment());
    }

    @Override
    @RecentlyNonNull
    public final IObjectWrapper zzf() {
        return ObjectWrapper.wrap(this.zza.getResources());
    }

    @Override
    public final boolean zzg() {
        return this.zza.getRetainInstance();
    }

    @Override
    @RecentlyNullable
    public final String zzh() {
        return this.zza.getTag();
    }

    @Override
    @RecentlyNullable
    public final IFragmentWrapper zzi() {
        return FragmentWrapper.wrap(this.zza.getTargetFragment());
    }

    @Override
    public final int zzj() {
        return this.zza.getTargetRequestCode();
    }

    @Override
    public final boolean zzk() {
        return this.zza.getUserVisibleHint();
    }

    @Override
    @RecentlyNonNull
    public final IObjectWrapper zzl() {
        return ObjectWrapper.wrap(this.zza.getView());
    }

    @Override
    public final boolean zzm() {
        return this.zza.isAdded();
    }

    @Override
    public final boolean zzn() {
        return this.zza.isDetached();
    }

    @Override
    public final boolean zzo() {
        return this.zza.isHidden();
    }

    @Override
    public final boolean zzp() {
        return this.zza.isInLayout();
    }

    @Override
    public final boolean zzq() {
        return this.zza.isRemoving();
    }

    @Override
    public final boolean zzr() {
        return this.zza.isResumed();
    }

    @Override
    public final boolean zzs() {
        return this.zza.isVisible();
    }

    @Override
    public final void zzt(@RecentlyNonNull IObjectWrapper iObjectWrapper) {
        iObjectWrapper = (View)ObjectWrapper.unwrap(iObjectWrapper);
        FragmentWrapper fragmentWrapper = fragmentWrapper.zza;
        Preconditions.checkNotNull(iObjectWrapper);
        fragmentWrapper.registerForContextMenu((View)iObjectWrapper);
    }

    @Override
    public final void zzu(boolean bl) {
        this.zza.setHasOptionsMenu(bl);
    }

    @Override
    public final void zzv(boolean bl) {
        this.zza.setMenuVisibility(bl);
    }

    @Override
    public final void zzw(boolean bl) {
        this.zza.setRetainInstance(bl);
    }

    @Override
    public final void zzx(boolean bl) {
        this.zza.setUserVisibleHint(bl);
    }

    @Override
    public final void zzy(@RecentlyNonNull Intent intent) {
        this.zza.startActivity(intent);
    }

    @Override
    public final void zzz(@RecentlyNonNull Intent intent, int n) {
        this.zza.startActivityForResult(intent, n);
    }

    @Override
    public final void zzA(@RecentlyNonNull IObjectWrapper iObjectWrapper) {
        iObjectWrapper = (View)ObjectWrapper.unwrap(iObjectWrapper);
        FragmentWrapper fragmentWrapper = fragmentWrapper.zza;
        Preconditions.checkNotNull(iObjectWrapper);
        fragmentWrapper.unregisterForContextMenu((View)iObjectWrapper);
    }
}

