/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Process;
import android.os.WorkSource;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.common.wrappers.Wrappers;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

@KeepForSdk
public class WorkSourceUtil {
    private static final int zza;
    private static final Method zzb;
    private static final Method zzc;
    private static final Method zzd;
    private static final Method zze;
    private static final Method zzf;
    private static final Method zzg;
    private static final Method zzh;
    private static final Method zzi;
    @GuardedBy(value="WorkSourceUtil.class")
    private static Boolean zzj;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @KeepForSdk
    public static int get(@NonNull WorkSource workSource, int i) {
        Method method = zze;
        if (method == null) return 0;
        try {
            void var1_4;
            WorkSource workSource2;
            Object object = method.invoke((Object)workSource2, (int)var1_4);
            Preconditions.checkNotNull(object);
            return (Integer)object;
        }
        catch (Exception exception) {
            Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            return 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @KeepForSdk
    public static int size(@NonNull WorkSource workSource) {
        Method method = zzd;
        if (method == null) return 0;
        try {
            WorkSource workSource2;
            Object object = method.invoke((Object)workSource2, new Object[0]);
            Preconditions.checkNotNull(object);
            return (Integer)object;
        }
        catch (Exception exception) {
            Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            return 0;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @KeepForSdk
    @NonNull
    public static WorkSource fromPackage(@NonNull Context context, @NonNull String packageName) {
        void var1_1;
        Object object;
        block2: {
            if (context == null || object.getPackageManager() == null || var1_1 == null) return null;
            try {
                object = Wrappers.packageManager(object).getApplicationInfo((String)var1_1, 0);
                if (object != null) break block2;
                object = "Could not get applicationInfo from package: ".concat((String)var1_1);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                object = "Could not find package: ".concat((String)var1_1);
                Log.e((String)"WorkSourceUtil", (String)object);
                return null;
            }
            Log.e((String)"WorkSourceUtil", (String)object);
            return null;
        }
        WorkSource workSource = new WorkSource();
        WorkSourceUtil.add(workSource, object.uid, (String)var1_1);
        return workSource;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    @NonNull
    public static WorkSource fromPackageAndModuleExperimentalPi(@NonNull Context context, @NonNull String packageName, @NonNull String moduleName) {
        void var0_4;
        void var1_9;
        void var2_10;
        block9: {
            ApplicationInfo applicationInfo;
            block8: {
                String string2;
                Context context2;
                if (context == null || context2.getPackageManager() == null || var2_10 == null || var1_9 == null) {
                    Log.w((String)"WorkSourceUtil", (String)"Unexpected null arguments");
                    return null;
                }
                try {
                    applicationInfo = Wrappers.packageManager(context2).getApplicationInfo((String)var1_9, 0);
                    if (applicationInfo != null) break block8;
                    string2 = "Could not get applicationInfo from package: ".concat((String)var1_9);
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    String string3 = "Could not find package: ".concat((String)var1_9);
                    Log.e((String)"WorkSourceUtil", (String)string3);
                    int n = -1;
                }
                Log.e((String)"WorkSourceUtil", (String)string2);
                int n = -1;
                break block9;
            }
            int n = applicationInfo.uid;
        }
        if (var0_4 < 0) {
            return null;
        }
        WorkSource workSource = new WorkSource();
        Object object = zzg;
        if (object == null || zzh == null) {
            WorkSourceUtil.add(workSource, (int)var0_4, (String)var1_9);
            return workSource;
        }
        try {
            object = ((Method)object).invoke((Object)workSource, new Object[0]);
            int n = zza;
            if (var0_4 != n) {
                zzh.invoke(object, (int)var0_4, var1_9);
            }
            zzh.invoke(object, zza, var2_10);
            return workSource;
        }
        catch (Exception exception) {
            Log.w((String)"WorkSourceUtil", (String)"Unable to assign chained blame through WorkSource", (Throwable)exception);
            return workSource;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @KeepForSdk
    @NonNull
    public static String getName(@NonNull WorkSource workSource, int i) {
        Method method = zzf;
        if (method == null) return null;
        try {
            void var1_3;
            WorkSource workSource2;
            return (String)method.invoke((Object)workSource2, (int)var1_3);
        }
        catch (Exception exception) {
            Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    @NonNull
    public static List<String> getNames(@NonNull WorkSource workSource) {
        WorkSource workSource2;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = workSource2 == null ? 0 : WorkSourceUtil.size(workSource2);
        if (n == 0) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < n) {
            String string2 = WorkSourceUtil.getName(workSource2, n2);
            if (!Strings.isEmptyOrWhitespace(string2)) {
                Preconditions.checkNotNull(string2);
                arrayList.add(string2);
            }
            ++n2;
        }
        return arrayList;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        block28: {
            block32: {
                block31: {
                    block30: {
                        block29: {
                            WorkSourceUtil.zza = Process.myUid();
                            try {
                                var0 = WorkSource.class.getMethod("add", new Class[]{Integer.TYPE});
                            }
                            catch (Exception v0) {
                                var0 = null;
                            }
                            WorkSourceUtil.zzb = var0;
                            if (PlatformVersion.isAtLeastJellyBeanMR2()) {
                                var0 = WorkSource.class.getMethod("add", new Class[]{Integer.TYPE, String.class});
                                ** GOTO lbl16
                            } else {
                                var0 = null;
                            }
                            break block29;
                            catch (Exception v1) {
                                var0 = null;
                            }
                        }
                        WorkSourceUtil.zzc = var0;
                        try {
                            var0 = WorkSource.class.getMethod("size", new Class[0]);
                        }
                        catch (Exception v2) {
                            var0 = null;
                        }
                        WorkSourceUtil.zzd = var0;
                        try {
                            var0 = WorkSource.class.getMethod("get", new Class[]{Integer.TYPE});
                        }
                        catch (Exception v3) {
                            var0 = null;
                        }
                        WorkSourceUtil.zze = var0;
                        if (PlatformVersion.isAtLeastJellyBeanMR2()) {
                            var0 = WorkSource.class.getMethod("getName", new Class[]{Integer.TYPE});
                            ** GOTO lbl38
                        } else {
                            var0 = null;
                        }
                        break block30;
                        catch (Exception v4) {
                            var0 = null;
                        }
                    }
                    WorkSourceUtil.zzf = var0;
                    if (PlatformVersion.isAtLeastP()) {
                        var0 = WorkSource.class.getMethod("createWorkChain", new Class[0]);
                        ** GOTO lbl50
                    } else {
                        var0 = null;
                    }
                    break block31;
                    catch (Exception var0_1) {
                        Log.w((String)"WorkSourceUtil", (String)"Missing WorkChain API createWorkChain", (Throwable)var0_1);
                        var0 = null;
                    }
                }
                WorkSourceUtil.zzg = var0;
                if (PlatformVersion.isAtLeastP()) {
                    var0 = Class.forName("android.os.WorkSource$WorkChain").getMethod("addNode", new Class[]{Integer.TYPE, String.class});
                    ** GOTO lbl62
                } else {
                    var0 = null;
                }
                break block32;
                catch (Exception var0_2) {
                    Log.w((String)"WorkSourceUtil", (String)"Missing WorkChain class", (Throwable)var0_2);
                    var0 = null;
                }
            }
            WorkSourceUtil.zzh = var0;
            if (PlatformVersion.isAtLeastP()) {
                var0 = WorkSource.class.getMethod("isEmpty", new Class[0]);
                var0.setAccessible(true);
                ** GOTO lbl76
            } else {
                var0 = null;
            }
            break block28;
            catch (Exception v5) {
                var0 = null;
                break block28;
            }
            catch (Exception v6) {}
        }
        WorkSourceUtil.zzi = var0;
        WorkSourceUtil.zzj = null;
    }

    private WorkSourceUtil() {
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @KeepForSdk
    public static void add(@NonNull WorkSource workSource, int uid, @NonNull String packageName) {
        void var1_3;
        WorkSource workSource2;
        Object object;
        Method method = zzc;
        if (method != null) {
            if (object == null) {
                object = "";
            }
            method.invoke((Object)workSource2, (int)var1_3, object);
            return;
        }
        object = zzb;
        if (object == null) return;
        try {
            ((Method)object).invoke((Object)workSource2, (int)var1_3);
            return;
        }
        catch (Exception exception) {
            Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            return;
        }
        catch (Exception exception) {
            Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public static synchronized boolean hasWorkSourcePermission(@NonNull Context context) {
        Context context2;
        Boolean bl = zzj;
        if (bl != null) {
            return bl;
        }
        if (context2 == null) {
            return false;
        }
        boolean bl2 = ContextCompat.checkSelfPermission((Context)context2, (String)"android.permission.UPDATE_DEVICE_STATS") == 0;
        zzj = bl2;
        return zzj;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public static boolean isEmpty(@NonNull WorkSource workSource) {
        WorkSource workSource2;
        Object object = zzi;
        if (object != null) {
            try {
                object = ((Method)object).invoke((Object)workSource2, new Object[0]);
                Preconditions.checkNotNull(object);
                return (Boolean)object;
            }
            catch (Exception exception) {
                Log.e((String)"WorkSourceUtil", (String)"Unable to check WorkSource emptiness", (Throwable)exception);
            }
        }
        if (WorkSourceUtil.size(workSource2) != 0) return false;
        return true;
    }
}

