/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Activity;
import android.app.Fragment;
import android.content.Intent;
import android.os.Bundle;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.api.internal.LifecycleCallback;
import com.google.android.gms.common.api.internal.LifecycleFragment;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.internal.common.zzi;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public final class zzb
extends Fragment
implements LifecycleFragment {
    private static final WeakHashMap zza = new WeakHashMap();
    private final Map zzb = Collections.synchronizedMap(new ArrayMap());
    private int zzc = 0;
    @Nullable
    private Bundle zzd;

    static /* bridge */ /* synthetic */ int zza(zzb zzb2) {
        return zzb2.zzc;
    }

    @Override
    @Nullable
    public final Activity getLifecycleActivity() {
        return this.getActivity();
    }

    static /* bridge */ /* synthetic */ Bundle zzb(zzb zzb2) {
        return zzb2.zzd;
    }

    @Override
    @Nullable
    public final <T extends LifecycleCallback> T getCallbackOrNull(String string2, Class<T> clazz) {
        return (T)((LifecycleCallback)clazz.cast(this.zzb.get(string2)));
    }

    public static zzb zzc(Activity activity) {
        Object object = (WeakReference)zza.get(activity);
        if (object == null || (object = (zzb)((Reference)object).get()) == null) {
            try {
                object = (zzb)activity.getFragmentManager().findFragmentByTag("LifecycleFragmentImpl");
            }
            catch (ClassCastException classCastException) {
                throw new IllegalStateException("Fragment with tag LifecycleFragmentImpl is not a LifecycleFragmentImpl", classCastException);
            }
            if (object == null || object.isRemoving()) {
                object = new zzb();
                activity.getFragmentManager().beginTransaction().add((Fragment)object, "LifecycleFragmentImpl").commitAllowingStateLoss();
            }
            zza.put(activity, new WeakReference<Object>(object));
            return object;
        }
        return object;
    }

    @Override
    public final void addCallback(String string2, @NonNull LifecycleCallback lifecycleCallback) {
        if (!this.zzb.containsKey(string2)) {
            this.zzb.put(string2, lifecycleCallback);
            if (this.zzc > 0) {
                new zzi(Looper.getMainLooper()).post(new zza(this, lifecycleCallback, string2));
                return;
            }
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("LifecycleCallback with tag ");
            stringBuilder.append(string2);
            stringBuilder.append(" already added to this fragment.");
            throw new IllegalArgumentException(stringBuilder.toString());
        }
    }

    public final void dump(String string2, @Nullable FileDescriptor fileDescriptor, PrintWriter printWriter, @Nullable String[] stringArray) {
        super.dump(string2, fileDescriptor, printWriter, stringArray);
        Iterator iterator = ((zzb)((Object)iterator)).zzb.values().iterator();
        while (iterator.hasNext()) {
            ((LifecycleCallback)iterator.next()).dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    public final void onActivityResult(int n, int n2, @Nullable Intent intent) {
        super.onActivityResult(n, n2, intent);
        Iterator iterator = ((zzb)((Object)iterator)).zzb.values().iterator();
        while (iterator.hasNext()) {
            ((LifecycleCallback)iterator.next()).onActivityResult(n, n2, intent);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final void onCreate(@Nullable Bundle bundle) {
        void var1_6;
        super.onCreate((Bundle)var1_6);
        this.zzc = 1;
        this.zzd = var1_6;
        Iterator iterator = this.zzb.entrySet().iterator();
        while (iterator.hasNext()) {
            void var0_4;
            Map.Entry entry = iterator.next();
            LifecycleCallback lifecycleCallback = (LifecycleCallback)entry.getValue();
            if (var1_6 != null) {
                Bundle bundle2 = var1_6.getBundle((String)entry.getKey());
            } else {
                Object var0_5 = null;
            }
            lifecycleCallback.onCreate((Bundle)var0_4);
        }
        return;
    }

    public final void onDestroy() {
        super.onDestroy();
        ((zzb)((Object)iterator)).zzc = 5;
        Iterator iterator = ((zzb)((Object)iterator)).zzb.values().iterator();
        while (iterator.hasNext()) {
            ((LifecycleCallback)iterator.next()).onDestroy();
        }
    }

    public final void onResume() {
        super.onResume();
        ((zzb)((Object)iterator)).zzc = 3;
        Iterator iterator = ((zzb)((Object)iterator)).zzb.values().iterator();
        while (iterator.hasNext()) {
            ((LifecycleCallback)iterator.next()).onResume();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        if (bundle != null) {
            for (Map.Entry entry : ((zzb)this).zzb.entrySet()) {
                Bundle bundle2 = new Bundle();
                ((LifecycleCallback)entry.getValue()).onSaveInstanceState(bundle2);
                bundle.putBundle((String)entry.getKey(), bundle2);
            }
        }
    }

    public final void onStart() {
        super.onStart();
        ((zzb)((Object)iterator)).zzc = 2;
        Iterator iterator = ((zzb)((Object)iterator)).zzb.values().iterator();
        while (iterator.hasNext()) {
            ((LifecycleCallback)iterator.next()).onStart();
        }
    }

    public final void onStop() {
        super.onStop();
        ((zzb)((Object)iterator)).zzc = 4;
        Iterator iterator = ((zzb)((Object)iterator)).zzb.values().iterator();
        while (iterator.hasNext()) {
            ((LifecycleCallback)iterator.next()).onStop();
        }
    }

    @Override
    public final boolean isCreated() {
        return this.zzc > 0;
    }

    @Override
    public final boolean isStarted() {
        return this.zzc >= 2;
    }
}

