/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal.safeparcel;

import android.app.PendingIntent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.SparseLongArray;
import androidx.annotation.NonNull;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class SafeParcelReader {
    private SafeParcelReader() {
    }

    public static int readHeader(@NonNull Parcel p) {
        return p.readInt();
    }

    public static int getFieldId(int header) {
        return (char)header;
    }

    /*
     * WARNING - void declaration
     */
    public static int readSize(@NonNull Parcel p, int header) {
        Parcel parcel;
        if ((header & 0xFFFF0000) != -65536) {
            void var1_1;
            return (char)(var1_1 >> 16);
        }
        return parcel.readInt();
    }

    public static void skipUnknownField(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        n = SafeParcelReader.readSize(p, n);
        Parcel parcel2 = parcel;
        parcel2.setDataPosition(parcel2.dataPosition() + n);
    }

    public static int validateObjectHeader(@NonNull Parcel p) {
        Parcel parcel;
        int n = SafeParcelReader.readHeader(p);
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (SafeParcelReader.getFieldId(n) != 20293) {
            String string2 = Integer.toHexString(n);
            String.valueOf(string2);
            String string3 = String.valueOf(string2);
            throw new ParseException("Expected object header. Got 0x".concat(string3), parcel);
        }
        n = n3 + n2;
        if (n < n3 || n > parcel.dataSize()) {
            n2 = String.valueOf(n3).length();
            int n4 = String.valueOf(n).length();
            StringBuilder stringBuilder = new StringBuilder((n2 += 32) + n4);
            stringBuilder.append("Size read is invalid start=");
            stringBuilder.append(n3);
            stringBuilder.append(" end=");
            stringBuilder.append(n);
            throw new ParseException(stringBuilder.toString(), parcel);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean readBoolean(@NonNull Parcel p, int header) {
        Parcel parcel;
        void var1_1;
        SafeParcelReader.zza(p, (int)var1_1, 4);
        return parcel.readInt() != 0;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static Boolean readBooleanObject(@NonNull Parcel p, int header) {
        boolean bl;
        Parcel parcel;
        void var1_2;
        int n = SafeParcelReader.readSize(p, (int)var1_2);
        if (n == 0) {
            return null;
        }
        SafeParcelReader.zzb(parcel, (int)var1_2, n, 4);
        if (parcel.readInt() != 0) {
            bl = true;
            return bl;
        }
        bl = false;
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static byte readByte(@NonNull Parcel p, int header) {
        Parcel parcel;
        void var1_1;
        SafeParcelReader.zza(p, (int)var1_1, 4);
        return (byte)parcel.readInt();
    }

    /*
     * WARNING - void declaration
     */
    public static char readChar(@NonNull Parcel p, int header) {
        Parcel parcel;
        void var1_1;
        SafeParcelReader.zza(p, (int)var1_1, 4);
        return (char)parcel.readInt();
    }

    /*
     * WARNING - void declaration
     */
    public static short readShort(@NonNull Parcel p, int header) {
        Parcel parcel;
        void var1_1;
        SafeParcelReader.zza(p, (int)var1_1, 4);
        return (short)parcel.readInt();
    }

    /*
     * WARNING - void declaration
     */
    public static int readInt(@NonNull Parcel p, int header) {
        Parcel parcel;
        void var1_1;
        SafeParcelReader.zza(p, (int)var1_1, 4);
        return parcel.readInt();
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static Integer readIntegerObject(@NonNull Parcel p, int header) {
        Parcel parcel;
        void var1_1;
        int n = SafeParcelReader.readSize(p, (int)var1_1);
        if (n == 0) {
            return null;
        }
        SafeParcelReader.zzb(parcel, (int)var1_1, n, 4);
        return parcel.readInt();
    }

    /*
     * WARNING - void declaration
     */
    public static long readLong(@NonNull Parcel p, int header) {
        Parcel parcel;
        void var1_1;
        SafeParcelReader.zza(p, (int)var1_1, 8);
        return parcel.readLong();
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static Long readLongObject(@NonNull Parcel p, int header) {
        Parcel parcel;
        void var1_1;
        int n = SafeParcelReader.readSize(p, (int)var1_1);
        if (n == 0) {
            return null;
        }
        SafeParcelReader.zzb(parcel, (int)var1_1, n, 8);
        return parcel.readLong();
    }

    @NonNull
    public static BigInteger createBigInteger(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        n = SafeParcelReader.readSize(p, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        byte[] byArray = parcel.createByteArray();
        parcel.setDataPosition(n2 + n);
        return new BigInteger(byArray);
    }

    /*
     * WARNING - void declaration
     */
    public static float readFloat(@NonNull Parcel p, int header) {
        Parcel parcel;
        void var1_1;
        SafeParcelReader.zza(p, (int)var1_1, 4);
        return parcel.readFloat();
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static Float readFloatObject(@NonNull Parcel p, int header) {
        Parcel parcel;
        void var1_1;
        int n = SafeParcelReader.readSize(p, (int)var1_1);
        if (n == 0) {
            return null;
        }
        SafeParcelReader.zzb(parcel, (int)var1_1, n, 4);
        return Float.valueOf(parcel.readFloat());
    }

    /*
     * WARNING - void declaration
     */
    public static double readDouble(@NonNull Parcel p, int header) {
        Parcel parcel;
        void var1_1;
        SafeParcelReader.zza(p, (int)var1_1, 8);
        return parcel.readDouble();
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static Double readDoubleObject(@NonNull Parcel p, int header) {
        Parcel parcel;
        void var1_1;
        int n = SafeParcelReader.readSize(p, (int)var1_1);
        if (n == 0) {
            return null;
        }
        SafeParcelReader.zzb(parcel, (int)var1_1, n, 8);
        return parcel.readDouble();
    }

    @NonNull
    public static BigDecimal createBigDecimal(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        n = SafeParcelReader.readSize(p, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        byte[] byArray = parcel.createByteArray();
        int n3 = parcel.readInt();
        parcel.setDataPosition(n2 + n);
        return new BigDecimal(new BigInteger(byArray), n3);
    }

    @NonNull
    public static String createString(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        n = SafeParcelReader.readSize(p, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        String string2 = parcel.readString();
        parcel.setDataPosition(n2 + n);
        return string2;
    }

    @NonNull
    public static IBinder readIBinder(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        n = SafeParcelReader.readSize(p, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        IBinder iBinder = parcel.readStrongBinder();
        parcel.setDataPosition(n2 + n);
        return iBinder;
    }

    @NonNull
    public static PendingIntent readPendingIntent(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        n = SafeParcelReader.readSize(p, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        PendingIntent pendingIntent = PendingIntent.readPendingIntentOrNullFromParcel((Parcel)parcel);
        parcel.setDataPosition(n2 + n);
        return pendingIntent;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static <T extends Parcelable> T createParcelable(@NonNull Parcel p, int header, @NonNull Parcelable.Creator<T> creator) {
        void var2_2;
        Parcel parcel;
        int n;
        n = SafeParcelReader.readSize(p, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        Parcelable parcelable = (Parcelable)var2_2.createFromParcel(parcel);
        parcel.setDataPosition(n2 + n);
        return (T)parcelable;
    }

    @NonNull
    public static Bundle createBundle(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        n = SafeParcelReader.readSize(p, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        Bundle bundle = parcel.readBundle();
        parcel.setDataPosition(n2 + n);
        return bundle;
    }

    @NonNull
    public static byte[] createByteArray(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        n = SafeParcelReader.readSize(p, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        byte[] byArray = parcel.createByteArray();
        parcel.setDataPosition(n2 + n);
        return byArray;
    }

    @NonNull
    public static byte[][] createByteArrayArray(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        int n2 = SafeParcelReader.readSize(p, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        byte[][] byArrayArray = new byte[n4][];
        for (n = 0; n < n4; ++n) {
            byArrayArray[n] = parcel.createByteArray();
        }
        parcel.setDataPosition(n3 + n2);
        return byArrayArray;
    }

    @NonNull
    public static boolean[] createBooleanArray(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        n = SafeParcelReader.readSize(p, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        boolean[] blArray = parcel.createBooleanArray();
        parcel.setDataPosition(n2 + n);
        return blArray;
    }

    @NonNull
    public static char[] createCharArray(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        n = SafeParcelReader.readSize(p, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        char[] cArray = parcel.createCharArray();
        parcel.setDataPosition(n2 + n);
        return cArray;
    }

    @NonNull
    public static int[] createIntArray(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        n = SafeParcelReader.readSize(p, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        int[] nArray = parcel.createIntArray();
        parcel.setDataPosition(n2 + n);
        return nArray;
    }

    @NonNull
    public static long[] createLongArray(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        n = SafeParcelReader.readSize(p, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        long[] lArray = parcel.createLongArray();
        parcel.setDataPosition(n2 + n);
        return lArray;
    }

    @NonNull
    public static BigInteger[] createBigIntegerArray(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        int n2 = SafeParcelReader.readSize(p, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        BigInteger[] bigIntegerArray = new BigInteger[n4];
        for (n = 0; n < n4; ++n) {
            bigIntegerArray[n] = new BigInteger(parcel.createByteArray());
        }
        parcel.setDataPosition(n3 + n2);
        return bigIntegerArray;
    }

    @NonNull
    public static float[] createFloatArray(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        n = SafeParcelReader.readSize(p, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        float[] fArray = parcel.createFloatArray();
        parcel.setDataPosition(n2 + n);
        return fArray;
    }

    @NonNull
    public static double[] createDoubleArray(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        n = SafeParcelReader.readSize(p, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        double[] dArray = parcel.createDoubleArray();
        parcel.setDataPosition(n2 + n);
        return dArray;
    }

    @NonNull
    public static BigDecimal[] createBigDecimalArray(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        int n2 = SafeParcelReader.readSize(p, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        BigDecimal[] bigDecimalArray = new BigDecimal[n4];
        for (n = 0; n < n4; ++n) {
            byte[] byArray = parcel.createByteArray();
            int n5 = parcel.readInt();
            bigDecimalArray[n] = new BigDecimal(new BigInteger(byArray), n5);
        }
        parcel.setDataPosition(n3 + n2);
        return bigDecimalArray;
    }

    @NonNull
    public static String[] createStringArray(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        n = SafeParcelReader.readSize(p, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        String[] stringArray = parcel.createStringArray();
        parcel.setDataPosition(n2 + n);
        return stringArray;
    }

    @NonNull
    public static IBinder[] createIBinderArray(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        n = SafeParcelReader.readSize(p, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        IBinder[] iBinderArray = parcel.createBinderArray();
        parcel.setDataPosition(n2 + n);
        return iBinderArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public static ArrayList<Boolean> createBooleanList(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        int n2 = SafeParcelReader.readSize(p, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        int n4 = parcel.readInt();
        n = 0;
        while (true) {
            if (n >= n4) {
                parcel.setDataPosition(n3 + n2);
                return arrayList;
            }
            boolean bl = parcel.readInt() != 0;
            arrayList.add(bl);
            ++n;
        }
    }

    @NonNull
    public static ArrayList<Integer> createIntegerList(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        int n2 = SafeParcelReader.readSize(p, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n4 = parcel.readInt();
        for (n = 0; n < n4; ++n) {
            arrayList.add(parcel.readInt());
        }
        parcel.setDataPosition(n3 + n2);
        return arrayList;
    }

    @NonNull
    public static SparseBooleanArray createSparseBooleanArray(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        n = SafeParcelReader.readSize(p, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        SparseBooleanArray sparseBooleanArray = parcel.readSparseBooleanArray();
        parcel.setDataPosition(n2 + n);
        return sparseBooleanArray;
    }

    @NonNull
    public static SparseIntArray createSparseIntArray(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        int n2 = SafeParcelReader.readSize(p, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        SparseIntArray sparseIntArray = new SparseIntArray();
        int n4 = parcel.readInt();
        for (n = 0; n < n4; ++n) {
            sparseIntArray.append(parcel.readInt(), parcel.readInt());
        }
        parcel.setDataPosition(n3 + n2);
        return sparseIntArray;
    }

    @NonNull
    public static SparseArray<Float> createFloatSparseArray(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        int n2 = SafeParcelReader.readSize(p, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        SparseArray sparseArray = new SparseArray();
        int n4 = parcel.readInt();
        for (n = 0; n < n4; ++n) {
            sparseArray.append(parcel.readInt(), (Object)Float.valueOf(parcel.readFloat()));
        }
        parcel.setDataPosition(n3 + n2);
        return sparseArray;
    }

    @NonNull
    public static SparseArray<Double> createDoubleSparseArray(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        int n2 = SafeParcelReader.readSize(p, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        SparseArray sparseArray = new SparseArray();
        int n4 = parcel.readInt();
        for (n = 0; n < n4; ++n) {
            sparseArray.append(parcel.readInt(), (Object)parcel.readDouble());
        }
        parcel.setDataPosition(n3 + n2);
        return sparseArray;
    }

    @NonNull
    public static SparseLongArray createSparseLongArray(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        int n2 = SafeParcelReader.readSize(p, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        SparseLongArray sparseLongArray = new SparseLongArray();
        int n4 = parcel.readInt();
        for (n = 0; n < n4; ++n) {
            sparseLongArray.append(parcel.readInt(), parcel.readLong());
        }
        parcel.setDataPosition(n3 + n2);
        return sparseLongArray;
    }

    @NonNull
    public static SparseArray<String> createStringSparseArray(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        int n2 = SafeParcelReader.readSize(p, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        SparseArray sparseArray = new SparseArray();
        int n4 = parcel.readInt();
        for (n = 0; n < n4; ++n) {
            sparseArray.append(parcel.readInt(), (Object)parcel.readString());
        }
        parcel.setDataPosition(n3 + n2);
        return sparseArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public static SparseArray<Parcel> createParcelSparseArray(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        int n2 = SafeParcelReader.readSize(p, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        SparseArray sparseArray = new SparseArray();
        n = 0;
        while (true) {
            if (n >= n4) {
                parcel.setDataPosition(n3 + n2);
                return sparseArray;
            }
            int n5 = parcel.readInt();
            int n6 = parcel.readInt();
            if (n6 != 0) {
                int n7 = parcel.dataPosition();
                Parcel parcel2 = Parcel.obtain();
                parcel2.appendFrom(parcel, n7, n6);
                sparseArray.append(n5, (Object)parcel2);
                parcel.setDataPosition(n7 + n6);
            } else {
                sparseArray.append(n5, null);
            }
            ++n;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NonNull
    public static <T> SparseArray<T> createTypedSparseArray(@NonNull Parcel p, int header, @NonNull Parcelable.Creator<T> c) {
        Parcel parcel;
        int n;
        int n2 = SafeParcelReader.readSize(p, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        SparseArray sparseArray = new SparseArray();
        n = 0;
        while (true) {
            void var2_2;
            if (n >= n4) {
                parcel.setDataPosition(n3 + n2);
                return sparseArray;
            }
            int n5 = parcel.readInt();
            Object object = parcel.readInt() != 0 ? var2_2.createFromParcel(parcel) : null;
            sparseArray.append(n5, object);
            ++n;
        }
    }

    @NonNull
    public static SparseArray<IBinder> createIBinderSparseArray(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        int n2 = SafeParcelReader.readSize(p, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        SparseArray sparseArray = new SparseArray(n4);
        for (n = 0; n < n4; ++n) {
            sparseArray.append(parcel.readInt(), (Object)parcel.readStrongBinder());
        }
        parcel.setDataPosition(n3 + n2);
        return sparseArray;
    }

    @NonNull
    public static SparseArray<byte[]> createByteArraySparseArray(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        int n2 = SafeParcelReader.readSize(p, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        SparseArray sparseArray = new SparseArray(n4);
        for (n = 0; n < n4; ++n) {
            sparseArray.append(parcel.readInt(), (Object)parcel.createByteArray());
        }
        parcel.setDataPosition(n3 + n2);
        return sparseArray;
    }

    @NonNull
    public static ArrayList<Long> createLongList(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        int n2 = SafeParcelReader.readSize(p, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        int n4 = parcel.readInt();
        for (n = 0; n < n4; ++n) {
            arrayList.add(parcel.readLong());
        }
        parcel.setDataPosition(n3 + n2);
        return arrayList;
    }

    @NonNull
    public static ArrayList<Float> createFloatList(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        int n2 = SafeParcelReader.readSize(p, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        ArrayList<Float> arrayList = new ArrayList<Float>();
        int n4 = parcel.readInt();
        for (n = 0; n < n4; ++n) {
            arrayList.add(Float.valueOf(parcel.readFloat()));
        }
        parcel.setDataPosition(n3 + n2);
        return arrayList;
    }

    @NonNull
    public static ArrayList<Double> createDoubleList(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        int n2 = SafeParcelReader.readSize(p, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n4 = parcel.readInt();
        for (n = 0; n < n4; ++n) {
            arrayList.add(parcel.readDouble());
        }
        parcel.setDataPosition(n3 + n2);
        return arrayList;
    }

    @NonNull
    public static ArrayList<String> createStringList(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        n = SafeParcelReader.readSize(p, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        ArrayList arrayList = parcel.createStringArrayList();
        parcel.setDataPosition(n2 + n);
        return arrayList;
    }

    @NonNull
    public static ArrayList<IBinder> createIBinderList(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        n = SafeParcelReader.readSize(p, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        ArrayList arrayList = parcel.createBinderArrayList();
        parcel.setDataPosition(n2 + n);
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static <T> T[] createTypedArray(@NonNull Parcel p, int header, @NonNull Parcelable.Creator<T> c) {
        void var2_2;
        Parcel parcel;
        int n;
        n = SafeParcelReader.readSize(p, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        Object[] objectArray = parcel.createTypedArray((Parcelable.Creator)var2_2);
        parcel.setDataPosition(n2 + n);
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static <T> ArrayList<T> createTypedList(@NonNull Parcel p, int header, @NonNull Parcelable.Creator<T> c) {
        void var2_2;
        Parcel parcel;
        int n;
        n = SafeParcelReader.readSize(p, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        ArrayList arrayList = parcel.createTypedArrayList((Parcelable.Creator)var2_2);
        parcel.setDataPosition(n2 + n);
        return arrayList;
    }

    @NonNull
    public static Parcel createParcel(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        n = SafeParcelReader.readSize(p, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        Parcel parcel2 = Parcel.obtain();
        parcel2.appendFrom(parcel, n2, n);
        parcel.setDataPosition(n2 + n);
        return parcel2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public static Parcel[] createParcelArray(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        int n2 = SafeParcelReader.readSize(p, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        Parcel[] parcelArray = new Parcel[n4];
        n = 0;
        while (true) {
            if (n >= n4) {
                parcel.setDataPosition(n3 + n2);
                return parcelArray;
            }
            int n5 = parcel.readInt();
            if (n5 != 0) {
                int n6 = parcel.dataPosition();
                Parcel.obtain().appendFrom(parcel, n6, n5);
                parcel.setDataPosition(n6 + n5);
            } else {
                parcelArray[n] = null;
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public static ArrayList<Parcel> createParcelList(@NonNull Parcel p, int header) {
        Parcel parcel;
        int n;
        int n2 = SafeParcelReader.readSize(p, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        ArrayList<Parcel> arrayList = new ArrayList<Parcel>();
        n = 0;
        while (true) {
            if (n >= n4) {
                parcel.setDataPosition(n3 + n2);
                return arrayList;
            }
            int n5 = parcel.readInt();
            if (n5 != 0) {
                int n6 = parcel.dataPosition();
                Parcel parcel2 = Parcel.obtain();
                parcel2.appendFrom(parcel, n6, n5);
                arrayList.add(parcel2);
                parcel.setDataPosition(n6 + n5);
            } else {
                arrayList.add(null);
            }
            ++n;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void readList(@NonNull Parcel p, int header, @NonNull List list, @NonNull ClassLoader loader) {
        void var3_3;
        void var2_2;
        Parcel parcel;
        int n;
        n = SafeParcelReader.readSize(p, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return;
        }
        parcel.readList((List)var2_2, (ClassLoader)var3_3);
        parcel.setDataPosition(n2 + n);
    }

    /*
     * WARNING - void declaration
     */
    public static void ensureAtEnd(@NonNull Parcel parcel, int end) {
        void var1_1;
        if (parcel.dataPosition() != var1_1) {
            Parcel parcel2;
            int n = String.valueOf((int)var1_1).length();
            StringBuilder stringBuilder = new StringBuilder(n + 26);
            stringBuilder.append("Overread allowed size end=");
            stringBuilder.append((int)var1_1);
            throw new ParseException(stringBuilder.toString(), parcel2);
        }
    }

    private static void zza(Parcel parcel, int n, int n2) {
        if ((n = SafeParcelReader.readSize(parcel, n)) != n2) {
            String string2 = Integer.toHexString(n);
            String string3 = String.valueOf(n);
            int n3 = string3.length();
            string3 = String.valueOf(string2);
            int n4 = String.valueOf(n2).length() + 19 + n3 + 4 + string3.length();
            StringBuilder stringBuilder = new StringBuilder(n4 + 1);
            stringBuilder.append("Expected size ");
            stringBuilder.append(n2);
            stringBuilder.append(" got ");
            stringBuilder.append(n);
            stringBuilder.append(" (0x");
            stringBuilder.append(string2);
            stringBuilder.append(")");
            throw new ParseException(stringBuilder.toString(), parcel);
        }
    }

    private static void zzb(Parcel parcel, int n, int n2, int n3) {
        if (n2 != n3) {
            String string2 = Integer.toHexString(n2);
            String string3 = String.valueOf(n2);
            int n4 = string3.length();
            string3 = String.valueOf(string2);
            int n5 = String.valueOf(n3).length() + 19 + n4 + 4 + string3.length();
            StringBuilder stringBuilder = new StringBuilder(n5 + 1);
            stringBuilder.append("Expected size ");
            stringBuilder.append(n3);
            stringBuilder.append(" got ");
            stringBuilder.append(n2);
            stringBuilder.append(" (0x");
            stringBuilder.append(string2);
            stringBuilder.append(")");
            throw new ParseException(stringBuilder.toString(), parcel);
        }
    }

    public static class ParseException
    extends RuntimeException {
        /*
         * WARNING - void declaration
         */
        public ParseException(@NonNull String message, @NonNull Parcel p) {
            void var1_1;
            void var2_2;
            int n = p.dataPosition();
            int n2 = var2_2.dataSize();
            int n3 = String.valueOf(n).length();
            int n4 = String.valueOf(n2).length();
            n3 = String.valueOf(var1_1).length() + 13 + n3;
            StringBuilder stringBuilder = new StringBuilder(n3 + 6 + n4);
            stringBuilder.append((String)var1_1);
            stringBuilder.append(" Parcel: pos=");
            stringBuilder.append(n);
            stringBuilder.append(" size=");
            stringBuilder.append(n2);
            super(stringBuilder.toString());
        }
    }
}

