/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.zza;

@SafeParcelable.Class(creator="ConnectionResultCreator")
public final class ConnectionResult
extends AbstractSafeParcelable {
    @KeepForSdk
    public static final int UNKNOWN = -1;
    public static final int SUCCESS = 0;
    public static final int SERVICE_MISSING = 1;
    public static final int SERVICE_VERSION_UPDATE_REQUIRED = 2;
    public static final int SERVICE_DISABLED = 3;
    public static final int SIGN_IN_REQUIRED = 4;
    public static final int INVALID_ACCOUNT = 5;
    public static final int RESOLUTION_REQUIRED = 6;
    public static final int NETWORK_ERROR = 7;
    public static final int INTERNAL_ERROR = 8;
    public static final int SERVICE_INVALID = 9;
    public static final int DEVELOPER_ERROR = 10;
    public static final int LICENSE_CHECK_FAILED = 11;
    public static final int CANCELED = 13;
    public static final int TIMEOUT = 14;
    public static final int INTERRUPTED = 15;
    public static final int API_UNAVAILABLE = 16;
    public static final int SIGN_IN_FAILED = 17;
    public static final int SERVICE_UPDATING = 18;
    public static final int SERVICE_MISSING_PERMISSION = 19;
    public static final int RESTRICTED_PROFILE = 20;
    public static final int RESOLUTION_ACTIVITY_NOT_FOUND = 22;
    public static final int API_DISABLED = 23;
    public static final int API_DISABLED_FOR_CONNECTION = 24;
    @Deprecated
    public static final int DRIVE_EXTERNAL_STORAGE_REQUIRED = 1500;
    @ShowFirstParty
    @KeepForSdk
    @NonNull
    public static final ConnectionResult RESULT_SUCCESS = new ConnectionResult(0);
    @NonNull
    public static final Parcelable.Creator<ConnectionResult> CREATOR = new zza();
    @SafeParcelable.VersionField(id=1)
    final int zza;
    @SafeParcelable.Field(id=2, getter="getErrorCode")
    private final int zzb;
    @SafeParcelable.Field(id=3, getter="getResolution")
    @Nullable
    private final PendingIntent zzc;
    @SafeParcelable.Field(id=4, getter="getErrorMessage")
    @Nullable
    private final String zzd;

    @SafeParcelable.Constructor
    ConnectionResult(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) int n2, @Nullable @SafeParcelable.Param(id=3) PendingIntent pendingIntent, @Nullable @SafeParcelable.Param(id=4) String string) {
        this.zza = n;
        this.zzb = n2;
        this.zzc = pendingIntent;
        this.zzd = string;
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionResult(int statusCode) {
        this((int)var1_1, null, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionResult(int statusCode, @Nullable PendingIntent pendingIntent) {
        this((int)var1_1, (PendingIntent)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionResult(int statusCode, @Nullable PendingIntent pendingIntent, @Nullable String message) {
        this(1, (int)var1_1, (PendingIntent)var2_2, (String)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void startResolutionForResult(@NonNull Activity activity, int requestCode) throws IntentSender.SendIntentException {
        void var2_2;
        void var1_1;
        if (!this.hasResolution()) {
            return;
        }
        PendingIntent pendingIntent = this.zzc;
        Preconditions.checkNotNull(pendingIntent);
        var1_1.startIntentSenderForResult(pendingIntent.getIntentSender(), (int)var2_2, null, 0, 0, 0);
    }

    public boolean hasResolution() {
        return this.zzb != 0 && this.zzc != null;
    }

    public boolean isSuccess() {
        return this.zzb == 0;
    }

    public int getErrorCode() {
        return this.zzb;
    }

    @Nullable
    public PendingIntent getResolution() {
        return this.zzc;
    }

    @Nullable
    public String getErrorMessage() {
        return this.zzd;
    }

    public boolean equals(@Nullable Object o) {
        ConnectionResult connectionResult;
        if (o == this) {
            return true;
        }
        if (!(connectionResult instanceof ConnectionResult)) {
            return false;
        }
        connectionResult = connectionResult;
        return this.zzb == connectionResult.zzb && Objects.equal(this.zzc, connectionResult.zzc) && Objects.equal(this.zzd, connectionResult.zzd);
    }

    public int hashCode() {
        return Objects.hashCode(this.zzb, this.zzc, this.zzd);
    }

    @NonNull
    public String toString() {
        Objects.ToStringHelper toStringHelper = Objects.toStringHelper(this);
        int n = this.zzb;
        toStringHelper.add("statusCode", ConnectionResult.zza(n));
        toStringHelper.add("resolution", this.zzc);
        toStringHelper.add("message", this.zzd);
        return toStringHelper.toString();
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        int n = this.zza;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)var1_1);
        SafeParcelWriter.writeInt((Parcel)var1_1, 1, n);
        SafeParcelWriter.writeInt((Parcel)var1_1, 2, this.getErrorCode());
        SafeParcelWriter.writeParcelable((Parcel)var1_1, 3, (Parcelable)this.getResolution(), (int)var2_2, false);
        void v1 = var1_1;
        SafeParcelWriter.writeString((Parcel)v1, 4, this.getErrorMessage(), false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    static String zza(int n) {
        switch (n) {
            default: {
                int n2 = String.valueOf(n).length();
                StringBuilder stringBuilder = new StringBuilder(n2 + 20);
                stringBuilder.append("UNKNOWN_ERROR_CODE(");
                stringBuilder.append(n);
                stringBuilder.append(")");
                return stringBuilder.toString();
            }
            case 1500: {
                return "DRIVE_EXTERNAL_STORAGE_REQUIRED";
            }
            case 99: {
                return "UNFINISHED";
            }
            case 25: {
                return "API_INSTALL_REQUIRED";
            }
            case 24: {
                return "API_DISABLED_FOR_CONNECTION";
            }
            case 23: {
                return "API_DISABLED";
            }
            case 22: {
                return "RESOLUTION_ACTIVITY_NOT_FOUND";
            }
            case 21: {
                return "API_VERSION_UPDATE_REQUIRED";
            }
            case 20: {
                return "RESTRICTED_PROFILE";
            }
            case 19: {
                return "SERVICE_MISSING_PERMISSION";
            }
            case 18: {
                return "SERVICE_UPDATING";
            }
            case 17: {
                return "SIGN_IN_FAILED";
            }
            case 16: {
                return "API_UNAVAILABLE";
            }
            case 15: {
                return "INTERRUPTED";
            }
            case 14: {
                return "TIMEOUT";
            }
            case 13: {
                return "CANCELED";
            }
            case 11: {
                return "LICENSE_CHECK_FAILED";
            }
            case 10: {
                return "DEVELOPER_ERROR";
            }
            case 9: {
                return "SERVICE_INVALID";
            }
            case 8: {
                return "INTERNAL_ERROR";
            }
            case 7: {
                return "NETWORK_ERROR";
            }
            case 6: {
                return "RESOLUTION_REQUIRED";
            }
            case 5: {
                return "INVALID_ACCOUNT";
            }
            case 4: {
                return "SIGN_IN_REQUIRED";
            }
            case 3: {
                return "SERVICE_DISABLED";
            }
            case 2: {
                return "SERVICE_VERSION_UPDATE_REQUIRED";
            }
            case 1: {
                return "SERVICE_MISSING";
            }
            case 0: {
                return "SUCCESS";
            }
            case -1: 
        }
        return "UNKNOWN";
    }
}

