/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.annotation.TargetApi;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Build;
import android.os.UserManager;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.GooglePlayServicesIncorrectManifestValueException;
import com.google.android.gms.common.GooglePlayServicesMissingManifestValueException;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.R;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.HideFirstParty;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.zzae;
import com.google.android.gms.common.util.ClientLibraryUtils;
import com.google.android.gms.common.util.DeviceProperties;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.zzb;
import com.google.android.gms.common.wrappers.PackageManagerWrapper;
import com.google.android.gms.common.wrappers.Wrappers;
import java.util.concurrent.atomic.AtomicBoolean;

@ShowFirstParty
@KeepForSdk
public class GooglePlayServicesUtilLight {
    @Deprecated
    @KeepForSdk
    public static final int GOOGLE_PLAY_SERVICES_VERSION_CODE = 12451000;
    @Deprecated
    @KeepForSdk
    @NonNull
    public static final String GOOGLE_PLAY_SERVICES_PACKAGE = "com.google.android.gms";
    @KeepForSdk
    @NonNull
    public static final String GOOGLE_PLAY_GAMES_PACKAGE = "com.google.android.play.games";
    @KeepForSdk
    @NonNull
    public static final String GOOGLE_SERVICES_FRAMEWORK_PACKAGE = "com.google.android.gsf";
    @KeepForSdk
    @NonNull
    public static final String GOOGLE_PLAY_STORE_PACKAGE = "com.android.vending";
    @KeepForSdk
    static final int GMS_GENERAL_ERROR_NOTIFICATION_ID = 39789;
    @KeepForSdk
    static final int GMS_AVAILABILITY_NOTIFICATION_ID = 10436;
    @Deprecated
    @KeepForSdk
    static final AtomicBoolean sCanceledAvailabilityNotification;
    @VisibleForTesting
    public static boolean zza;
    @VisibleForTesting
    public static boolean zzb;
    private static final AtomicBoolean zzc;

    @ShowFirstParty
    @KeepForSdk
    public static void enableUsingApkIndependentContext() {
        zzc.set(true);
    }

    @KeepForSdk
    GooglePlayServicesUtilLight() {
    }

    @Deprecated
    @KeepForSdk
    @NonNull
    public static String getErrorString(int errorCode) {
        return ConnectionResult.zza(errorCode);
    }

    @Deprecated
    @HideFirstParty
    @KeepForSdk
    public static int isGooglePlayServicesAvailable(@NonNull Context context) {
        return GooglePlayServicesUtilLight.isGooglePlayServicesAvailable(context, GOOGLE_PLAY_SERVICES_VERSION_CODE);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    @KeepForSdk
    public static int isGooglePlayServicesAvailable(@NonNull Context context, int minApkVersion) {
        PackageInfo packageInfo;
        PackageInfo packageInfo2;
        void var1_5;
        Object object;
        String string2;
        try {
            context.getResources().getString(R.string.common_google_play_services_unknown_issue);
        }
        catch (Throwable throwable) {
            Log.e((String)"GooglePlayServicesUtil", (String)"The Google Play services resources were not found. Check your project configuration to ensure that the resources are included.");
        }
        if (!GOOGLE_PLAY_SERVICES_PACKAGE.equals(string2 = object.getPackageName()) && !zzc.get()) {
            int n = zzae.zzb((Context)object);
            if (n == 0) {
                throw new GooglePlayServicesMissingManifestValueException();
            }
            if (n != GOOGLE_PLAY_SERVICES_VERSION_CODE) {
                throw new GooglePlayServicesIncorrectManifestValueException(n);
            }
        }
        int n = !DeviceProperties.isWearableWithoutPlayStore((Context)object) ? (!DeviceProperties.zzd((Context)object) ? 1 : 0) : 0;
        int n2 = var1_5 >= 0 ? 1 : 0;
        Preconditions.checkArgument(n2 != 0);
        String string3 = object.getPackageName();
        PackageManager packageManager = object.getPackageManager();
        if (n != 0) {
            n2 = Build.VERSION.SDK_INT;
            n2 = n2 >= 28 ? 134225984 : 8256;
            packageInfo2 = packageManager.getPackageInfo(GOOGLE_PLAY_STORE_PACKAGE, n2);
        }
        packageInfo2 = null;
        try {
            int n3 = Build.VERSION.SDK_INT;
            n3 = n3 >= 28 ? 0x8000040 : 64;
            packageInfo = packageManager.getPackageInfo(GOOGLE_PLAY_SERVICES_PACKAGE, n3);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String.valueOf(string3);
            object = String.valueOf(string3);
            String string4 = " requires Google Play services, but they are missing.";
            Log.w((String)"GooglePlayServicesUtil", (String)((String)object).concat(string4));
            return 1;
        }
        GoogleSignatureVerifier.getInstance((Context)object);
        if (!GoogleSignatureVerifier.zza(packageInfo, true)) {
            String.valueOf(string3);
            object = String.valueOf(string3);
            String string5 = " requires Google Play services, but their signature is invalid.";
            Log.w((String)"GooglePlayServicesUtil", (String)((String)object).concat(string5));
            return 9;
        }
        if (n != 0) {
            Preconditions.checkNotNull(packageInfo2);
            if (!GoogleSignatureVerifier.zza(packageInfo2, true)) {
                String.valueOf(string3);
                object = String.valueOf(string3);
                String string6 = " requires Google Play Store, but its signature is invalid.";
                Log.w((String)"GooglePlayServicesUtil", (String)((String)object).concat(string6));
                return 9;
            }
        }
        if (n != 0 && packageInfo2 != null && !packageInfo2.signatures[0].equals((Object)packageInfo.signatures[0])) {
            String.valueOf(string3);
            object = String.valueOf(string3);
            String string7 = " requires Google Play Store, but its signature doesn't match that of Google Play services.";
            Log.w((String)"GooglePlayServicesUtil", (String)((String)object).concat(string7));
            return 9;
        }
        if (com.google.android.gms.common.util.zzb.zza(packageInfo.versionCode) < com.google.android.gms.common.util.zzb.zza((int)var1_5)) {
            int n4 = packageInfo.versionCode;
            int n5 = String.valueOf(string3).length();
            n5 += 49;
            n = String.valueOf((int)var1_5).length();
            n5 = n5 + n + 11;
            n = String.valueOf(n4).length();
            StringBuilder stringBuilder = new StringBuilder(n5 + n);
            stringBuilder.append("Google Play services out of date for ");
            stringBuilder.append(string3);
            stringBuilder.append(".  Requires ");
            stringBuilder.append((int)var1_5);
            stringBuilder.append(" but found ");
            stringBuilder.append(n4);
            String string8 = stringBuilder.toString();
            Log.w((String)"GooglePlayServicesUtil", (String)string8);
            return 2;
        }
        object = packageInfo.applicationInfo;
        if (object == null) {
            object = packageManager.getApplicationInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 0);
        }
        if (((ApplicationInfo)object).enabled) return 0;
        return 3;
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String.valueOf(string3);
            object = String.valueOf(string3);
            String string9 = " requires the Google Play Store, but it is missing.";
            Log.w((String)"GooglePlayServicesUtil", (String)((String)object).concat(string9));
            return 9;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String.valueOf(string3);
            String string10 = String.valueOf(string3);
            String string11 = " requires Google Play services, but they're missing when getting application info.";
            Log.wtf((String)"GooglePlayServicesUtil", (String)string10.concat(string11), (Throwable)nameNotFoundException);
            return 1;
        }
    }

    @Deprecated
    @KeepForSdk
    public static void ensurePlayServicesAvailable(@NonNull Context context, int minApkVersion) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        int n;
        Context context2;
        n = GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(context2, n);
        if (n != 0) {
            String string2 = "e";
            context2 = GoogleApiAvailabilityLight.getInstance().getErrorResolutionIntent(context2, n, string2);
            int n2 = String.valueOf(n).length();
            StringBuilder stringBuilder = new StringBuilder(n2 + 46);
            stringBuilder.append("GooglePlayServices not available due to error ");
            stringBuilder.append(n);
            String string3 = stringBuilder.toString();
            Log.e((String)"GooglePlayServicesUtil", (String)string3);
            if (context2 == null) {
                throw new GooglePlayServicesNotAvailableException(n);
            }
            string3 = "Google Play Services not available";
            throw new GooglePlayServicesRepairableException(n, string3, (Intent)context2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @KeepForSdk
    public static boolean isGooglePlayServicesUid(@NonNull Context context, int uid) {
        void var1_1;
        return UidVerifier.isGooglePlayServicesUid(context, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @TargetApi(value=19)
    @KeepForSdk
    public static boolean uidHasPackageName(@NonNull Context context, int uid, @NonNull String packageName) {
        void var2_2;
        void var1_1;
        return UidVerifier.uidHasPackageName(context, (int)var1_1, (String)var2_2);
    }

    @Deprecated
    @ShowFirstParty
    @KeepForSdk
    @Nullable
    public static Intent getGooglePlayServicesAvailabilityRecoveryIntent(int errorCode) {
        int n;
        return GoogleApiAvailabilityLight.getInstance().getErrorResolutionIntent(null, n, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ShowFirstParty
    @KeepForSdk
    public static boolean honorsDebugCertificates(@NonNull Context context) {
        if (zzb) return zza || !DeviceProperties.isUserBuild();
        try {
            boolean bl;
            Context context2;
            PackageManagerWrapper packageManagerWrapper = Wrappers.packageManager(context2);
            int n = Build.VERSION.SDK_INT;
            n = n >= 28 ? 0x8000040 : 64;
            PackageInfo packageInfo = packageManagerWrapper.getPackageInfo(GOOGLE_PLAY_SERVICES_PACKAGE, n);
            GoogleSignatureVerifier.getInstance(context2);
            if (packageInfo != null && !(bl = GoogleSignatureVerifier.zza(packageInfo, false)) && (bl = GoogleSignatureVerifier.zza(packageInfo, true))) {
                zza = true;
            } else {
                zza = false;
            }
            zzb = true;
            return zza || !DeviceProperties.isUserBuild();
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Cannot find Google Play services package name.", (Throwable)nameNotFoundException);
        }
        catch (Throwable throwable) {
            zzb = true;
            throw throwable;
        }
        zzb = true;
        return zza || !DeviceProperties.isUserBuild();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @KeepForSdk
    @Nullable
    public static PendingIntent getErrorPendingIntent(int errorCode, @NonNull Context context, int requestCode) {
        void var2_2;
        int n;
        void var1_1;
        return GoogleApiAvailabilityLight.getInstance().getErrorResolutionPendingIntent((Context)var1_1, n, (int)var2_2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    @KeepForSdk
    public static void cancelAvailabilityErrorNotifications(@NonNull Context context) {
        if (sCanceledAvailabilityNotification.getAndSet(true)) return;
        try {
            Context context2;
            if ((context2 = (NotificationManager)context2.getSystemService("notification")) == null) return;
            context2.cancel(10436);
            return;
        }
        catch (SecurityException securityException) {
            Log.d((String)"GooglePlayServicesUtil", (String)"Suppressing Security Exception %s in cancelAvailabilityErrorNotifications.", (Throwable)securityException);
            return;
        }
    }

    @Deprecated
    @KeepForSdk
    public static boolean isUserRecoverableError(int errorCode) {
        switch (errorCode) {
            default: {
                return false;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
        }
        return true;
    }

    @KeepForSdk
    @Nullable
    public static Resources getRemoteResource(@NonNull Context context) {
        try {
            Context context2 = context.getPackageManager().getResourcesForApplication(GOOGLE_PLAY_SERVICES_PACKAGE);
            return context2;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    @KeepForSdk
    @Nullable
    public static Context getRemoteContext(@NonNull Context context) {
        try {
            Context context2 = context.createPackageContext(GOOGLE_PLAY_SERVICES_PACKAGE, 3);
            return context2;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    @Deprecated
    @ShowFirstParty
    @KeepForSdk
    public static int getClientVersion(@NonNull Context context) {
        Context context2;
        Preconditions.checkState(true);
        Context context3 = context2;
        return ClientLibraryUtils.getClientVersion(context3, context3.getPackageName());
    }

    @Deprecated
    @ShowFirstParty
    @KeepForSdk
    public static int getApkVersion(@NonNull Context context) {
        try {
            Context context2 = context.getPackageManager().getPackageInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 0);
            return context2.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services is missing.");
            return 0;
        }
    }

    @Deprecated
    @ShowFirstParty
    @KeepForSdk
    public static boolean isSidewinderDevice(@NonNull Context context) {
        return DeviceProperties.isSidewinder(context);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @ShowFirstParty
    @KeepForSdk
    public static boolean isPlayServicesPossiblyUpdating(@NonNull Context context, int connectionStatusCode) {
        void var1_1;
        if (connectionStatusCode == 18) {
            return true;
        }
        if (var1_1 == true) {
            Context context2;
            return GooglePlayServicesUtilLight.zza(context2, GOOGLE_PLAY_SERVICES_PACKAGE);
        }
        return false;
    }

    @Deprecated
    @ShowFirstParty
    @KeepForSdk
    public static boolean isPlayStorePossiblyUpdating(@NonNull Context context, int connectionStatusCode) {
        if (connectionStatusCode == 9) {
            Context context2;
            return GooglePlayServicesUtilLight.zza(context2, GOOGLE_PLAY_STORE_PACKAGE);
        }
        return false;
    }

    @TargetApi(value=18)
    @KeepForSdk
    public static boolean isRestrictedUserProfile(@NonNull Context context) {
        String string2;
        Context context2;
        Object object = context.getSystemService("user");
        Preconditions.checkNotNull(object);
        context2 = ((UserManager)object).getApplicationRestrictions(context2.getPackageName());
        return context2 != null && "true".equals(context2.getString(string2 = "restricted_profile"));
    }

    static {
        zza = false;
        zzb = false;
        sCanceledAvailabilityNotification = new AtomicBoolean();
        zzc = new AtomicBoolean();
    }

    /*
     * Loose catch block
     */
    @TargetApi(value=21)
    static boolean zza(Context context, String string2) {
        block9: {
            block8: {
                boolean bl = string2.equals(GOOGLE_PLAY_SERVICES_PACKAGE);
                Object object = context.getPackageManager().getPackageInstaller().getAllSessions();
                object = object.iterator();
                while (object.hasNext()) {
                    if (!string2.equals(((PackageInstaller.SessionInfo)object.next()).getAppPackageName())) continue;
                    return true;
                }
                object = context.getPackageManager();
                try {
                    string2 = object.getApplicationInfo(string2, 8192);
                    if (!bl) break block8;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    return false;
                }
                boolean bl2 = ((ApplicationInfo)string2).enabled;
                return bl2;
            }
            boolean bl = ((ApplicationInfo)string2).enabled;
            if (!bl) break block9;
            boolean bl3 = GooglePlayServicesUtilLight.isRestrictedUserProfile(context);
            if (bl3) break block9;
            return true;
        }
        return false;
        catch (Exception exception) {
            return false;
        }
    }
}

