/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.credentials.IdToken;
import com.google.android.gms.auth.api.credentials.zza;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import java.util.Collections;
import java.util.List;

public class Credential
implements SafeParcelable {
    public static final String EXTRA_KEY = "com.google.android.gms.credentials.Credential";
    public static final Parcelable.Creator<Credential> CREATOR = new zza();
    final int mVersionCode;
    private final String zzwN;
    private final String mName;
    private final Uri zzSh;
    private final List<IdToken> zzSi;
    private final String zzSj;
    private final String zzSk;
    private final String zzSl;
    private final String zzSm;

    Credential(int version, String id, String name, Uri profilePictureUri, List<IdToken> idTokens, String password, String accountType, String generatedPassword, String generatedHintId) {
        this.mVersionCode = version;
        this.zzwN = zzx.zzw(id);
        this.mName = name;
        this.zzSh = profilePictureUri;
        this.zzSi = idTokens == null ? Collections.emptyList() : Collections.unmodifiableList(idTokens);
        this.zzSj = password;
        this.zzSk = accountType;
        this.zzSl = generatedPassword;
        this.zzSm = generatedHintId;
    }

    public String getId() {
        return this.zzwN;
    }

    public String getName() {
        return this.mName;
    }

    public Uri getProfilePictureUri() {
        return this.zzSh;
    }

    public List<IdToken> getIdTokens() {
        return this.zzSi;
    }

    public String getPassword() {
        return this.zzSj;
    }

    public String getGeneratedPassword() {
        return this.zzSl;
    }

    public String getAccountType() {
        return this.zzSk;
    }

    public String zzlI() {
        return this.zzSm;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zza.zza(this, out, flags);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Credential)) {
            return false;
        }
        Credential credential = (Credential)other;
        return TextUtils.equals((CharSequence)this.zzwN, (CharSequence)credential.zzwN) && TextUtils.equals((CharSequence)this.mName, (CharSequence)credential.mName) && zzw.equal(this.zzSh, credential.zzSh) && TextUtils.equals((CharSequence)this.zzSj, (CharSequence)credential.zzSj) && TextUtils.equals((CharSequence)this.zzSk, (CharSequence)credential.zzSk) && TextUtils.equals((CharSequence)this.zzSl, (CharSequence)credential.zzSl);
    }

    public int hashCode() {
        return zzw.hashCode(this.zzwN, this.mName, this.zzSh, this.zzSj, this.zzSk, this.zzSl);
    }

    public static class Builder {
        private final String zzwN;
        private String mName;
        private Uri zzSh;
        private List<IdToken> zzSi;
        private String zzSj;
        private String zzSk;
        private String zzSl;
        private String zzSm;

        public Builder(String id) {
            this.zzwN = id;
        }

        public Builder(Credential credential) {
            this.zzwN = credential.zzwN;
            this.mName = credential.mName;
            this.zzSh = credential.zzSh;
            this.zzSi = credential.zzSi;
            this.zzSj = credential.zzSj;
            this.zzSk = credential.zzSk;
            this.zzSl = credential.zzSl;
            this.zzSm = credential.zzSm;
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setProfilePictureUri(Uri profilePictureUri) {
            this.zzSh = profilePictureUri;
            return this;
        }

        public Builder setPassword(String password) {
            this.zzSj = password;
            return this;
        }

        public Builder setAccountType(String accountType) {
            Uri uri = Uri.parse((String)accountType);
            String string2 = uri.getScheme();
            zzx.zzaa("http".equalsIgnoreCase(string2) || "https".equalsIgnoreCase(string2));
            this.zzSk = accountType;
            return this;
        }

        public Credential build() {
            if (!TextUtils.isEmpty((CharSequence)this.zzSj) && !TextUtils.isEmpty((CharSequence)this.zzSk)) {
                throw new IllegalStateException("Only one of password or accountType may be set");
            }
            return new Credential(3, this.zzwN, this.mName, this.zzSh, this.zzSi, this.zzSj, this.zzSk, this.zzSl, this.zzSm);
        }
    }
}

