/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.os.Parcel;
import android.text.TextUtils;
import com.google.android.gms.auth.api.credentials.zze;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;

public final class PasswordSpecification
implements SafeParcelable {
    public static final zze CREATOR = new zze();
    public static final PasswordSpecification zzSt = new zza().zzg(12, 16).zzbD("abcdefghijkmnopqrstxyzABCDEFGHJKLMNPQRSTXY3456789").zzf("abcdefghijkmnopqrstxyz", 1).zzf("ABCDEFGHJKLMNPQRSTXY", 1).zzf("3456789", 1).zzlK();
    public static final PasswordSpecification zzSu = new zza().zzg(12, 16).zzbD("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890").zzf("abcdefghijklmnopqrstuvwxyz", 1).zzf("ABCDEFGHIJKLMNOPQRSTUVWXYZ", 1).zzf("1234567890", 1).zzlK();
    final int mVersionCode;
    final String zzSv;
    final List<String> zzSw;
    final List<Integer> zzSx;
    final int zzSy;
    final int zzSz;
    private final int[] zzSA;
    private final Random zzts;

    PasswordSpecification(int version, String allowedChars, List<String> requiredCharSets, List<Integer> requiredCharCounts, int minimumSize, int maximumSize) {
        this.mVersionCode = version;
        this.zzSv = allowedChars;
        this.zzSw = Collections.unmodifiableList(requiredCharSets);
        this.zzSx = Collections.unmodifiableList(requiredCharCounts);
        this.zzSy = minimumSize;
        this.zzSz = maximumSize;
        this.zzSA = this.zzlJ();
        this.zzts = new SecureRandom();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zze.zza(this, out, flags);
    }

    private int[] zzlJ() {
        int[] nArray = new int[95];
        Arrays.fill(nArray, -1);
        int n = 0;
        for (String string2 : this.zzSw) {
            for (char c : string2.toCharArray()) {
                nArray[this.zza((char)c)] = n;
            }
            ++n;
        }
        return nArray;
    }

    private int zza(char c) {
        return c - 32;
    }

    private static String zzb(Collection<Character> collection) {
        char[] cArray = new char[collection.size()];
        int n = 0;
        for (char c : collection) {
            cArray[n++] = c;
        }
        return new String(cArray);
    }

    private static boolean zzb(int n, int n2, int n3) {
        return n < n2 || n > n3;
    }

    public static class zzb
    extends Error {
        public zzb(String string2) {
            super(string2);
        }
    }

    public static class zza {
        private final TreeSet<Character> zzSB = new TreeSet();
        private final List<String> zzSw = new ArrayList<String>();
        private final List<Integer> zzSx = new ArrayList<Integer>();
        private int zzSy = 12;
        private int zzSz = 16;

        public zza zzbD(String string2) {
            this.zzSB.addAll(this.zzr(string2, "allowedChars"));
            return this;
        }

        public zza zzf(String string2, int n) {
            if (n < 1) {
                throw new zzb("count must be at least 1");
            }
            TreeSet<Character> treeSet = this.zzr(string2, "requiredChars");
            this.zzSw.add(PasswordSpecification.zzb(treeSet));
            this.zzSx.add(n);
            return this;
        }

        public zza zzg(int n, int n2) {
            if (n < 1) {
                throw new zzb("minimumSize must be at least 1");
            }
            if (n > n2) {
                throw new zzb("maximumSize must be greater than or equal to minimumSize");
            }
            this.zzSy = n;
            this.zzSz = n2;
            return this;
        }

        public PasswordSpecification zzlK() {
            if (this.zzSB.isEmpty()) {
                throw new zzb("no allowed characters specified");
            }
            this.zzlL();
            this.zzlM();
            return new PasswordSpecification(1, PasswordSpecification.zzb(this.zzSB), this.zzSw, this.zzSx, this.zzSy, this.zzSz);
        }

        private TreeSet<Character> zzr(String string2, String string3) {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                throw new zzb(string3 + " cannot be null or empty");
            }
            TreeSet<Character> treeSet = new TreeSet<Character>();
            for (char c : string2.toCharArray()) {
                if (PasswordSpecification.zzb(c, 32, 126)) {
                    throw new zzb(string3 + " must only contain ASCII printable characters");
                }
                treeSet.add(Character.valueOf(c));
            }
            return treeSet;
        }

        private void zzlL() {
            int n = 0;
            for (int n2 : this.zzSx) {
                n += n2;
            }
            if (n > this.zzSz) {
                throw new zzb("required character count cannot be greater than the max password size");
            }
        }

        private void zzlM() {
            boolean[] blArray = new boolean[95];
            for (String string2 : this.zzSw) {
                for (char c : string2.toCharArray()) {
                    if (blArray[c - 32]) {
                        throw new zzb("character " + c + " occurs in more than one required character set");
                    }
                    blArray[c - 32] = true;
                }
            }
        }
    }
}

