/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.AppOpsManager;
import android.app.Dialog;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.UserManager;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import android.util.Log;
import android.util.TypedValue;
import com.google.android.gms.R;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.ErrorDialogFragment;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.SupportErrorDialogFragment;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.zzc;
import com.google.android.gms.common.zzd;
import com.google.android.gms.internal.zzml;
import com.google.android.gms.internal.zzmx;
import java.io.InputStream;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;

public final class GooglePlayServicesUtil {
    public static final String GMS_ERROR_DIALOG = "GooglePlayServicesErrorDialog";
    @Deprecated
    public static final int GOOGLE_PLAY_SERVICES_VERSION_CODE = GooglePlayServicesUtil.zzns();
    @Deprecated
    public static final String GOOGLE_PLAY_SERVICES_PACKAGE = "com.google.android.gms";
    public static final String GOOGLE_PLAY_STORE_PACKAGE = "com.android.vending";
    public static boolean zzaal = false;
    public static boolean zzaam = false;
    private static int zzaan = -1;
    private static final Object zzpy = new Object();
    private static String zzaao = null;
    private static Integer zzaap = null;
    static final AtomicBoolean zzaaq = new AtomicBoolean();
    private static final AtomicBoolean zzaar = new AtomicBoolean();

    private GooglePlayServicesUtil() {
    }

    private static int zzns() {
        return 8115000;
    }

    @Deprecated
    public static String getErrorString(int errorCode) {
        return ConnectionResult.getStatusString(errorCode);
    }

    @Deprecated
    public static int isGooglePlayServicesAvailable(Context context) {
        Resources resources;
        if (com.google.android.gms.common.internal.zzd.zzaeK) {
            return 0;
        }
        PackageManager packageManager = context.getPackageManager();
        try {
            resources = context.getResources();
            resources.getString(R.string.common_google_play_services_unknown_issue);
        }
        catch (Throwable throwable) {
            Log.e((String)"GooglePlayServicesUtil", (String)"The Google Play services resources were not found. Check your project configuration to ensure that the resources are included.");
        }
        if (!GOOGLE_PLAY_SERVICES_PACKAGE.equals(context.getPackageName())) {
            GooglePlayServicesUtil.zzad(context);
        }
        try {
            resources = packageManager.getPackageInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 64);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services is missing.");
            return 1;
        }
        zzd zzd2 = zzd.zznu();
        if (zzml.zzcb(resources.versionCode) || zzml.zzan(context)) {
            if (zzd2.zza((PackageInfo)resources, zzc.zzbz.zzaak) == null) {
                Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services signature invalid.");
                return 9;
            }
        } else {
            try {
                PackageInfo packageInfo = packageManager.getPackageInfo(GOOGLE_PLAY_STORE_PACKAGE, 8256);
                zzc.zza zza2 = zzd2.zza(packageInfo, zzc.zzbz.zzaak);
                if (zza2 == null) {
                    Log.w((String)"GooglePlayServicesUtil", (String)"Google Play Store signature invalid.");
                    return 9;
                }
                if (zzd2.zza((PackageInfo)resources, zza2) == null) {
                    Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services signature invalid.");
                    return 9;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.w((String)"GooglePlayServicesUtil", (String)"Google Play Store is neither installed nor updating.");
                return 9;
            }
        }
        int n = zzml.zzca(GOOGLE_PLAY_SERVICES_VERSION_CODE);
        int n2 = zzml.zzca(resources.versionCode);
        if (n2 < n) {
            Log.w((String)"GooglePlayServicesUtil", (String)("Google Play services out of date.  Requires " + GOOGLE_PLAY_SERVICES_VERSION_CODE + " but found " + resources.versionCode));
            return 2;
        }
        ApplicationInfo applicationInfo = resources.applicationInfo;
        if (applicationInfo == null) {
            try {
                applicationInfo = packageManager.getApplicationInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.wtf((String)"GooglePlayServicesUtil", (String)"Google Play services missing when getting application info.", (Throwable)nameNotFoundException);
                return 1;
            }
        }
        if (!applicationInfo.enabled) {
            return 3;
        }
        return 0;
    }

    @Deprecated
    public static void zzaa(Context context) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        int n = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context);
        if (n != 0) {
            Intent intent = GoogleApiAvailability.getInstance().zza(context, n, "e");
            Log.e((String)"GooglePlayServicesUtil", (String)("GooglePlayServices not available due to error " + n));
            if (intent == null) {
                throw new GooglePlayServicesNotAvailableException(n);
            }
            throw new GooglePlayServicesRepairableException(n, "Google Play Services not available", intent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zzad(Context context) {
        Integer n;
        if (zzaar.get()) {
            return;
        }
        Object object = zzpy;
        synchronized (object) {
            block12: {
                if (zzaao == null) {
                    zzaao = context.getPackageName();
                    try {
                        ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
                        Bundle bundle = applicationInfo.metaData;
                        if (bundle != null) {
                            zzaap = bundle.getInt("com.google.android.gms.version");
                            break block12;
                        }
                        zzaap = null;
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        Log.wtf((String)"GooglePlayServicesUtil", (String)"This should never happen.", (Throwable)nameNotFoundException);
                    }
                } else if (!zzaao.equals(context.getPackageName())) {
                    throw new IllegalArgumentException("isGooglePlayServicesAvailable should only be called with Context from your application's package. A previous call used package '" + zzaao + "' and this call used package '" + context.getPackageName() + "'.");
                }
            }
            n = zzaap;
        }
        if (n == null) {
            throw new IllegalStateException("A required meta-data tag in your app's AndroidManifest.xml does not exist.  You must have the following declaration within the <application> element:     <meta-data android:name=\"com.google.android.gms.version\" android:value=\"@integer/google_play_services_version\" />");
        }
        if (n != GOOGLE_PLAY_SERVICES_VERSION_CODE) {
            throw new IllegalStateException("The meta-data tag in your app's AndroidManifest.xml does not have the right value.  Expected " + GOOGLE_PLAY_SERVICES_VERSION_CODE + " but" + " found " + n + ".  You must have the" + " following declaration within the <application> element: " + "    <meta-data android:name=\"" + "com.google.android.gms.version" + "\" android:value=\"@integer/google_play_services_version\" />");
        }
    }

    public static boolean zze(Context context, int n) {
        return GooglePlayServicesUtil.zzb(context, n, GOOGLE_PLAY_SERVICES_PACKAGE) && GooglePlayServicesUtil.zzb(context.getPackageManager(), GOOGLE_PLAY_SERVICES_PACKAGE);
    }

    public static boolean zzb(Context context, int n, String string2) {
        if (zzmx.zzqB()) {
            AppOpsManager appOpsManager = (AppOpsManager)context.getSystemService("appops");
            try {
                appOpsManager.checkPackage(n, string2);
                return true;
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
        PackageManager packageManager = context.getPackageManager();
        String[] stringArray = packageManager.getPackagesForUid(n);
        if (string2 != null && stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string2.equals(stringArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static boolean zzb(PackageManager packageManager, String string2) {
        return zzd.zznu().zzb(packageManager, string2);
    }

    @Deprecated
    public static Intent zzbj(int n) {
        return GoogleApiAvailability.getInstance().zza(null, n, null);
    }

    public static boolean zznt() {
        if (zzaal) {
            return zzaam;
        }
        return "user".equals(Build.TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zzb(PackageManager packageManager) {
        Object object = zzpy;
        synchronized (object) {
            if (zzaan == -1) {
                try {
                    PackageInfo packageInfo = packageManager.getPackageInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 64);
                    zzaan = zzd.zznu().zza(packageInfo, zzc.zzaad[1]) != null ? 1 : 0;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    zzaan = 0;
                }
            }
            return zzaan != 0;
        }
    }

    public static boolean zzc(PackageManager packageManager) {
        return GooglePlayServicesUtil.zzb(packageManager) || !GooglePlayServicesUtil.zznt();
    }

    private static boolean zzbk(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 18: 
            case 42: {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static PendingIntent getErrorPendingIntent(int errorCode, Context context, int requestCode) {
        return GoogleApiAvailability.getInstance().getErrorResolutionPendingIntent(context, errorCode, requestCode);
    }

    @Deprecated
    public static Dialog getErrorDialog(int errorCode, Activity activity, int requestCode) {
        return GooglePlayServicesUtil.getErrorDialog(errorCode, activity, requestCode, null);
    }

    @Deprecated
    public static Dialog getErrorDialog(int errorCode, Activity activity, int requestCode, DialogInterface.OnCancelListener cancelListener) {
        return GooglePlayServicesUtil.zza(errorCode, activity, null, requestCode, cancelListener);
    }

    private static Dialog zza(int n, Activity activity, Fragment fragment, int n2, DialogInterface.OnCancelListener onCancelListener) {
        String string2;
        String string3;
        Object object;
        if (n == 0) {
            return null;
        }
        if (zzml.zzan((Context)activity) && n == 2) {
            n = 42;
        }
        AlertDialog.Builder builder = null;
        if (zzmx.zzqx()) {
            object = new TypedValue();
            activity.getTheme().resolveAttribute(16843529, object, true);
            string3 = activity.getResources().getResourceEntryName(object.resourceId);
            if ("Theme.Dialog.Alert".equals(string3)) {
                builder = new AlertDialog.Builder((Context)activity, 5);
            }
        }
        if (builder == null) {
            builder = new AlertDialog.Builder((Context)activity);
        }
        object = GooglePlayServicesUtil.zzaf((Context)activity);
        builder.setMessage((CharSequence)zzg.zzc((Context)activity, n, (String)object));
        if (onCancelListener != null) {
            builder.setOnCancelListener(onCancelListener);
        }
        string3 = GoogleApiAvailability.getInstance().zza((Context)activity, n, "d");
        zzh zzh2 = fragment == null ? new zzh(activity, (Intent)string3, n2) : new zzh(fragment, (Intent)string3, n2);
        String string4 = zzg.zzh((Context)activity, n);
        if (string4 != null) {
            builder.setPositiveButton((CharSequence)string4, (DialogInterface.OnClickListener)zzh2);
        }
        if ((string2 = zzg.zzg((Context)activity, n)) != null) {
            builder.setTitle((CharSequence)string2);
        }
        return builder.create();
    }

    @Deprecated
    public static boolean showErrorDialogFragment(int errorCode, Activity activity, int requestCode, DialogInterface.OnCancelListener cancelListener) {
        return GooglePlayServicesUtil.showErrorDialogFragment(errorCode, activity, null, requestCode, cancelListener);
    }

    public static boolean showErrorDialogFragment(int errorCode, Activity activity, Fragment fragment, int requestCode, DialogInterface.OnCancelListener cancelListener) {
        Dialog dialog = GooglePlayServicesUtil.zza(errorCode, activity, fragment, requestCode, cancelListener);
        if (dialog == null) {
            return false;
        }
        GooglePlayServicesUtil.zza(activity, cancelListener, GMS_ERROR_DIALOG, dialog);
        return true;
    }

    public static void zza(Activity activity, DialogInterface.OnCancelListener onCancelListener, String string2, Dialog dialog) {
        boolean bl;
        try {
            bl = activity instanceof FragmentActivity;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            bl = false;
        }
        if (bl) {
            FragmentManager fragmentManager = ((FragmentActivity)activity).getSupportFragmentManager();
            SupportErrorDialogFragment supportErrorDialogFragment = SupportErrorDialogFragment.newInstance(dialog, onCancelListener);
            supportErrorDialogFragment.show(fragmentManager, string2);
        } else if (zzmx.zzqu()) {
            android.app.FragmentManager fragmentManager = activity.getFragmentManager();
            ErrorDialogFragment errorDialogFragment = ErrorDialogFragment.newInstance(dialog, onCancelListener);
            errorDialogFragment.show(fragmentManager, string2);
        } else {
            throw new RuntimeException("This Activity does not support Fragments.");
        }
    }

    @Deprecated
    public static void showErrorNotification(int errorCode, Context context) {
        if (zzml.zzan(context) && errorCode == 2) {
            errorCode = 42;
        }
        if (GooglePlayServicesUtil.zzd(context, errorCode) || GooglePlayServicesUtil.zzf(context, errorCode)) {
            GooglePlayServicesUtil.zzae(context);
        } else {
            GooglePlayServicesUtil.zza(errorCode, context);
        }
    }

    private static void zzae(Context context) {
        zza zza2 = new zza(context);
        zza2.sendMessageDelayed(zza2.obtainMessage(1), 120000L);
    }

    private static void zza(int n, Context context) {
        GooglePlayServicesUtil.zza(n, context, null);
    }

    private static void zza(int n, Context context, String string2) {
        int n2;
        Notification.Builder builder;
        Notification notification;
        String string3;
        Resources resources = context.getResources();
        String string4 = GooglePlayServicesUtil.zzaf(context);
        String string5 = zzg.zzi(context, n);
        if (string5 == null) {
            string5 = resources.getString(R.string.common_google_play_services_notification_ticker);
        }
        String string6 = zzg.zzd(context, n, string4);
        PendingIntent pendingIntent = GoogleApiAvailability.getInstance().zza(context, n, 0, "n");
        if (zzml.zzan(context)) {
            zzx.zzZ(zzmx.zzqy());
            string3 = new Notification.Builder(context).setSmallIcon(R.drawable.common_ic_googleplayservices).setPriority(2).setAutoCancel(true).setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)(string5 + " " + string6))).addAction(R.drawable.common_full_open_on_phone, (CharSequence)resources.getString(R.string.common_open_on_phone), pendingIntent);
            notification = string3.build();
        } else {
            string3 = resources.getString(R.string.common_google_play_services_notification_ticker);
            if (zzmx.zzqu()) {
                builder = new Notification.Builder(context).setSmallIcon(17301642).setContentTitle((CharSequence)string5).setContentText((CharSequence)string6).setContentIntent(pendingIntent).setTicker((CharSequence)string3).setAutoCancel(true);
                if (zzmx.zzqC()) {
                    builder.setLocalOnly(true);
                }
                if (zzmx.zzqy()) {
                    builder.setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)string6));
                    notification = builder.build();
                } else {
                    notification = builder.getNotification();
                }
                if (Build.VERSION.SDK_INT == 19) {
                    notification.extras.putBoolean("android.support.localOnly", true);
                }
            } else {
                builder = new NotificationCompat.Builder(context).setSmallIcon(17301642).setTicker((CharSequence)string3).setWhen(System.currentTimeMillis()).setAutoCancel(true).setContentIntent(pendingIntent).setContentTitle((CharSequence)string5).setContentText((CharSequence)string6);
                notification = builder.build();
            }
        }
        if (GooglePlayServicesUtil.zzbk(n)) {
            n2 = 10436;
            zzaaq.set(false);
        } else {
            n2 = 39789;
        }
        builder = (NotificationManager)context.getSystemService("notification");
        if (string2 != null) {
            builder.notify(string2, n2, notification);
        } else {
            builder.notify(n2, notification);
        }
    }

    @Deprecated
    public static void zzac(Context context) {
        if (zzaaq.getAndSet(true)) {
            return;
        }
        try {
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            notificationManager.cancel(10436);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Deprecated
    public static boolean showErrorDialogFragment(int errorCode, Activity activity, int requestCode) {
        return GooglePlayServicesUtil.showErrorDialogFragment(errorCode, activity, requestCode, null);
    }

    @Deprecated
    public static boolean isUserRecoverableError(int errorCode) {
        switch (errorCode) {
            case 1: 
            case 2: 
            case 3: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String getOpenSourceSoftwareLicenseInfo(Context context) {
        String string2;
        block9: {
            Uri uri = new Uri.Builder().scheme("android.resource").authority(GOOGLE_PLAY_SERVICES_PACKAGE).appendPath("raw").appendPath("oss_notice").build();
            InputStream inputStream = context.getContentResolver().openInputStream(uri);
            try {
                string2 = new Scanner(inputStream).useDelimiter("\\A").next();
                if (inputStream == null) break block9;
            }
            catch (NoSuchElementException noSuchElementException) {
                String string3;
                block10: {
                    try {
                        string3 = null;
                        if (inputStream == null) break block10;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            throw throwable;
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    }
                    inputStream.close();
                }
                return string3;
            }
            inputStream.close();
        }
        return string2;
    }

    public static Resources getRemoteResource(Context context) {
        try {
            return context.getPackageManager().getResourcesForApplication(GOOGLE_PLAY_SERVICES_PACKAGE);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    public static Context getRemoteContext(Context context) {
        try {
            return context.createPackageContext(GOOGLE_PLAY_SERVICES_PACKAGE, 3);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    public static String zzaf(Context context) {
        String string2 = context.getApplicationInfo().name;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            ApplicationInfo applicationInfo;
            string2 = context.getPackageName();
            PackageManager packageManager = context.getApplicationContext().getPackageManager();
            try {
                applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                applicationInfo = null;
            }
            if (applicationInfo != null) {
                string2 = packageManager.getApplicationLabel(applicationInfo).toString();
            }
        }
        return string2;
    }

    public static boolean zzag(Context context) {
        PackageManager packageManager = context.getPackageManager();
        return zzmx.zzqD() && packageManager.hasSystemFeature("com.google.sidewinder");
    }

    @Deprecated
    public static boolean zzd(Context context, int n) {
        if (n == 18) {
            return true;
        }
        if (n == 1) {
            return GooglePlayServicesUtil.zzj(context, GOOGLE_PLAY_SERVICES_PACKAGE);
        }
        return false;
    }

    @Deprecated
    public static boolean zzf(Context context, int n) {
        if (n == 9) {
            return GooglePlayServicesUtil.zzj(context, GOOGLE_PLAY_STORE_PACKAGE);
        }
        return false;
    }

    static boolean zzj(Context context, String string2) {
        List list;
        if (zzmx.zzqD()) {
            list = context.getPackageManager().getPackageInstaller().getAllSessions();
            for (PackageInstaller.SessionInfo sessionInfo : list) {
                if (!string2.equals(sessionInfo.getAppPackageName())) continue;
                return true;
            }
        }
        if (GooglePlayServicesUtil.zzah(context)) {
            return false;
        }
        list = context.getPackageManager();
        try {
            ApplicationInfo applicationInfo = list.getApplicationInfo(string2, 8192);
            return applicationInfo.enabled;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    public static boolean zzah(Context context) {
        Bundle bundle;
        return zzmx.zzqA() && (bundle = ((UserManager)context.getSystemService("user")).getApplicationRestrictions(context.getPackageName())) != null && "true".equals(bundle.getString("restricted_profile"));
    }

    private static class zza
    extends Handler {
        private final Context zzqZ;

        zza(Context context) {
            super(Looper.myLooper() == null ? Looper.getMainLooper() : Looper.myLooper());
            this.zzqZ = context.getApplicationContext();
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable(this.zzqZ);
                    if (!GooglePlayServicesUtil.isUserRecoverableError(n)) break;
                    GooglePlayServicesUtil.zza(n, this.zzqZ);
                    break;
                }
                default: {
                    Log.w((String)"GooglePlayServicesUtil", (String)("Don't know how to handle this message: " + msg.what));
                }
            }
        }
    }
}

