/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamic;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzf;
import java.util.LinkedList;

public abstract class zza<T extends LifecycleDelegate> {
    private T zzapn;
    private Bundle zzapo;
    private LinkedList<zza> zzapp;
    private final zzf<T> zzapq = new zzf<T>(){

        @Override
        public void zza(T t) {
            zza.this.zzapn = t;
            for (zza zza2 : zza.this.zzapp) {
                zza2.zzb(zza.this.zzapn);
            }
            zza.this.zzapp.clear();
            zza.this.zzapo = null;
        }
    };

    public T zzrZ() {
        return this.zzapn;
    }

    private void zzer(int n) {
        while (!this.zzapp.isEmpty() && this.zzapp.getLast().getState() >= n) {
            this.zzapp.removeLast();
        }
    }

    private void zza(Bundle bundle, zza zza2) {
        if (this.zzapn != null) {
            zza2.zzb((LifecycleDelegate)this.zzapn);
            return;
        }
        if (this.zzapp == null) {
            this.zzapp = new LinkedList();
        }
        this.zzapp.add(zza2);
        if (bundle != null) {
            if (this.zzapo == null) {
                this.zzapo = (Bundle)bundle.clone();
            } else {
                this.zzapo.putAll(bundle);
            }
        }
        this.zza(this.zzapq);
    }

    protected abstract void zza(zzf<T> var1);

    public void onInflate(final Activity activity, final Bundle attrs, final Bundle savedInstanceState) {
        this.zza(savedInstanceState, new zza(){

            @Override
            public int getState() {
                return 0;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.zzapn.onInflate(activity, attrs, savedInstanceState);
            }
        });
    }

    public void onCreate(final Bundle savedInstanceState) {
        this.zza(savedInstanceState, new zza(){

            @Override
            public int getState() {
                return 1;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.zzapn.onCreate(savedInstanceState);
            }
        });
    }

    public View onCreateView(final LayoutInflater inflater, final ViewGroup container, final Bundle savedInstanceState) {
        final FrameLayout frameLayout = new FrameLayout(inflater.getContext());
        this.zza(savedInstanceState, new zza(){

            @Override
            public int getState() {
                return 2;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                frameLayout.removeAllViews();
                frameLayout.addView(zza.this.zzapn.onCreateView(inflater, container, savedInstanceState));
            }
        });
        if (this.zzapn == null) {
            this.zza(frameLayout);
        }
        return frameLayout;
    }

    protected void zza(FrameLayout frameLayout) {
        zza.zzb(frameLayout);
    }

    public static void zzb(FrameLayout frameLayout) {
        final Context context = frameLayout.getContext();
        final int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable(context);
        String string2 = zzg.zzc(context, n, GooglePlayServicesUtil.zzaf(context));
        String string3 = zzg.zzh(context, n);
        LinearLayout linearLayout = new LinearLayout(frameLayout.getContext());
        linearLayout.setOrientation(1);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        frameLayout.addView((View)linearLayout);
        TextView textView = new TextView(frameLayout.getContext());
        textView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        textView.setText((CharSequence)string2);
        linearLayout.addView((View)textView);
        if (string3 != null) {
            Button button = new Button(context);
            button.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
            button.setText((CharSequence)string3);
            linearLayout.addView((View)button);
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    context.startActivity(GooglePlayServicesUtil.zzbj(n));
                }
            });
        }
    }

    public void onStart() {
        this.zza(null, new zza(){

            @Override
            public int getState() {
                return 4;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.zzapn.onStart();
            }
        });
    }

    public void onResume() {
        this.zza(null, new zza(){

            @Override
            public int getState() {
                return 5;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.zzapn.onResume();
            }
        });
    }

    public void onPause() {
        if (this.zzapn != null) {
            this.zzapn.onPause();
        } else {
            this.zzer(5);
        }
    }

    public void onStop() {
        if (this.zzapn != null) {
            this.zzapn.onStop();
        } else {
            this.zzer(4);
        }
    }

    public void onDestroyView() {
        if (this.zzapn != null) {
            this.zzapn.onDestroyView();
        } else {
            this.zzer(2);
        }
    }

    public void onDestroy() {
        if (this.zzapn != null) {
            this.zzapn.onDestroy();
        } else {
            this.zzer(1);
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        if (this.zzapn != null) {
            this.zzapn.onSaveInstanceState(outState);
        } else if (this.zzapo != null) {
            outState.putAll(this.zzapo);
        }
    }

    public void onLowMemory() {
        if (this.zzapn != null) {
            this.zzapn.onLowMemory();
        }
    }

    private static interface zza {
        public int getState();

        public void zzb(LifecycleDelegate var1);
    }
}

