/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzmf;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

abstract class zzmh<K, V> {
    zzb zzagI;
    zzc zzagJ;
    zze zzagK;

    zzmh() {
    }

    public static <K, V> boolean containsAllHelper(Map<K, V> map, Collection<?> collection) {
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (map.containsKey(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static <K, V> boolean removeAllHelper(Map<K, V> map, Collection<?> collection) {
        int n = map.size();
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            map.remove(iterator.next());
        }
        return n != map.size();
    }

    public static <K, V> boolean retainAllHelper(Map<K, V> map, Collection<?> collection) {
        int n = map.size();
        Iterator<K> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
        }
        return n != map.size();
    }

    public Object[] toArrayHelper(int offset) {
        int n = this.colGetSize();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.colGetEntry(i, offset);
        }
        return objectArray;
    }

    public <T> T[] toArrayHelper(T[] array, int offset) {
        int n = this.colGetSize();
        if (array.length < n) {
            Object[] objectArray = (Object[])Array.newInstance(array.getClass().getComponentType(), n);
            array = objectArray;
        }
        for (int i = 0; i < n; ++i) {
            array[i] = this.colGetEntry(i, offset);
        }
        if (array.length > n) {
            array[n] = null;
        }
        return array;
    }

    public static <T> boolean equalsSetHelper(Set<T> set, Object object) {
        if (set == object) {
            return true;
        }
        if (object instanceof Set) {
            Set set2 = (Set)object;
            try {
                return set.size() == set2.size() && set.containsAll(set2);
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
        return false;
    }

    public Set<Map.Entry<K, V>> getEntrySet() {
        if (this.zzagI == null) {
            this.zzagI = new zzb();
        }
        return this.zzagI;
    }

    public Set<K> getKeySet() {
        if (this.zzagJ == null) {
            this.zzagJ = new zzc();
        }
        return this.zzagJ;
    }

    public Collection<V> getValues() {
        if (this.zzagK == null) {
            this.zzagK = new zze();
        }
        return this.zzagK;
    }

    protected abstract int colGetSize();

    protected abstract Object colGetEntry(int var1, int var2);

    protected abstract int colIndexOfKey(Object var1);

    protected abstract int colIndexOfValue(Object var1);

    protected abstract Map<K, V> colGetMap();

    protected abstract void colPut(K var1, V var2);

    protected abstract V colSetValue(int var1, V var2);

    protected abstract void colRemoveAt(int var1);

    protected abstract void colClear();

    final class zze
    implements Collection<V> {
        zze() {
        }

        @Override
        public boolean add(V object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends V> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            zzmh.this.colClear();
        }

        @Override
        public boolean contains(Object object) {
            return zzmh.this.colIndexOfValue(object) >= 0;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            Iterator<?> iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (this.contains(iterator.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return zzmh.this.colGetSize() == 0;
        }

        @Override
        public Iterator<V> iterator() {
            return new zza(1);
        }

        @Override
        public boolean remove(Object object) {
            int n = zzmh.this.colIndexOfValue(object);
            if (n >= 0) {
                zzmh.this.colRemoveAt(n);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            int n = zzmh.this.colGetSize();
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                Object object = zzmh.this.colGetEntry(i, 1);
                if (!collection.contains(object)) continue;
                zzmh.this.colRemoveAt(i);
                --i;
                --n;
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            int n = zzmh.this.colGetSize();
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                Object object = zzmh.this.colGetEntry(i, 1);
                if (collection.contains(object)) continue;
                zzmh.this.colRemoveAt(i);
                --i;
                --n;
                bl = true;
            }
            return bl;
        }

        @Override
        public int size() {
            return zzmh.this.colGetSize();
        }

        @Override
        public Object[] toArray() {
            return zzmh.this.toArrayHelper(1);
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return zzmh.this.toArrayHelper(array, 1);
        }
    }

    final class zzc
    implements Set<K> {
        zzc() {
        }

        @Override
        public boolean add(K object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends K> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            zzmh.this.colClear();
        }

        @Override
        public boolean contains(Object object) {
            return zzmh.this.colIndexOfKey(object) >= 0;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return zzmh.containsAllHelper(zzmh.this.colGetMap(), collection);
        }

        @Override
        public boolean isEmpty() {
            return zzmh.this.colGetSize() == 0;
        }

        @Override
        public Iterator<K> iterator() {
            return new zza(0);
        }

        @Override
        public boolean remove(Object object) {
            int n = zzmh.this.colIndexOfKey(object);
            if (n >= 0) {
                zzmh.this.colRemoveAt(n);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return zzmh.removeAllHelper(zzmh.this.colGetMap(), collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return zzmh.retainAllHelper(zzmh.this.colGetMap(), collection);
        }

        @Override
        public int size() {
            return zzmh.this.colGetSize();
        }

        @Override
        public Object[] toArray() {
            return zzmh.this.toArrayHelper(0);
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return zzmh.this.toArrayHelper(array, 0);
        }

        @Override
        public boolean equals(Object object) {
            return zzmh.equalsSetHelper(this, object);
        }

        @Override
        public int hashCode() {
            int n = 0;
            for (int i = zzmh.this.colGetSize() - 1; i >= 0; --i) {
                Object object = zzmh.this.colGetEntry(i, 0);
                n += object == null ? 0 : object.hashCode();
            }
            return n;
        }
    }

    final class zzb
    implements Set<Map.Entry<K, V>> {
        zzb() {
        }

        @Override
        public boolean add(Map.Entry<K, V> object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<K, V>> collection) {
            int n = zzmh.this.colGetSize();
            for (Map.Entry entry : collection) {
                zzmh.this.colPut(entry.getKey(), entry.getValue());
            }
            return n != zzmh.this.colGetSize();
        }

        @Override
        public void clear() {
            zzmh.this.colClear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            int n = zzmh.this.colIndexOfKey(entry.getKey());
            if (n < 0) {
                return false;
            }
            Object object = zzmh.this.colGetEntry(n, 1);
            return zzmf.equal(object, entry.getValue());
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            Iterator<?> iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (this.contains(iterator.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return zzmh.this.colGetSize() == 0;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new zzd();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return zzmh.this.colGetSize();
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object object) {
            return zzmh.equalsSetHelper(this, object);
        }

        @Override
        public int hashCode() {
            int n = 0;
            for (int i = zzmh.this.colGetSize() - 1; i >= 0; --i) {
                Object object = zzmh.this.colGetEntry(i, 0);
                Object object2 = zzmh.this.colGetEntry(i, 1);
                n += (object == null ? 0 : object.hashCode()) ^ (object2 == null ? 0 : object2.hashCode());
            }
            return n;
        }
    }

    final class zzd
    implements Iterator<Map.Entry<K, V>>,
    Map.Entry<K, V> {
        int mEnd;
        int mIndex;
        boolean mEntryValid = false;

        zzd() {
            this.mEnd = zzmh.this.colGetSize() - 1;
            this.mIndex = -1;
        }

        @Override
        public boolean hasNext() {
            return this.mIndex < this.mEnd;
        }

        @Override
        public Map.Entry<K, V> next() {
            ++this.mIndex;
            this.mEntryValid = true;
            return this;
        }

        @Override
        public void remove() {
            if (!this.mEntryValid) {
                throw new IllegalStateException();
            }
            zzmh.this.colRemoveAt(this.mIndex);
            --this.mIndex;
            --this.mEnd;
            this.mEntryValid = false;
        }

        @Override
        public K getKey() {
            if (!this.mEntryValid) {
                throw new IllegalStateException("This container does not support retaining Map.Entry objects");
            }
            return zzmh.this.colGetEntry(this.mIndex, 0);
        }

        @Override
        public V getValue() {
            if (!this.mEntryValid) {
                throw new IllegalStateException("This container does not support retaining Map.Entry objects");
            }
            return zzmh.this.colGetEntry(this.mIndex, 1);
        }

        @Override
        public V setValue(V object) {
            if (!this.mEntryValid) {
                throw new IllegalStateException("This container does not support retaining Map.Entry objects");
            }
            return zzmh.this.colSetValue(this.mIndex, object);
        }

        @Override
        public final boolean equals(Object o) {
            if (!this.mEntryValid) {
                throw new IllegalStateException("This container does not support retaining Map.Entry objects");
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return zzmf.equal(entry.getKey(), zzmh.this.colGetEntry(this.mIndex, 0)) && zzmf.equal(entry.getValue(), zzmh.this.colGetEntry(this.mIndex, 1));
        }

        @Override
        public final int hashCode() {
            if (!this.mEntryValid) {
                throw new IllegalStateException("This container does not support retaining Map.Entry objects");
            }
            Object object = zzmh.this.colGetEntry(this.mIndex, 0);
            Object object2 = zzmh.this.colGetEntry(this.mIndex, 1);
            return (object == null ? 0 : object.hashCode()) ^ (object2 == null ? 0 : object2.hashCode());
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    final class zza<T>
    implements Iterator<T> {
        final int mOffset;
        int mSize;
        int mIndex;
        boolean mCanRemove = false;

        zza(int n) {
            this.mOffset = n;
            this.mSize = zzmh.this.colGetSize();
        }

        @Override
        public boolean hasNext() {
            return this.mIndex < this.mSize;
        }

        @Override
        public T next() {
            Object object = zzmh.this.colGetEntry(this.mIndex, this.mOffset);
            ++this.mIndex;
            this.mCanRemove = true;
            return (T)object;
        }

        @Override
        public void remove() {
            if (!this.mCanRemove) {
                throw new IllegalStateException();
            }
            --this.mIndex;
            --this.mSize;
            this.mCanRemove = false;
            zzmh.this.colRemoveAt(this.mIndex);
        }
    }
}

