/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.server.response;

import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzb;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.server.response.FastJsonResponse;
import com.google.android.gms.common.server.response.FieldMappingDictionary;
import com.google.android.gms.common.server.response.zze;
import com.google.android.gms.internal.zznh;
import com.google.android.gms.internal.zzni;
import com.google.android.gms.internal.zznu;
import com.google.android.gms.internal.zznv;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SafeParcelResponse
extends FastJsonResponse
implements SafeParcelable {
    private final int mVersionCode;
    private final Parcel zzalj;
    private final int zzalk;
    private final FieldMappingDictionary zzalc;
    private final String mClassName;
    private int zzall;
    private int zzalm;
    public static final zze CREATOR = new zze();

    private SafeParcelResponse(SafeParcelable safeParcelable, FieldMappingDictionary dictionary, String className) {
        this.mVersionCode = 1;
        this.zzalj = Parcel.obtain();
        safeParcelable.writeToParcel(this.zzalj, 0);
        this.zzalk = 1;
        this.zzalc = zzx.zzy(dictionary);
        this.mClassName = zzx.zzy(className);
        this.zzall = 2;
    }

    public static <T extends FastJsonResponse> SafeParcelResponse zza(T t) {
        String string2 = t.getClass().getCanonicalName();
        FieldMappingDictionary fieldMappingDictionary = SafeParcelResponse.zzb(t);
        return new SafeParcelResponse((SafeParcelable)((Object)t), fieldMappingDictionary, string2);
    }

    private static FieldMappingDictionary zzb(FastJsonResponse fastJsonResponse) {
        FieldMappingDictionary fieldMappingDictionary = new FieldMappingDictionary(fastJsonResponse.getClass());
        SafeParcelResponse.zza(fieldMappingDictionary, fastJsonResponse);
        fieldMappingDictionary.zzrj();
        fieldMappingDictionary.zzri();
        return fieldMappingDictionary;
    }

    private static void zza(FieldMappingDictionary fieldMappingDictionary, FastJsonResponse fastJsonResponse) {
        Class<?> clazz = fastJsonResponse.getClass();
        if (!fieldMappingDictionary.zzb(clazz)) {
            Map<String, FastJsonResponse.Field<?, ?>> map = fastJsonResponse.zzqV();
            fieldMappingDictionary.zza(clazz, map);
            for (String string2 : map.keySet()) {
                FastJsonResponse.Field<?, ?> field = map.get(string2);
                Class<FastJsonResponse> clazz2 = field.zzrd();
                if (clazz2 == null) continue;
                try {
                    FastJsonResponse fastJsonResponse2 = clazz2.newInstance();
                    SafeParcelResponse.zza(fieldMappingDictionary, fastJsonResponse2);
                }
                catch (InstantiationException instantiationException) {
                    throw new IllegalStateException("Could not instantiate an object of type " + field.zzrd().getCanonicalName(), instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalStateException("Could not access object of type " + field.zzrd().getCanonicalName(), illegalAccessException);
                }
            }
        }
    }

    SafeParcelResponse(int versionCode, Parcel parcel, FieldMappingDictionary fieldMappingDictionary) {
        this.mVersionCode = versionCode;
        this.zzalj = zzx.zzy(parcel);
        this.zzalk = 2;
        this.zzalc = fieldMappingDictionary;
        this.mClassName = this.zzalc == null ? null : this.zzalc.zzrl();
        this.zzall = 2;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zze.zza(this, out, flags);
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public Parcel zzrn() {
        switch (this.zzall) {
            case 0: {
                this.zzalm = zzb.zzav(this.zzalj);
                zzb.zzI(this.zzalj, this.zzalm);
                this.zzall = 2;
                break;
            }
            case 1: {
                zzb.zzI(this.zzalj, this.zzalm);
                this.zzall = 2;
                break;
            }
        }
        return this.zzalj;
    }

    FieldMappingDictionary zzro() {
        switch (this.zzalk) {
            case 0: {
                return null;
            }
            case 1: {
                return this.zzalc;
            }
            case 2: {
                return this.zzalc;
            }
        }
        throw new IllegalStateException("Invalid creation type: " + this.zzalk);
    }

    @Override
    public Map<String, FastJsonResponse.Field<?, ?>> zzqV() {
        if (this.zzalc == null) {
            return null;
        }
        return this.zzalc.zzcL(this.mClassName);
    }

    @Override
    protected Object zzcH(String string2) {
        throw new UnsupportedOperationException("Converting to JSON does not require this method.");
    }

    @Override
    protected boolean zzcI(String string2) {
        throw new UnsupportedOperationException("Converting to JSON does not require this method.");
    }

    @Override
    public String toString() {
        zzx.zzb(this.zzalc, (Object)"Cannot convert to JSON on client side.");
        Parcel parcel = this.zzrn();
        parcel.setDataPosition(0);
        StringBuilder stringBuilder = new StringBuilder(100);
        this.zza(stringBuilder, this.zzalc.zzcL(this.mClassName), parcel);
        return stringBuilder.toString();
    }

    private void zza(StringBuilder stringBuilder, Map<String, FastJsonResponse.Field<?, ?>> map, Parcel parcel) {
        HashMap<Integer, Map.Entry<String, FastJsonResponse.Field<?, ?>>> hashMap = SafeParcelResponse.zzG(map);
        stringBuilder.append('{');
        int n = zza.zzau(parcel);
        boolean bl = false;
        while (parcel.dataPosition() < n) {
            int n2 = zza.zzat(parcel);
            int n3 = zza.zzcc(n2);
            Map.Entry<String, FastJsonResponse.Field<?, ?>> entry = hashMap.get(n3);
            if (entry == null) continue;
            if (bl) {
                stringBuilder.append(",");
            }
            this.zza(stringBuilder, entry.getKey(), entry.getValue(), parcel, n2);
            bl = true;
        }
        if (parcel.dataPosition() != n) {
            throw new zza.zza("Overread allowed size end=" + n, parcel);
        }
        stringBuilder.append('}');
    }

    private static HashMap<Integer, Map.Entry<String, FastJsonResponse.Field<?, ?>>> zzG(Map<String, FastJsonResponse.Field<?, ?>> map) {
        HashMap hashMap = new HashMap();
        for (Map.Entry<String, FastJsonResponse.Field<?, ?>> entry : map.entrySet()) {
            hashMap.put(entry.getValue().zzrc(), entry);
        }
        return hashMap;
    }

    private void zza(StringBuilder stringBuilder, String string2, FastJsonResponse.Field<?, ?> field, Parcel parcel, int n) {
        stringBuilder.append("\"").append(string2).append("\":");
        if (field.zzrf()) {
            this.zza(stringBuilder, field, parcel, n);
        } else {
            this.zzb(stringBuilder, field, parcel, n);
        }
    }

    private void zza(StringBuilder stringBuilder, FastJsonResponse.Field<?, ?> field, Parcel parcel, int n) {
        switch (field.zzqU()) {
            case 0: {
                int n2 = zza.zzg(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, n2));
                break;
            }
            case 1: {
                BigInteger bigInteger = zza.zzk(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, bigInteger));
                break;
            }
            case 2: {
                long l = zza.zzi(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, l));
                break;
            }
            case 3: {
                float f = zza.zzl(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, Float.valueOf(f)));
                break;
            }
            case 4: {
                double d = zza.zzn(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, d));
                break;
            }
            case 5: {
                BigDecimal bigDecimal = zza.zzo(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, bigDecimal));
                break;
            }
            case 6: {
                boolean bl = zza.zzc(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, bl));
                break;
            }
            case 7: {
                String string2 = zza.zzp(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, string2));
                break;
            }
            case 8: 
            case 9: {
                byte[] byArray = zza.zzs(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, byArray));
                break;
            }
            case 10: {
                Bundle bundle = zza.zzr(parcel, n);
                HashMap<String, String> hashMap = SafeParcelResponse.zzl(bundle);
                this.zzb(stringBuilder, field, this.zza(field, hashMap));
                break;
            }
            case 11: {
                throw new IllegalArgumentException("Method does not accept concrete type.");
            }
            default: {
                throw new IllegalArgumentException("Unknown field out type = " + field.zzqU());
            }
        }
    }

    private void zzb(StringBuilder stringBuilder, FastJsonResponse.Field<?, ?> field, Parcel parcel, int n) {
        if (field.zzra()) {
            stringBuilder.append("[");
            switch (field.zzqU()) {
                case 0: {
                    int[] nArray = zza.zzv(parcel, n);
                    zznh.zza(stringBuilder, nArray);
                    break;
                }
                case 1: {
                    BigInteger[] bigIntegerArray = zza.zzx(parcel, n);
                    zznh.zza(stringBuilder, bigIntegerArray);
                    break;
                }
                case 2: {
                    long[] lArray = zza.zzw(parcel, n);
                    zznh.zza(stringBuilder, lArray);
                    break;
                }
                case 3: {
                    float[] fArray = zza.zzy(parcel, n);
                    zznh.zza(stringBuilder, fArray);
                    break;
                }
                case 4: {
                    double[] dArray = zza.zzz(parcel, n);
                    zznh.zza(stringBuilder, dArray);
                    break;
                }
                case 5: {
                    BigDecimal[] bigDecimalArray = zza.zzA(parcel, n);
                    zznh.zza(stringBuilder, bigDecimalArray);
                    break;
                }
                case 6: {
                    boolean[] blArray = zza.zzu(parcel, n);
                    zznh.zza(stringBuilder, blArray);
                    break;
                }
                case 7: {
                    String[] stringArray = zza.zzB(parcel, n);
                    zznh.zza(stringBuilder, stringArray);
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    throw new UnsupportedOperationException("List of type BASE64, BASE64_URL_SAFE, or STRING_MAP is not supported");
                }
                case 11: {
                    Parcel[] parcelArray = zza.zzF(parcel, n);
                    int n2 = parcelArray.length;
                    for (int i = 0; i < n2; ++i) {
                        if (i > 0) {
                            stringBuilder.append(",");
                        }
                        parcelArray[i].setDataPosition(0);
                        this.zza(stringBuilder, field.zzrh(), parcelArray[i]);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown field type out.");
                }
            }
            stringBuilder.append("]");
        } else {
            switch (field.zzqU()) {
                case 0: {
                    int n3 = zza.zzg(parcel, n);
                    stringBuilder.append(n3);
                    break;
                }
                case 1: {
                    BigInteger bigInteger = zza.zzk(parcel, n);
                    stringBuilder.append(bigInteger);
                    break;
                }
                case 2: {
                    long l = zza.zzi(parcel, n);
                    stringBuilder.append(l);
                    break;
                }
                case 3: {
                    float f = zza.zzl(parcel, n);
                    stringBuilder.append(f);
                    break;
                }
                case 4: {
                    double d = zza.zzn(parcel, n);
                    stringBuilder.append(d);
                    break;
                }
                case 5: {
                    BigDecimal bigDecimal = zza.zzo(parcel, n);
                    stringBuilder.append(bigDecimal);
                    break;
                }
                case 6: {
                    boolean bl = zza.zzc(parcel, n);
                    stringBuilder.append(bl);
                    break;
                }
                case 7: {
                    String string2 = zza.zzp(parcel, n);
                    stringBuilder.append("\"").append(zznu.zzcO(string2)).append("\"");
                    break;
                }
                case 8: {
                    byte[] byArray = zza.zzs(parcel, n);
                    stringBuilder.append("\"").append(zzni.zzj(byArray)).append("\"");
                    break;
                }
                case 9: {
                    byte[] byArray = zza.zzs(parcel, n);
                    stringBuilder.append("\"").append(zzni.zzk(byArray));
                    stringBuilder.append("\"");
                    break;
                }
                case 10: {
                    Bundle bundle = zza.zzr(parcel, n);
                    Set set = bundle.keySet();
                    int n4 = set.size();
                    stringBuilder.append("{");
                    boolean bl = true;
                    for (String string3 : set) {
                        if (!bl) {
                            stringBuilder.append(",");
                        }
                        bl = false;
                        stringBuilder.append("\"").append(string3).append("\"");
                        stringBuilder.append(":");
                        stringBuilder.append("\"").append(zznu.zzcO(bundle.getString(string3))).append("\"");
                    }
                    stringBuilder.append("}");
                    break;
                }
                case 11: {
                    Parcel parcel2 = zza.zzE(parcel, n);
                    parcel2.setDataPosition(0);
                    this.zza(stringBuilder, field.zzrh(), parcel2);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown field type out");
                }
            }
        }
    }

    private void zzb(StringBuilder stringBuilder, FastJsonResponse.Field<?, ?> field, Object object) {
        if (field.zzqZ()) {
            this.zzb(stringBuilder, field, (ArrayList)object);
        } else {
            this.zza(stringBuilder, field.zzqT(), object);
        }
    }

    private void zzb(StringBuilder stringBuilder, FastJsonResponse.Field<?, ?> field, ArrayList<?> arrayList) {
        stringBuilder.append("[");
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            this.zza(stringBuilder, field.zzqT(), arrayList.get(i));
        }
        stringBuilder.append("]");
    }

    private void zza(StringBuilder stringBuilder, int n, Object object) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                stringBuilder.append(object);
                break;
            }
            case 7: {
                stringBuilder.append("\"").append(zznu.zzcO(object.toString())).append("\"");
                break;
            }
            case 8: {
                stringBuilder.append("\"").append(zzni.zzj((byte[])object)).append("\"");
                break;
            }
            case 9: {
                stringBuilder.append("\"").append(zzni.zzk((byte[])object));
                stringBuilder.append("\"");
                break;
            }
            case 10: {
                zznv.zza(stringBuilder, (HashMap)object);
                break;
            }
            case 11: {
                throw new IllegalArgumentException("Method does not accept concrete type.");
            }
            default: {
                throw new IllegalArgumentException("Unknown type = " + n);
            }
        }
    }

    public static HashMap<String, String> zzl(Bundle bundle) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : bundle.keySet()) {
            hashMap.put(string2, bundle.getString(string2));
        }
        return hashMap;
    }
}

