/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamic;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzf;
import java.util.LinkedList;

public abstract class zza<T extends LifecycleDelegate> {
    private T zzatr;
    private Bundle zzats;
    private LinkedList<zza> zzatt;
    private final zzf<T> zzatu = new zzf<T>(){

        @Override
        public void zza(T t) {
            zza.this.zzatr = t;
            for (zza zza2 : zza.this.zzatt) {
                zza2.zzb(zza.this.zzatr);
            }
            zza.this.zzatt.clear();
            zza.this.zzats = null;
        }
    };

    public T zzts() {
        return this.zzatr;
    }

    private void zzeF(int n) {
        while (!this.zzatt.isEmpty() && this.zzatt.getLast().getState() >= n) {
            this.zzatt.removeLast();
        }
    }

    private void zza(Bundle bundle, zza zza2) {
        if (this.zzatr != null) {
            zza2.zzb((LifecycleDelegate)this.zzatr);
            return;
        }
        if (this.zzatt == null) {
            this.zzatt = new LinkedList();
        }
        this.zzatt.add(zza2);
        if (bundle != null) {
            if (this.zzats == null) {
                this.zzats = (Bundle)bundle.clone();
            } else {
                this.zzats.putAll(bundle);
            }
        }
        this.zza(this.zzatu);
    }

    protected abstract void zza(zzf<T> var1);

    public void onInflate(final Activity activity, final Bundle attrs, final Bundle savedInstanceState) {
        this.zza(savedInstanceState, new zza(){

            @Override
            public int getState() {
                return 0;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.zzatr.onInflate(activity, attrs, savedInstanceState);
            }
        });
    }

    public void onCreate(final Bundle savedInstanceState) {
        this.zza(savedInstanceState, new zza(){

            @Override
            public int getState() {
                return 1;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.zzatr.onCreate(savedInstanceState);
            }
        });
    }

    public View onCreateView(final LayoutInflater inflater, final ViewGroup container, final Bundle savedInstanceState) {
        final FrameLayout frameLayout = new FrameLayout(inflater.getContext());
        this.zza(savedInstanceState, new zza(){

            @Override
            public int getState() {
                return 2;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                frameLayout.removeAllViews();
                frameLayout.addView(zza.this.zzatr.onCreateView(inflater, container, savedInstanceState));
            }
        });
        if (this.zzatr == null) {
            this.zza(frameLayout);
        }
        return frameLayout;
    }

    protected void zza(FrameLayout frameLayout) {
        zza.zzb(frameLayout);
    }

    public static void zzb(FrameLayout frameLayout) {
        final Context context = frameLayout.getContext();
        final int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable(context);
        String string2 = zzg.zzc(context, n, GooglePlayServicesUtil.zzam(context));
        String string3 = zzg.zzh(context, n);
        LinearLayout linearLayout = new LinearLayout(frameLayout.getContext());
        linearLayout.setOrientation(1);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        frameLayout.addView((View)linearLayout);
        TextView textView = new TextView(frameLayout.getContext());
        textView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        textView.setText((CharSequence)string2);
        linearLayout.addView((View)textView);
        if (string3 != null) {
            Button button = new Button(context);
            button.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
            button.setText((CharSequence)string3);
            linearLayout.addView((View)button);
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    context.startActivity(GooglePlayServicesUtil.zzbv(n));
                }
            });
        }
    }

    public void onStart() {
        this.zza(null, new zza(){

            @Override
            public int getState() {
                return 4;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.zzatr.onStart();
            }
        });
    }

    public void onResume() {
        this.zza(null, new zza(){

            @Override
            public int getState() {
                return 5;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.zzatr.onResume();
            }
        });
    }

    public void onPause() {
        if (this.zzatr != null) {
            this.zzatr.onPause();
        } else {
            this.zzeF(5);
        }
    }

    public void onStop() {
        if (this.zzatr != null) {
            this.zzatr.onStop();
        } else {
            this.zzeF(4);
        }
    }

    public void onDestroyView() {
        if (this.zzatr != null) {
            this.zzatr.onDestroyView();
        } else {
            this.zzeF(2);
        }
    }

    public void onDestroy() {
        if (this.zzatr != null) {
            this.zzatr.onDestroy();
        } else {
            this.zzeF(1);
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        if (this.zzatr != null) {
            this.zzatr.onSaveInstanceState(outState);
        } else if (this.zzats != null) {
            outState.putAll(this.zzats);
        }
    }

    public void onLowMemory() {
        if (this.zzatr != null) {
            this.zzatr.onLowMemory();
        }
    }

    private static interface zza {
        public int getState();

        public void zzb(LifecycleDelegate var1);
    }
}

