/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzms;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class zzly<R extends Result>
extends PendingResult<R> {
    private final Object zzafd = new Object();
    protected final zza<R> zzafe;
    private final CountDownLatch zzpy = new CountDownLatch(1);
    private final ArrayList<PendingResult.zza> zzaff = new ArrayList();
    private ResultCallback<? super R> zzafg;
    private volatile R zzaeT;
    private volatile boolean zzafh;
    private boolean zzL;
    private boolean zzafi;
    private zzq zzafj;
    private Integer zzafk;
    private volatile zzms<R> zzafl;

    protected zzly(GoogleApiClient googleApiClient) {
        Looper looper = googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper();
        this.zzafe = new zza(looper);
    }

    @Deprecated
    protected zzly(Looper looper) {
        this.zzafe = new zza(looper);
    }

    public final boolean isReady() {
        return this.zzpy.getCount() == 0L;
    }

    @Override
    public final R await() {
        zzx.zza(Looper.myLooper() != Looper.getMainLooper(), (Object)"await must not be called on the UI thread");
        zzx.zza(!this.zzafh, (Object)"Result has already been consumed");
        zzx.zza(this.zzafl == null, (Object)"Cannot await if then() has been called.");
        try {
            this.zzpy.await();
        }
        catch (InterruptedException interruptedException) {
            this.zzy(Status.zzaeY);
        }
        zzx.zza(this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    @Override
    public final R await(long time, TimeUnit units) {
        zzx.zza(time <= 0L || Looper.myLooper() != Looper.getMainLooper(), (Object)"await must not be called on the UI thread when time is greater than zero.");
        zzx.zza(!this.zzafh, (Object)"Result has already been consumed.");
        zzx.zza(this.zzafl == null, (Object)"Cannot await if then() has been called.");
        try {
            boolean bl = this.zzpy.await(time, units);
            if (!bl) {
                this.zzy(Status.zzafa);
            }
        }
        catch (InterruptedException interruptedException) {
            this.zzy(Status.zzaeY);
        }
        zzx.zza(this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> callback) {
        zzx.zza(!this.zzafh, (Object)"Result has already been consumed.");
        Object object = this.zzafd;
        synchronized (object) {
            zzx.zza(this.zzafl == null, (Object)"Cannot set callbacks if then() has been called.");
            if (this.isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zzafe.zza(callback, (R)this.get());
            } else {
                this.zzafg = callback;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> callback, long time, TimeUnit units) {
        zzx.zza(!this.zzafh, (Object)"Result has already been consumed.");
        Object object = this.zzafd;
        synchronized (object) {
            zzx.zza(this.zzafl == null, (Object)"Cannot set callbacks if then() has been called.");
            if (this.isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zzafe.zza(callback, (R)this.get());
            } else {
                this.zzafg = callback;
                this.zzafe.zza(this, units.toMillis(time));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(PendingResult.zza zza2) {
        zzx.zza(!this.zzafh, (Object)"Result has already been consumed.");
        zzx.zzb(zza2 != null, (Object)"Callback cannot be null.");
        Object object = this.zzafd;
        synchronized (object) {
            if (this.isReady()) {
                zza2.zzu(this.zzaeT.getStatus());
            } else {
                this.zzaff.add(zza2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.zzafd;
        synchronized (object) {
            if (this.zzL || this.zzafh) {
                return;
            }
            if (this.zzafj != null) {
                try {
                    this.zzafj.cancel();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            zzly.zzd(this.zzaeT);
            this.zzafg = null;
            this.zzL = true;
            this.zzc(this.zzc(Status.zzafb));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        Object object = this.zzafd;
        synchronized (object) {
            return this.zzL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(R r) {
        Object object = this.zzafd;
        synchronized (object) {
            if (this.zzafi || this.zzL) {
                zzly.zzd(r);
                return;
            }
            zzx.zza(!this.isReady(), (Object)"Results have already been set");
            zzx.zza(!this.zzafh, (Object)"Result has already been consumed");
            this.zzc(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzy(Status status) {
        Object object = this.zzafd;
        synchronized (object) {
            if (!this.isReady()) {
                this.zzb(this.zzc(status));
                this.zzafi = true;
            }
        }
    }

    protected abstract R zzc(Status var1);

    protected void zzoR() {
    }

    @Override
    public Integer zzoL() {
        return this.zzafk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void zza(zzq zzq2) {
        Object object = this.zzafd;
        synchronized (object) {
            this.zzafj = zzq2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R get() {
        R r;
        Object object = this.zzafd;
        synchronized (object) {
            zzx.zza(!this.zzafh, (Object)"Result has already been consumed.");
            zzx.zza(this.isReady(), (Object)"Result is not ready.");
            r = this.zzaeT;
            this.zzaeT = null;
            this.zzafg = null;
            this.zzafh = true;
        }
        this.zzoR();
        return r;
    }

    private void zzc(R r) {
        this.zzaeT = r;
        this.zzafj = null;
        this.zzpy.countDown();
        Status status = this.zzaeT.getStatus();
        if (this.zzafg != null) {
            this.zzafe.zzoS();
            if (!this.zzL) {
                this.zzafe.zza(this.zzafg, (R)this.get());
            }
        }
        for (PendingResult.zza zza2 : this.zzaff) {
            zza2.zzu(status);
        }
        this.zzaff.clear();
    }

    public static void zzd(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)((Object)result)).release();
            }
            catch (RuntimeException runtimeException) {
                Log.w((String)"BasePendingResult", (String)("Unable to release " + result), (Throwable)runtimeException);
            }
        }
    }

    public static class zza<R extends Result>
    extends Handler {
        public zza() {
            this(Looper.getMainLooper());
        }

        public zza(Looper looper) {
            super(looper);
        }

        public void zza(ResultCallback<? super R> resultCallback, R r) {
            this.sendMessage(this.obtainMessage(1, new Pair(resultCallback, r)));
        }

        public void zza(zzly<R> zzly2, long l) {
            this.sendMessageDelayed(this.obtainMessage(2, zzly2), l);
        }

        public void zzoS() {
            this.removeMessages(2);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Pair pair = (Pair)msg.obj;
                    this.zzb((ResultCallback)pair.first, (Result)pair.second);
                    return;
                }
                case 2: {
                    zzly zzly2 = (zzly)msg.obj;
                    zzly2.zzy(Status.zzafa);
                    return;
                }
            }
            Log.wtf((String)"BasePendingResult", (String)("Don't know how to handle message: " + msg.what), (Throwable)new Exception());
        }

        protected void zzb(ResultCallback<? super R> resultCallback, R r) {
            try {
                resultCallback.onResult(r);
            }
            catch (RuntimeException runtimeException) {
                zzly.zzd(r);
                throw runtimeException;
            }
        }
    }
}

