/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.app.Dialog;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzmk;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class zzmr
extends Fragment
implements DialogInterface.OnCancelListener {
    private static final GoogleApiAvailability zzagU = GoogleApiAvailability.getInstance();
    private boolean mStarted;
    private boolean zzagV;
    private int zzagW = -1;
    private ConnectionResult zzagX;
    private final Handler zzagY = new Handler(Looper.getMainLooper());
    private zzmk zzagZ;
    private final SparseArray<zza> zzaha = new SparseArray();

    public static zzmr zza(FragmentActivity fragmentActivity) {
        zzmr zzmr2;
        zzx.zzcx("Must be called from main thread of process");
        FragmentManager fragmentManager = fragmentActivity.getSupportFragmentManager();
        try {
            zzmr2 = (zzmr)fragmentManager.findFragmentByTag("GmsSupportLifecycleFrag");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Fragment with tag GmsSupportLifecycleFrag is not a SupportLifecycleFragment", classCastException);
        }
        if (zzmr2 == null || zzmr2.isRemoving()) {
            return null;
        }
        return zzmr2;
    }

    public static zzmr zzb(FragmentActivity fragmentActivity) {
        zzmr zzmr2 = zzmr.zza(fragmentActivity);
        FragmentManager fragmentManager = fragmentActivity.getSupportFragmentManager();
        if (zzmr2 == null) {
            zzmr2 = new zzmr();
            fragmentManager.beginTransaction().add((Fragment)zzmr2, "GmsSupportLifecycleFrag").commitAllowingStateLoss();
            fragmentManager.executePendingTransactions();
        }
        return zzmr2;
    }

    public void zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzx.zzb(googleApiClient, (Object)"GoogleApiClient instance cannot be null");
        zzx.zza(this.zzaha.indexOfKey(n) < 0, (Object)("Already managing a GoogleApiClient with id " + n));
        zza zza2 = new zza(n, googleApiClient, onConnectionFailedListener);
        this.zzaha.put(n, (Object)zza2);
        if (this.mStarted && !this.zzagV) {
            googleApiClient.connect();
        }
    }

    public void zzbE(int n) {
        zza zza2 = (zza)this.zzaha.get(n);
        this.zzaha.remove(n);
        if (zza2 != null) {
            zza2.zzpC();
        }
    }

    public void onCancel(DialogInterface dialogInterface) {
        this.zza(this.zzagW, new ConnectionResult(13, null));
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.zzagV = savedInstanceState.getBoolean("resolving_error", false);
            this.zzagW = savedInstanceState.getInt("failed_client_id", -1);
            if (this.zzagW >= 0) {
                this.zzagX = new ConnectionResult(savedInstanceState.getInt("failed_status"), (PendingIntent)savedInstanceState.getParcelable("failed_resolution"));
            }
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("resolving_error", this.zzagV);
        if (this.zzagW >= 0) {
            outState.putInt("failed_client_id", this.zzagW);
            outState.putInt("failed_status", this.zzagX.getErrorCode());
            outState.putParcelable("failed_resolution", (Parcelable)this.zzagX.getResolution());
        }
    }

    public void onStart() {
        super.onStart();
        this.mStarted = true;
        if (!this.zzagV) {
            for (int i = 0; i < this.zzaha.size(); ++i) {
                zza zza2 = (zza)this.zzaha.valueAt(i);
                zza2.zzahc.connect();
            }
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        boolean bl = false;
        switch (requestCode) {
            case 2: {
                if (zzagU.isGooglePlayServicesAvailable((Context)this.getActivity()) != 0) break;
                bl = true;
                break;
            }
            case 1: {
                if (resultCode == -1) {
                    bl = true;
                    break;
                }
                if (resultCode != 0) break;
                this.zzagX = new ConnectionResult(13, null);
            }
        }
        if (bl) {
            this.zzpA();
        } else {
            this.zza(this.zzagW, this.zzagX);
        }
    }

    public void onStop() {
        super.onStop();
        this.mStarted = false;
        for (int i = 0; i < this.zzaha.size(); ++i) {
            zza zza2 = (zza)this.zzaha.valueAt(i);
            zza2.zzahc.disconnect();
        }
    }

    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        super.dump(prefix, fd, writer, args);
        for (int i = 0; i < this.zzaha.size(); ++i) {
            zza zza2 = (zza)this.zzaha.valueAt(i);
            zza2.dump(prefix, fd, writer, args);
        }
    }

    private void zza(int n, ConnectionResult connectionResult) {
        Log.w((String)"GmsSupportLifecycleFrag", (String)"Unresolved error while connecting client. Stopping auto-manage.");
        zza zza2 = (zza)this.zzaha.get(n);
        if (zza2 != null) {
            this.zzbE(n);
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = zza2.zzahd;
            if (onConnectionFailedListener != null) {
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
        this.zzpA();
    }

    private void zzpA() {
        this.zzagV = false;
        this.zzagW = -1;
        this.zzagX = null;
        if (this.zzagZ != null) {
            this.zzagZ.unregister();
            this.zzagZ = null;
        }
        for (int i = 0; i < this.zzaha.size(); ++i) {
            zza zza2 = (zza)this.zzaha.valueAt(i);
            zza2.zzahc.connect();
        }
    }

    private class zza
    implements GoogleApiClient.OnConnectionFailedListener {
        public final int zzahb;
        public final GoogleApiClient zzahc;
        public final GoogleApiClient.OnConnectionFailedListener zzahd;

        public zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.zzahb = n;
            this.zzahc = googleApiClient;
            this.zzahd = onConnectionFailedListener;
            googleApiClient.registerConnectionFailedListener(this);
        }

        @Override
        public void onConnectionFailed(ConnectionResult result) {
            zzmr.this.zzagY.post((Runnable)new zzb(this.zzahb, result));
        }

        public void zzpC() {
            this.zzahc.unregisterConnectionFailedListener(this);
            this.zzahc.disconnect();
        }

        public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            writer.append(prefix).append("GoogleApiClient #").print(this.zzahb);
            writer.println(":");
            this.zzahc.dump(prefix + "  ", fd, writer, args);
        }
    }

    private class zzb
    implements Runnable {
        private final int zzahf;
        private final ConnectionResult zzahg;

        public zzb(int n, ConnectionResult connectionResult) {
            this.zzahf = n;
            this.zzahg = connectionResult;
        }

        @Override
        public void run() {
            if (!zzmr.this.mStarted || zzmr.this.zzagV) {
                return;
            }
            zzmr.this.zzagV = true;
            zzmr.this.zzagW = this.zzahf;
            zzmr.this.zzagX = this.zzahg;
            if (this.zzahg.hasResolution()) {
                try {
                    int n = zzmr.this.getActivity().getSupportFragmentManager().getFragments().indexOf((Object)zzmr.this);
                    int n2 = 1 + (1 + n << 16);
                    this.zzahg.startResolutionForResult((Activity)zzmr.this.getActivity(), n2);
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    zzmr.this.zzpA();
                }
            } else if (zzagU.isUserResolvableError(this.zzahg.getErrorCode())) {
                GooglePlayServicesUtil.showErrorDialogFragment(this.zzahg.getErrorCode(), (Activity)zzmr.this.getActivity(), zzmr.this, 2, zzmr.this);
            } else if (this.zzahg.getErrorCode() == 18) {
                final Dialog dialog = zzagU.zza((Activity)zzmr.this.getActivity(), zzmr.this);
                zzmr.this.zzagZ = zzmk.zza(zzmr.this.getActivity().getApplicationContext(), new zzmk(){

                    @Override
                    protected void zzpv() {
                        zzmr.this.zzpA();
                        dialog.dismiss();
                    }
                });
            } else {
                zzmr.this.zza(this.zzahf, this.zzahg);
            }
        }
    }
}

