/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.common.api.internal.zzg;
import com.google.android.gms.common.api.internal.zzh;
import com.google.android.gms.common.api.internal.zzi;
import com.google.android.gms.common.api.internal.zzj;
import com.google.android.gms.common.api.internal.zzk;
import com.google.android.gms.common.api.internal.zzp;
import com.google.android.gms.common.api.internal.zzu;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.zzc;
import com.google.android.gms.internal.zzrn;
import com.google.android.gms.internal.zzro;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public class zzl
implements zzp {
    private final Lock zzXG;
    private final Condition zzaim;
    private final Context mContext;
    private final zzc zzags;
    private final zzb zzain;
    final Map<Api.zzc<?>, Api.zzb> zzahT;
    final Map<Api.zzc<?>, ConnectionResult> zzaio = new HashMap();
    final zzf zzahz;
    final Map<Api<?>, Integer> zzahA;
    final Api.zza<? extends zzrn, zzro> zzagt;
    private volatile zzk zzaip;
    private ConnectionResult zzaiq = null;
    int zzair;
    final zzj zzagW;
    final zzp.zza zzais;

    public zzl(Context context, zzj zzj2, Lock lock, Looper looper, zzc zzc2, Map<Api.zzc<?>, Api.zzb> map, zzf zzf2, Map<Api<?>, Integer> map2, Api.zza<? extends zzrn, zzro> zza2, ArrayList<com.google.android.gms.common.api.internal.zzc> arrayList, zzp.zza zza3) {
        this.mContext = context;
        this.zzXG = lock;
        this.zzags = zzc2;
        this.zzahT = map;
        this.zzahz = zzf2;
        this.zzahA = map2;
        this.zzagt = zza2;
        this.zzagW = zzj2;
        this.zzais = zza3;
        for (com.google.android.gms.common.api.internal.zzc zzc3 : arrayList) {
            zzc3.zza(this);
        }
        this.zzain = new zzb(looper);
        this.zzaim = lock.newCondition();
        this.zzaip = new zzi(this);
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zza.zza<R, A>> T zza(@NonNull T t) {
        return this.zzaip.zza(t);
    }

    @Override
    public <A extends Api.zzb, T extends zza.zza<? extends Result, A>> T zzb(@NonNull T t) {
        return this.zzaip.zzb(t);
    }

    @Override
    public void connect() {
        this.zzaip.connect();
    }

    @Override
    public ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zzaim.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzafB;
        }
        if (this.zzaiq != null) {
            return this.zzaiq;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public ConnectionResult blockingConnect(long timeout, TimeUnit unit) {
        this.connect();
        long l = unit.toNanos(timeout);
        while (this.isConnecting()) {
            try {
                if (l <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l = this.zzaim.awaitNanos(l);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzafB;
        }
        if (this.zzaiq != null) {
            return this.zzaiq;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public boolean disconnect() {
        boolean bl = this.zzaip.disconnect();
        if (bl) {
            this.zzaio.clear();
        }
        return bl;
    }

    @Override
    @Nullable
    public ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        Api.zzc<?> zzc2 = api.zzoR();
        if (this.zzahT.containsKey(zzc2)) {
            if (this.zzahT.get(zzc2).isConnected()) {
                return ConnectionResult.zzafB;
            }
            if (this.zzaio.containsKey(zzc2)) {
                return this.zzaio.get(zzc2);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzpK() {
        this.zzXG.lock();
        try {
            this.zzaip = new zzh(this, this.zzahz, this.zzahA, this.zzags, this.zzagt, this.zzXG, this.mContext);
            this.zzaip.begin();
            this.zzaim.signalAll();
        }
        finally {
            this.zzXG.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzpL() {
        this.zzXG.lock();
        try {
            this.zzagW.zzpF();
            this.zzaip = new zzg(this);
            this.zzaip.begin();
            this.zzaim.signalAll();
        }
        finally {
            this.zzXG.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzh(ConnectionResult connectionResult) {
        this.zzXG.lock();
        try {
            this.zzaiq = connectionResult;
            this.zzaip = new zzi(this);
            this.zzaip.begin();
            this.zzaim.signalAll();
        }
        finally {
            this.zzXG.unlock();
        }
    }

    void zzpM() {
        for (Api.zzb zzb2 : this.zzahT.values()) {
            zzb2.disconnect();
        }
    }

    @Override
    public boolean isConnected() {
        return this.zzaip instanceof zzg;
    }

    @Override
    public boolean isConnecting() {
        return this.zzaip instanceof zzh;
    }

    @Override
    public boolean zza(zzu zzu2) {
        return false;
    }

    @Override
    public void zzoW() {
    }

    @Override
    public void zzpj() {
        if (this.isConnected()) {
            ((zzg)this.zzaip).zzps();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(@NonNull ConnectionResult connectionResult, @NonNull Api<?> api, int n) {
        this.zzXG.lock();
        try {
            this.zzaip.zza(connectionResult, api, n);
        }
        finally {
            this.zzXG.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnected(@Nullable Bundle connectionHint) {
        this.zzXG.lock();
        try {
            this.zzaip.onConnected(connectionHint);
        }
        finally {
            this.zzXG.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnectionSuspended(int cause) {
        this.zzXG.lock();
        try {
            this.zzaip.onConnectionSuspended(cause);
        }
        finally {
            this.zzXG.unlock();
        }
    }

    void zza(zza zza2) {
        Message message = this.zzain.obtainMessage(1, zza2);
        this.zzain.sendMessage(message);
    }

    void zza(RuntimeException runtimeException) {
        Message message = this.zzain.obtainMessage(2, runtimeException);
        this.zzain.sendMessage(message);
    }

    @Override
    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        String string2 = prefix + "  ";
        for (Api<?> api : this.zzahA.keySet()) {
            writer.append(prefix).append(api.getName()).println(":");
            Api.zzb zzb2 = this.zzahT.get(api.zzoR());
            zzb2.dump(string2, fd, writer, args);
        }
    }

    static abstract class zza {
        private final zzk zzait;

        protected zza(zzk zzk2) {
            this.zzait = zzk2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void zzd(zzl zzl2) {
            zzl2.zzXG.lock();
            try {
                if (zzl2.zzaip != this.zzait) {
                    return;
                }
                this.zzpt();
            }
            finally {
                zzl2.zzXG.unlock();
            }
        }

        protected abstract void zzpt();
    }

    final class zzb
    extends Handler {
        zzb(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    zza zza2 = (zza)msg.obj;
                    zza2.zzd(zzl.this);
                    break;
                }
                case 2: {
                    throw (RuntimeException)msg.obj;
                }
                default: {
                    Log.w((String)"GACStateManager", (String)("Unknown message id: " + msg.what));
                }
            }
        }
    }
}

