/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.identifier;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.stats.zzb;
import com.google.android.gms.common.zzc;
import com.google.android.gms.internal.zzbu;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class AdvertisingIdClient {
    com.google.android.gms.common.zza zzpE;
    zzbu zzpF;
    boolean zzpG;
    Object zzpH = new Object();
    zza zzpI;
    private final Context mContext;
    final long zzpJ;

    public AdvertisingIdClient(Context context) {
        this(context, 30000L);
    }

    public AdvertisingIdClient(Context context, long l) {
        zzaa.zzz(context);
        this.mContext = context;
        this.zzpG = false;
        this.zzpJ = l;
    }

    public void start() throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        this.zzd(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzd(boolean bl) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        zzaa.zzdd("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.zzpG) {
                this.finish();
            }
            this.zzpE = AdvertisingIdClient.zzh(this.mContext);
            this.zzpF = AdvertisingIdClient.zza(this.mContext, this.zzpE);
            this.zzpG = true;
            if (bl) {
                this.zzbd();
            }
        }
    }

    public static void setShouldSkipGmsCoreVersionCheck(boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzbd() {
        Object object = this.zzpH;
        synchronized (object) {
            if (this.zzpI != null) {
                this.zzpI.cancel();
                try {
                    this.zzpI.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.zzpJ > 0L) {
                this.zzpI = new zza(this, this.zzpJ);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Info getInfo() throws IOException {
        zzaa.zzdd("Calling this from your main thread can lead to deadlock");
        Info info = null;
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (!this.zzpG) {
                Object object = this.zzpH;
                synchronized (object) {
                    if (this.zzpI == null || !this.zzpI.zzbe()) {
                        throw new IOException("AdvertisingIdClient is not connected.");
                    }
                }
                try {
                    this.zzd(false);
                }
                catch (Exception exception) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.", exception);
                }
                if (!this.zzpG) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.");
                }
            }
            zzaa.zzz(this.zzpE);
            zzaa.zzz(this.zzpF);
            try {
                info = new Info(this.zzpF.getId(), this.zzpF.zze(true));
            }
            catch (RemoteException remoteException) {
                Log.i((String)"AdvertisingIdClient", (String)"GMS remote exception ", (Throwable)remoteException);
                throw new IOException("Remote exception");
            }
        }
        this.zzbd();
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        zzaa.zzdd("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.mContext == null || this.zzpE == null) {
                return;
            }
            try {
                if (this.zzpG) {
                    zzb.zzuH().zza(this.mContext, this.zzpE);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.i((String)"AdvertisingIdClient", (String)"AdvertisingIdClient unbindService failed.", (Throwable)illegalArgumentException);
            }
            this.zzpG = false;
            this.zzpF = null;
            this.zzpE = null;
        }
    }

    protected void finalize() throws Throwable {
        this.finish();
        super.finalize();
    }

    static com.google.android.gms.common.zza zzh(Context context) throws IOException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        try {
            PackageManager packageManager = context.getPackageManager();
            packageManager.getPackageInfo("com.android.vending", 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new GooglePlayServicesNotAvailableException(9);
        }
        int n = zzc.zzqV().isGooglePlayServicesAvailable(context);
        switch (n) {
            case 0: 
            case 2: {
                break;
            }
            default: {
                throw new IOException("Google Play services not available");
            }
        }
        com.google.android.gms.common.zza zza2 = new com.google.android.gms.common.zza();
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        try {
            if (zzb.zzuH().zza(context, intent, zza2, 1)) {
                return zza2;
            }
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
        throw new IOException("Connection failure");
    }

    public static Info getAdvertisingIdInfo(Context context) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(context, -1L);
        try {
            advertisingIdClient.zzd(false);
            Info info = advertisingIdClient.getInfo();
            return info;
        }
        finally {
            advertisingIdClient.finish();
        }
    }

    static zzbu zza(Context context, com.google.android.gms.common.zza zza2) throws IOException {
        try {
            return zzbu.zza.zzf(zza2.zza(10000L, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted exception");
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }

    public static final class Info {
        private final String zzpO;
        private final boolean zzpP;

        public Info(String string, boolean bl) {
            this.zzpO = string;
            this.zzpP = bl;
        }

        public String getId() {
            return this.zzpO;
        }

        public boolean isLimitAdTrackingEnabled() {
            return this.zzpP;
        }

        public String toString() {
            String string = this.zzpO;
            boolean bl = this.zzpP;
            return new StringBuilder(7 + String.valueOf(string).length()).append("{").append(string).append("}").append(bl).toString();
        }
    }

    static class zza
    extends Thread {
        private WeakReference<AdvertisingIdClient> zzpK;
        private long zzpL;
        CountDownLatch zzpM;
        boolean zzpN;

        public zza(AdvertisingIdClient advertisingIdClient, long l) {
            this.zzpK = new WeakReference<AdvertisingIdClient>(advertisingIdClient);
            this.zzpL = l;
            this.zzpM = new CountDownLatch(1);
            this.zzpN = false;
            this.start();
        }

        public void cancel() {
            this.zzpM.countDown();
        }

        public boolean zzbe() {
            return this.zzpN;
        }

        private void disconnect() {
            AdvertisingIdClient advertisingIdClient = (AdvertisingIdClient)this.zzpK.get();
            if (advertisingIdClient != null) {
                advertisingIdClient.finish();
                this.zzpN = true;
            }
        }

        @Override
        public void run() {
            try {
                if (!this.zzpM.await(this.zzpL, TimeUnit.MILLISECONDS)) {
                    this.disconnect();
                }
            }
            catch (InterruptedException interruptedException) {
                this.disconnect();
            }
        }
    }
}

