/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.content.IntentSender;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallbacks;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzaa;

public abstract class ResolvingResultCallbacks<R extends Result>
extends ResultCallbacks<R> {
    private final Activity mActivity;
    private final int zzalt;

    protected ResolvingResultCallbacks(@NonNull Activity activity, int n) {
        this.mActivity = zzaa.zzb(activity, (Object)"Activity must not be null");
        this.zzalt = n;
    }

    @Override
    public final void onFailure(@NonNull Status status) {
        if (status.hasResolution()) {
            try {
                status.startResolutionForResult(this.mActivity, this.zzalt);
            }
            catch (IntentSender.SendIntentException sendIntentException) {
                Log.e((String)"ResolvingResultCallback", (String)"Failed to start resolution", (Throwable)sendIntentException);
                this.onUnresolvableFailure(new Status(8));
            }
        } else {
            this.onUnresolvableFailure(status);
        }
    }

    @Override
    public abstract void onSuccess(@NonNull R var1);

    public abstract void onUnresolvableFailure(@NonNull Status var1);
}

