/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzakd;
import com.google.android.gms.internal.zzake;
import com.google.android.gms.internal.zzakf;
import com.google.android.gms.internal.zzakj;
import com.google.android.gms.internal.zzakl;
import com.google.android.gms.internal.zzakm;
import com.google.android.gms.internal.zzakn;
import com.google.android.gms.internal.zzako;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class zzaju
implements zzake<Date>,
zzakn<Date> {
    private final DateFormat zzbVN;
    private final DateFormat zzbVO;
    private final DateFormat zzbVP;

    zzaju() {
        this(DateFormat.getDateTimeInstance(2, 2, Locale.US), DateFormat.getDateTimeInstance(2, 2));
    }

    zzaju(String string2) {
        this(new SimpleDateFormat(string2, Locale.US), new SimpleDateFormat(string2));
    }

    public zzaju(int n, int n2) {
        this(DateFormat.getDateTimeInstance(n, n2, Locale.US), DateFormat.getDateTimeInstance(n, n2));
    }

    zzaju(DateFormat dateFormat, DateFormat dateFormat2) {
        this.zzbVN = dateFormat;
        this.zzbVO = dateFormat2;
        this.zzbVP = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        this.zzbVP.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public zzakf zza(Date date, Type type, zzakm zzakm2) {
        DateFormat dateFormat = this.zzbVO;
        synchronized (dateFormat) {
            String string2 = this.zzbVN.format(date);
            return new zzakl(string2);
        }
    }

    public Date zza(zzakf zzakf2, Type type, zzakd zzakd2) throws zzakj {
        if (!(zzakf2 instanceof zzakl)) {
            throw new zzakj("The date should be a string value");
        }
        Date date = this.zza(zzakf2);
        if (type == Date.class) {
            return date;
        }
        if (type == Timestamp.class) {
            return new Timestamp(date.getTime());
        }
        if (type == java.sql.Date.class) {
            return new java.sql.Date(date.getTime());
        }
        String string2 = String.valueOf(this.getClass());
        String string3 = String.valueOf(type);
        throw new IllegalArgumentException(new StringBuilder(23 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(" cannot deserialize to ").append(string3).toString());
    }

    private Date zza(zzakf zzakf2) {
        DateFormat dateFormat = this.zzbVO;
        synchronized (dateFormat) {
            try {
                return this.zzbVO.parse(zzakf2.zzVA());
            }
            catch (ParseException parseException) {
                try {
                    return this.zzbVN.parse(zzakf2.zzVA());
                }
                catch (ParseException parseException2) {
                    try {
                        return this.zzbVP.parse(zzakf2.zzVA());
                    }
                    catch (ParseException parseException3) {
                        throw new zzako(zzakf2.zzVA(), parseException3);
                    }
                }
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(zzaju.class.getSimpleName());
        stringBuilder.append('(').append(this.zzbVO.getClass().getSimpleName()).append(')');
        return stringBuilder.toString();
    }

    @Override
    public /* synthetic */ Object zzb(zzakf zzakf2, Type type, zzakd zzakd2) throws zzakj {
        return this.zza(zzakf2, type, zzakd2);
    }
}

