/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.annotation.TargetApi;
import android.os.Binder;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.google.android.gms.iid.zzb;

public class MessengerCompat
implements Parcelable {
    Messenger zzaUn;
    zzb zzaUo;
    public static final Parcelable.Creator<MessengerCompat> CREATOR = new Parcelable.Creator<MessengerCompat>(){

        public MessengerCompat zzeS(Parcel parcel) {
            IBinder iBinder = parcel.readStrongBinder();
            return iBinder != null ? new MessengerCompat(iBinder) : null;
        }

        public MessengerCompat[] zzhO(int n) {
            return new MessengerCompat[n];
        }

        public /* synthetic */ Object[] newArray(int n) {
            return this.zzhO(n);
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzeS(parcel);
        }
    };

    public MessengerCompat(Handler handler) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.zzaUn = new Messenger(handler);
        } else {
            this.zzaUo = new zza(handler);
        }
    }

    public MessengerCompat(IBinder iBinder) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.zzaUn = new Messenger(iBinder);
        } else {
            this.zzaUo = zzb.zza.zzcl(iBinder);
        }
    }

    public static int zzc(Message message) {
        if (Build.VERSION.SDK_INT >= 21) {
            return MessengerCompat.zzd(message);
        }
        return message.arg2;
    }

    @TargetApi(value=21)
    private static int zzd(Message message) {
        return message.sendingUid;
    }

    public void send(Message message) throws RemoteException {
        if (this.zzaUn != null) {
            this.zzaUn.send(message);
        } else {
            this.zzaUo.send(message);
        }
    }

    public IBinder getBinder() {
        return this.zzaUn != null ? this.zzaUn.getBinder() : this.zzaUo.asBinder();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            return this.getBinder().equals(((MessengerCompat)object).getBinder());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return this.getBinder().hashCode();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (this.zzaUn != null) {
            parcel.writeStrongBinder(this.zzaUn.getBinder());
        } else {
            parcel.writeStrongBinder(this.zzaUo.asBinder());
        }
    }

    private final class zza
    extends zzb.zza {
        Handler handler;

        zza(Handler handler) {
            this.handler = handler;
        }

        @Override
        public void send(Message message) throws RemoteException {
            message.arg2 = Binder.getCallingUid();
            this.handler.dispatchMessage(message);
        }
    }
}

