/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzakb;
import com.google.android.gms.internal.zzakg;
import com.google.android.gms.internal.zzald;
import com.google.android.gms.internal.zzale;
import com.google.android.gms.internal.zzalh;
import com.google.android.gms.internal.zzalv;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class zzakz {
    private final Map<Type, zzakb<?>> zzbWm;

    public zzakz(Map<Type, zzakb<?>> map) {
        this.zzbWm = map;
    }

    public <T> zzale<T> zzb(zzalv<T> zzalv2) {
        final Type type = zzalv2.zzWm();
        Class<T> clazz = zzalv2.zzWl();
        final zzakb<?> zzakb2 = this.zzbWm.get(type);
        if (zzakb2 != null) {
            return new zzale<T>(){

                @Override
                public T zzVT() {
                    return zzakb2.zza(type);
                }
            };
        }
        final zzakb<?> zzakb3 = this.zzbWm.get(clazz);
        if (zzakb3 != null) {
            return new zzale<T>(){

                @Override
                public T zzVT() {
                    return zzakb3.zza(type);
                }
            };
        }
        zzale<T> zzale2 = this.zzl(clazz);
        if (zzale2 != null) {
            return zzale2;
        }
        zzale<T> zzale3 = this.zzc(type, clazz);
        if (zzale3 != null) {
            return zzale3;
        }
        return this.zzd(type, clazz);
    }

    private <T> zzale<T> zzl(Class<? super T> clazz) {
        try {
            final Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return new zzale<T>(){

                @Override
                public T zzVT() {
                    try {
                        Object var1_1 = null;
                        return constructor.newInstance(null);
                    }
                    catch (InstantiationException instantiationException) {
                        String string2 = String.valueOf(constructor);
                        throw new RuntimeException(new StringBuilder(30 + String.valueOf(string2).length()).append("Failed to invoke ").append(string2).append(" with no args").toString(), instantiationException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        String string3 = String.valueOf(constructor);
                        throw new RuntimeException(new StringBuilder(30 + String.valueOf(string3).length()).append("Failed to invoke ").append(string3).append(" with no args").toString(), invocationTargetException.getTargetException());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new AssertionError((Object)illegalAccessException);
                    }
                }
            };
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private <T> zzale<T> zzc(final Type type, Class<? super T> clazz) {
        if (Collection.class.isAssignableFrom(clazz)) {
            if (SortedSet.class.isAssignableFrom(clazz)) {
                return new zzale<T>(){

                    @Override
                    public T zzVT() {
                        return new TreeSet();
                    }
                };
            }
            if (EnumSet.class.isAssignableFrom(clazz)) {
                return new zzale<T>(){

                    @Override
                    public T zzVT() {
                        if (type instanceof ParameterizedType) {
                            Type type2 = ((ParameterizedType)type).getActualTypeArguments()[0];
                            if (type2 instanceof Class) {
                                return EnumSet.noneOf((Class)type2);
                            }
                            String string2 = String.valueOf(type.toString());
                            throw new zzakg(string2.length() != 0 ? "Invalid EnumSet type: ".concat(string2) : new String("Invalid EnumSet type: "));
                        }
                        String string3 = String.valueOf(type.toString());
                        throw new zzakg(string3.length() != 0 ? "Invalid EnumSet type: ".concat(string3) : new String("Invalid EnumSet type: "));
                    }
                };
            }
            if (Set.class.isAssignableFrom(clazz)) {
                return new zzale<T>(){

                    @Override
                    public T zzVT() {
                        return new LinkedHashSet();
                    }
                };
            }
            if (Queue.class.isAssignableFrom(clazz)) {
                return new zzale<T>(){

                    @Override
                    public T zzVT() {
                        return new LinkedList();
                    }
                };
            }
            return new zzale<T>(){

                @Override
                public T zzVT() {
                    return new ArrayList();
                }
            };
        }
        if (Map.class.isAssignableFrom(clazz)) {
            if (SortedMap.class.isAssignableFrom(clazz)) {
                return new zzale<T>(){

                    @Override
                    public T zzVT() {
                        return new TreeMap();
                    }
                };
            }
            if (type instanceof ParameterizedType && !String.class.isAssignableFrom(zzalv.zzl(((ParameterizedType)type).getActualTypeArguments()[0]).zzWl())) {
                return new zzale<T>(){

                    @Override
                    public T zzVT() {
                        return new LinkedHashMap();
                    }
                };
            }
            return new zzale<T>(){

                @Override
                public T zzVT() {
                    return new zzald();
                }
            };
        }
        return null;
    }

    private <T> zzale<T> zzd(final Type type, final Class<? super T> clazz) {
        return new zzale<T>(){
            private final zzalh zzbWP = zzalh.zzVY();

            @Override
            public T zzVT() {
                try {
                    Object t = this.zzbWP.zzf(clazz);
                    return t;
                }
                catch (Exception exception) {
                    String string2 = String.valueOf(type);
                    throw new RuntimeException(new StringBuilder(116 + String.valueOf(string2).length()).append("Unable to invoke no-args constructor for ").append(string2).append(". ").append("Register an InstanceCreator with Gson for this type may fix this problem.").toString(), exception);
                }
            }
        };
    }

    public String toString() {
        return this.zzbWm.toString();
    }
}

