/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.server.response;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.server.converter.ConverterWrapper;
import com.google.android.gms.common.server.response.FieldMappingDictionary;
import com.google.android.gms.common.server.response.SafeParcelResponse;
import com.google.android.gms.common.util.zzc;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.common.util.zzq;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class FastJsonResponse {
    public abstract Map<String, Field<?, ?>> zzatr();

    protected abstract Object zzht(String var1);

    protected boolean zza(Field field) {
        if (field.zzatq() == 11) {
            if (field.zzatv()) {
                return this.zzhw(field.zzatw());
            }
            return this.zzhv(field.zzatw());
        }
        return this.zzhu(field.zzatw());
    }

    protected abstract boolean zzhu(String var1);

    protected boolean zzhv(String string2) {
        throw new UnsupportedOperationException("Concrete types not supported");
    }

    protected boolean zzhw(String string2) {
        throw new UnsupportedOperationException("Concrete type arrays not supported");
    }

    protected <O, I> I zza(Field<I, O> field, Object object) {
        if (((Field)field).zC != null) {
            return field.convertBack(object);
        }
        return (I)object;
    }

    public HashMap<String, Object> zzats() {
        return null;
    }

    public HashMap<String, Object> zzatt() {
        return null;
    }

    public String toString() {
        Map<String, Field<?, ?>> map = this.zzatr();
        StringBuilder stringBuilder = new StringBuilder(100);
        block5: for (String string2 : map.keySet()) {
            Field<?, ?> field = map.get(string2);
            if (!this.zza(field)) continue;
            Object object = this.zzb(field);
            Object obj = this.zza(field, object);
            if (stringBuilder.length() == 0) {
                stringBuilder.append("{");
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append("\"").append(string2).append("\":");
            if (obj == null) {
                stringBuilder.append("null");
                continue;
            }
            switch (field.zzatq()) {
                case 8: {
                    stringBuilder.append("\"").append(zzc.zzp((byte[])obj)).append("\"");
                    continue block5;
                }
                case 9: {
                    stringBuilder.append("\"").append(zzc.zzq((byte[])obj)).append("\"");
                    continue block5;
                }
                case 10: {
                    HashMap hashMap = (HashMap)obj;
                    zzq.zza(stringBuilder, hashMap);
                    continue block5;
                }
            }
            if (field.zzatu()) {
                this.zza(stringBuilder, field, (ArrayList)obj);
                continue;
            }
            this.zza(stringBuilder, field, obj);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append("}");
        } else {
            stringBuilder.append("{}");
        }
        return stringBuilder.toString();
    }

    protected Object zzb(Field field) {
        String string2 = field.zzatw();
        if (field.zzaty() != null) {
            HashMap<String, Object> hashMap;
            zzab.zza(this.zzht(field.zzatw()) == null, "Concrete field shouldn't be value object: %s", field.zzatw());
            HashMap<String, Object> hashMap2 = hashMap = field.zzatv() ? this.zzatt() : this.zzats();
            if (hashMap != null) {
                return hashMap.get(string2);
            }
            try {
                char c = Character.toUpperCase(string2.charAt(0));
                String string3 = String.valueOf(string2.substring(1));
                String string4 = new StringBuilder(4 + String.valueOf(string3).length()).append("get").append(c).append(string3).toString();
                return this.getClass().getMethod(string4, new Class[0]).invoke((Object)this, new Object[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return this.zzht(field.zzatw());
    }

    private void zza(StringBuilder stringBuilder, Field field, Object object) {
        if (field.zzatp() == 11) {
            Class<FastJsonResponse> clazz = field.zzaty();
            stringBuilder.append(clazz.cast(object).toString());
        } else if (field.zzatp() == 7) {
            stringBuilder.append("\"");
            stringBuilder.append(zzp.zzib((String)object));
            stringBuilder.append("\"");
        } else {
            stringBuilder.append(object);
        }
    }

    private void zza(StringBuilder stringBuilder, Field field, ArrayList<Object> arrayList) {
        stringBuilder.append("[");
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            if (i > 0) {
                stringBuilder.append(",");
            }
            if ((object = arrayList.get(i)) == null) continue;
            this.zza(stringBuilder, field, object);
        }
        stringBuilder.append("]");
    }

    public static interface zza<I, O> {
        public int zzatp();

        public int zzatq();

        public I convertBack(O var1);
    }

    public static class Field<I, O>
    extends AbstractSafeParcelable {
        private final int mVersionCode;
        protected final int zt;
        protected final boolean zu;
        protected final int zv;
        protected final boolean zw;
        protected final String zx;
        protected final int zy;
        protected final Class<? extends FastJsonResponse> zz;
        protected final String zA;
        private FieldMappingDictionary zB;
        private zza<I, O> zC;
        public static final com.google.android.gms.common.server.response.zza CREATOR = new com.google.android.gms.common.server.response.zza();

        Field(int n, int n2, boolean bl, int n3, boolean bl2, String string2, int n4, String string3, ConverterWrapper converterWrapper) {
            this.mVersionCode = n;
            this.zt = n2;
            this.zu = bl;
            this.zv = n3;
            this.zw = bl2;
            this.zx = string2;
            this.zy = n4;
            if (string3 == null) {
                this.zz = null;
                this.zA = null;
            } else {
                this.zz = SafeParcelResponse.class;
                this.zA = string3;
            }
            this.zC = converterWrapper == null ? null : converterWrapper.zzatn();
        }

        protected Field(int n, boolean bl, int n2, boolean bl2, String string2, int n3, Class<? extends FastJsonResponse> clazz, zza<I, O> zza2) {
            this.mVersionCode = 1;
            this.zt = n;
            this.zu = bl;
            this.zv = n2;
            this.zw = bl2;
            this.zx = string2;
            this.zy = n3;
            this.zz = clazz;
            this.zA = clazz == null ? null : clazz.getCanonicalName();
            this.zC = zza2;
        }

        public int getVersionCode() {
            return this.mVersionCode;
        }

        public int zzatp() {
            return this.zt;
        }

        public boolean zzatu() {
            return this.zu;
        }

        public int zzatq() {
            return this.zv;
        }

        public boolean zzatv() {
            return this.zw;
        }

        public String zzatw() {
            return this.zx;
        }

        public int zzatx() {
            return this.zy;
        }

        public Class<? extends FastJsonResponse> zzaty() {
            return this.zz;
        }

        String zzatz() {
            if (this.zA == null) {
                return null;
            }
            return this.zA;
        }

        public boolean zzaua() {
            return this.zC != null;
        }

        public void zza(FieldMappingDictionary fieldMappingDictionary) {
            this.zB = fieldMappingDictionary;
        }

        ConverterWrapper zzaub() {
            if (this.zC == null) {
                return null;
            }
            return ConverterWrapper.zza(this.zC);
        }

        public Map<String, Field<?, ?>> zzauc() {
            zzab.zzaa(this.zA);
            zzab.zzaa(this.zB);
            return this.zB.zzhx(this.zA);
        }

        public I convertBack(O o) {
            return this.zC.convertBack(o);
        }

        public static Field<Integer, Integer> zzj(String string2, int n) {
            return new Field<Integer, Integer>(0, false, 0, false, string2, n, null, null);
        }

        public static Field<Boolean, Boolean> zzk(String string2, int n) {
            return new Field<Boolean, Boolean>(6, false, 6, false, string2, n, null, null);
        }

        public static Field<String, String> zzl(String string2, int n) {
            return new Field<String, String>(7, false, 7, false, string2, n, null, null);
        }

        public static <T extends FastJsonResponse> Field<T, T> zza(String string2, int n, Class<T> clazz) {
            return new Field(11, false, 11, false, string2, n, clazz, null);
        }

        public static <T extends FastJsonResponse> Field<ArrayList<T>, ArrayList<T>> zzb(String string2, int n, Class<T> clazz) {
            return new Field<ArrayList<T>, ArrayList<T>>(11, true, 11, true, string2, n, clazz, null);
        }

        public static Field zza(String string2, int n, zza<?, ?> zza2, boolean bl) {
            return new Field(zza2.zzatp(), bl, zza2.zzatq(), false, string2, n, null, zza2);
        }

        public void writeToParcel(Parcel parcel, int n) {
            com.google.android.gms.common.server.response.zza.zza(this, parcel, n);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Field\n");
            stringBuilder.append("            versionCode=").append(this.mVersionCode).append('\n');
            stringBuilder.append("                 typeIn=").append(this.zt).append('\n');
            stringBuilder.append("            typeInArray=").append(this.zu).append('\n');
            stringBuilder.append("                typeOut=").append(this.zv).append('\n');
            stringBuilder.append("           typeOutArray=").append(this.zw).append('\n');
            stringBuilder.append("        outputFieldName=").append(this.zx).append('\n');
            stringBuilder.append("      safeParcelFieldId=").append(this.zy).append('\n');
            stringBuilder.append("       concreteTypeName=").append(this.zzatz()).append('\n');
            if (this.zzaty() != null) {
                stringBuilder.append("     concreteType.class=").append(this.zzaty().getCanonicalName()).append('\n');
            }
            stringBuilder.append("          converterName=").append(this.zC == null ? "null" : this.zC.getClass().getCanonicalName()).append('\n');
            return stringBuilder.toString();
        }
    }
}

