/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzapc;
import com.google.android.gms.internal.zzapf;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public final class zzaov {
    private final ByteBuffer bia;

    private zzaov(byte[] byArray, int n, int n2) {
        this(ByteBuffer.wrap(byArray, n, n2));
    }

    private zzaov(ByteBuffer byteBuffer) {
        this.bia = byteBuffer;
        this.bia.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static zzaov zzba(byte[] byArray) {
        return zzaov.zzc(byArray, 0, byArray.length);
    }

    public static zzaov zzc(byte[] byArray, int n, int n2) {
        return new zzaov(byArray, n, n2);
    }

    public void zza(int n, double d) throws IOException {
        this.zzai(n, 1);
        this.zzo(d);
    }

    public void zzc(int n, float f) throws IOException {
        this.zzai(n, 5);
        this.zzk(f);
    }

    public void zza(int n, long l) throws IOException {
        this.zzai(n, 0);
        this.zzcr(l);
    }

    public void zzb(int n, long l) throws IOException {
        this.zzai(n, 0);
        this.zzcs(l);
    }

    public void zzae(int n, int n2) throws IOException {
        this.zzai(n, 0);
        this.zzaem(n2);
    }

    public void zzc(int n, long l) throws IOException {
        this.zzai(n, 1);
        this.zzct(l);
    }

    public void zzj(int n, boolean bl) throws IOException {
        this.zzai(n, 0);
        this.zzde(bl);
    }

    public void zzr(int n, String string2) throws IOException {
        this.zzai(n, 2);
        this.zztf(string2);
    }

    public void zza(int n, zzapc zzapc2) throws IOException {
        this.zzai(n, 2);
        this.zzc(zzapc2);
    }

    public void zza(int n, byte[] byArray) throws IOException {
        this.zzai(n, 2);
        this.zzbb(byArray);
    }

    public void zzaf(int n, int n2) throws IOException {
        this.zzai(n, 0);
        this.zzaen(n2);
    }

    public void zzd(int n, long l) throws IOException {
        this.zzai(n, 0);
        this.zzcu(l);
    }

    public void zzo(double d) throws IOException {
        this.zzdb(Double.doubleToLongBits(d));
    }

    public void zzk(float f) throws IOException {
        this.zzaeu(Float.floatToIntBits(f));
    }

    public void zzcr(long l) throws IOException {
        this.zzcz(l);
    }

    public void zzcs(long l) throws IOException {
        this.zzcz(l);
    }

    public void zzaem(int n) throws IOException {
        if (n >= 0) {
            this.zzaes(n);
        } else {
            this.zzcz(n);
        }
    }

    public void zzct(long l) throws IOException {
        this.zzdb(l);
    }

    public void zzde(boolean bl) throws IOException {
        this.zzaeq(bl ? 1 : 0);
    }

    public void zztf(String string2) throws IOException {
        try {
            int n = zzaov.zzaet(string2.length());
            int n2 = zzaov.zzaet(string2.length() * 3);
            if (n == n2) {
                int n3 = this.bia.position();
                if (this.bia.remaining() < n) {
                    throw new zza(n3 + n, this.bia.limit());
                }
                this.bia.position(n3 + n);
                zzaov.zza((CharSequence)string2, this.bia);
                int n4 = this.bia.position();
                this.bia.position(n3);
                this.zzaes(n4 - n3 - n);
                this.bia.position(n4);
            } else {
                this.zzaes(zzaov.zzd(string2));
                zzaov.zza((CharSequence)string2, this.bia);
            }
        }
        catch (BufferOverflowException bufferOverflowException) {
            zza zza2 = new zza(this.bia.position(), this.bia.limit());
            zza2.initCause(bufferOverflowException);
            throw zza2;
        }
    }

    private static int zzd(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) < '\u0080'; ++n) {
        }
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
            } else {
                n3 += zzaov.zza(charSequence, n);
                break;
            }
            ++n;
        }
        if (n3 < n2) {
            long l = (long)n3 + 0x100000000L;
            throw new IllegalArgumentException(new StringBuilder(54).append("UTF-8 length does not fit in int: ").append(l).toString());
        }
        return n3;
    }

    private static int zza(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            char c = charSequence.charAt(i);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
                continue;
            }
            n3 += 2;
            if ('\ud800' > c || c > '\udfff') continue;
            int n4 = Character.codePointAt(charSequence, i);
            if (n4 < 65536) {
                int n5 = i;
                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n5).toString());
            }
            ++i;
        }
        return n3;
    }

    private static void zza(CharSequence charSequence, ByteBuffer byteBuffer) {
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (byteBuffer.hasArray()) {
            try {
                int n = zzaov.zza(charSequence, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
                byteBuffer.position(n - byteBuffer.arrayOffset());
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                BufferOverflowException bufferOverflowException = new BufferOverflowException();
                bufferOverflowException.initCause(arrayIndexOutOfBoundsException);
                throw bufferOverflowException;
            }
        } else {
            zzaov.zzb(charSequence, byteBuffer);
        }
    }

    private static void zzb(CharSequence charSequence, ByteBuffer byteBuffer) {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            int n2;
            char c;
            char c2 = charSequence.charAt(i);
            if (c2 < '\u0080') {
                byteBuffer.put((byte)c2);
                continue;
            }
            if (c2 < '\u0800') {
                byteBuffer.put((byte)(0x3C0 | c2 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c2));
                continue;
            }
            if (c2 < '\ud800' || '\udfff' < c2) {
                byteBuffer.put((byte)(0x1E0 | c2 >>> 12));
                byteBuffer.put((byte)(0x80 | 0x3F & c2 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c2));
                continue;
            }
            if (i + 1 == charSequence.length() || !Character.isSurrogatePair(c2, c = charSequence.charAt(++i))) {
                n2 = i - 1;
                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n2).toString());
            }
            n2 = Character.toCodePoint(c2, c);
            byteBuffer.put((byte)(0xF0 | n2 >>> 18));
            byteBuffer.put((byte)(0x80 | 0x3F & n2 >>> 12));
            byteBuffer.put((byte)(0x80 | 0x3F & n2 >>> 6));
            byteBuffer.put((byte)(0x80 | 0x3F & n2));
        }
    }

    private static int zza(CharSequence charSequence, byte[] byArray, int n, int n2) {
        char c;
        int n3;
        int n4 = charSequence.length();
        int n5 = n;
        int n6 = n + n2;
        for (n3 = 0; n3 < n4 && n3 + n < n6 && (c = charSequence.charAt(n3)) < '\u0080'; ++n3) {
            byArray[n + n3] = (byte)c;
        }
        if (n3 == n4) {
            return n + n4;
        }
        n5 = n + n3;
        while (n3 < n4) {
            int n7;
            char c2;
            c = charSequence.charAt(n3);
            if (c < '\u0080' && n5 < n6) {
                byArray[n5++] = (byte)c;
            } else if (c < '\u0800' && n5 <= n6 - 2) {
                byArray[n5++] = (byte)(0x3C0 | c >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & c);
            } else if ((c < '\ud800' || '\udfff' < c) && n5 <= n6 - 3) {
                byArray[n5++] = (byte)(0x1E0 | c >>> 12);
                byArray[n5++] = (byte)(0x80 | 0x3F & c >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & c);
            } else if (n5 <= n6 - 4) {
                if (n3 + 1 == charSequence.length() || !Character.isSurrogatePair(c, c2 = charSequence.charAt(++n3))) {
                    n7 = n3 - 1;
                    throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n7).toString());
                }
                n7 = Character.toCodePoint(c, c2);
                byArray[n5++] = (byte)(0xF0 | n7 >>> 18);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7 >>> 12);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7 >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7);
            } else {
                c2 = c;
                n7 = n5;
                throw new ArrayIndexOutOfBoundsException(new StringBuilder(37).append("Failed writing ").append(c2).append(" at index ").append(n7).toString());
            }
            ++n3;
        }
        return n5;
    }

    public void zzb(zzapc zzapc2) throws IOException {
        zzapc2.zza(this);
    }

    public void zzc(zzapc zzapc2) throws IOException {
        this.zzaes(zzapc2.an());
        zzapc2.zza(this);
    }

    public void zzbb(byte[] byArray) throws IOException {
        this.zzaes(byArray.length);
        this.zzbd(byArray);
    }

    public void zzaen(int n) throws IOException {
        this.zzaes(zzaov.zzaev(n));
    }

    public void zzcu(long l) throws IOException {
        this.zzcz(zzaov.zzdc(l));
    }

    public static int zzb(int n, double d) {
        return zzaov.zzaer(n) + zzaov.zzp(d);
    }

    public static int zzd(int n, float f) {
        return zzaov.zzaer(n) + zzaov.zzl(f);
    }

    public static int zze(int n, long l) {
        return zzaov.zzaer(n) + zzaov.zzcw(l);
    }

    public static int zzag(int n, int n2) {
        return zzaov.zzaer(n) + zzaov.zzaeo(n2);
    }

    public static int zzf(int n, long l) {
        return zzaov.zzaer(n) + zzaov.zzcx(l);
    }

    public static int zzk(int n, boolean bl) {
        return zzaov.zzaer(n) + zzaov.zzdf(bl);
    }

    public static int zzs(int n, String string2) {
        return zzaov.zzaer(n) + zzaov.zztg(string2);
    }

    public static int zzb(int n, zzapc zzapc2) {
        return zzaov.zzaer(n) * 2 + zzaov.zzd(zzapc2);
    }

    public static int zzc(int n, zzapc zzapc2) {
        return zzaov.zzaer(n) + zzaov.zze(zzapc2);
    }

    public static int zzb(int n, byte[] byArray) {
        return zzaov.zzaer(n) + zzaov.zzbc(byArray);
    }

    public static int zzah(int n, int n2) {
        return zzaov.zzaer(n) + zzaov.zzaep(n2);
    }

    public static int zzg(int n, long l) {
        return zzaov.zzaer(n) + zzaov.zzcy(l);
    }

    public static int zzp(double d) {
        return 8;
    }

    public static int zzl(float f) {
        return 4;
    }

    public static int zzcv(long l) {
        return zzaov.zzda(l);
    }

    public static int zzcw(long l) {
        return zzaov.zzda(l);
    }

    public static int zzaeo(int n) {
        if (n >= 0) {
            return zzaov.zzaet(n);
        }
        return 10;
    }

    public static int zzcx(long l) {
        return 8;
    }

    public static int zzdf(boolean bl) {
        return 1;
    }

    public static int zztg(String string2) {
        int n = zzaov.zzd(string2);
        return zzaov.zzaet(n) + n;
    }

    public static int zzd(zzapc zzapc2) {
        return zzapc2.ao();
    }

    public static int zze(zzapc zzapc2) {
        int n = zzapc2.ao();
        return zzaov.zzaet(n) + n;
    }

    public static int zzbc(byte[] byArray) {
        return zzaov.zzaet(byArray.length) + byArray.length;
    }

    public static int zzaep(int n) {
        return zzaov.zzaet(zzaov.zzaev(n));
    }

    public static int zzcy(long l) {
        return zzaov.zzda(zzaov.zzdc(l));
    }

    public int aa() {
        return this.bia.remaining();
    }

    public void ab() {
        if (this.aa() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    public void zzc(byte by) throws IOException {
        if (!this.bia.hasRemaining()) {
            throw new zza(this.bia.position(), this.bia.limit());
        }
        this.bia.put(by);
    }

    public void zzaeq(int n) throws IOException {
        this.zzc((byte)n);
    }

    public void zzbd(byte[] byArray) throws IOException {
        this.zzd(byArray, 0, byArray.length);
    }

    public void zzd(byte[] byArray, int n, int n2) throws IOException {
        if (this.bia.remaining() < n2) {
            throw new zza(this.bia.position(), this.bia.limit());
        }
        this.bia.put(byArray, n, n2);
    }

    public void zzai(int n, int n2) throws IOException {
        this.zzaes(zzapf.zzaj(n, n2));
    }

    public static int zzaer(int n) {
        return zzaov.zzaet(zzapf.zzaj(n, 0));
    }

    public void zzaes(int n) throws IOException {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.zzaeq(n);
                return;
            }
            this.zzaeq(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    public static int zzaet(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public void zzcz(long l) throws IOException {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.zzaeq((int)l);
                return;
            }
            this.zzaeq((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
    }

    public static int zzda(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((l & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((l & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((l & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((l & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((l & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((l & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((l & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    public void zzaeu(int n) throws IOException {
        if (this.bia.remaining() < 4) {
            throw new zza(this.bia.position(), this.bia.limit());
        }
        this.bia.putInt(n);
    }

    public void zzdb(long l) throws IOException {
        if (this.bia.remaining() < 8) {
            throw new zza(this.bia.position(), this.bia.limit());
        }
        this.bia.putLong(l);
    }

    public static int zzaev(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long zzdc(long l) {
        return l << 1 ^ l >> 63;
    }

    public static class zza
    extends IOException {
        zza(int n, int n2) {
            super(new StringBuilder(108).append("CodedOutputStream was writing to a flat byte array and ran out of space (pos ").append(n).append(" limit ").append(n2).append(").").toString());
        }
    }
}

