/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.BinderThread;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.GetServiceRequest;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzm;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzu;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class zzd<T extends IInterface> {
    private int xm;
    private long xn;
    private long xo;
    private int xp;
    private long xq;
    private final Context mContext;
    private final Looper zzahv;
    private final zzm xr;
    private final com.google.android.gms.common.zzc tz;
    final Handler mHandler;
    private final Object zzail = new Object();
    private final Object xs = new Object();
    private zzu xt;
    private zzf xu;
    private T xv;
    private final ArrayList<zze<?>> xw = new ArrayList();
    private zzh xx;
    private int xy = 1;
    private final zzb xz;
    private final zzc xA;
    private final int xB;
    private final String xC;
    protected AtomicInteger xD = new AtomicInteger(0);
    public static final String[] xE = new String[]{"service_esmobile", "service_googleme"};

    protected zzd(Context context, Looper looper, int n, zzb zzb2, zzc zzc2, String string2) {
        this(context, looper, zzm.zzce(context), com.google.android.gms.common.zzc.zzang(), n, zzab.zzy(zzb2), zzab.zzy(zzc2), string2);
    }

    protected zzd(Context context, Looper looper, zzm zzm2, com.google.android.gms.common.zzc zzc2, int n, zzb zzb2, zzc zzc3, String string2) {
        this.mContext = zzab.zzb(context, (Object)"Context must not be null");
        this.zzahv = zzab.zzb(looper, (Object)"Looper must not be null");
        this.xr = zzab.zzb(zzm2, (Object)"Supervisor must not be null");
        this.tz = zzab.zzb(zzc2, (Object)"API availability must not be null");
        this.mHandler = new zzd(looper);
        this.xB = n;
        this.xz = zzb2;
        this.xA = zzc3;
        this.xC = string2;
    }

    @NonNull
    protected abstract String zzqz();

    protected String zzart() {
        return "com.google.android.gms";
    }

    @NonNull
    protected abstract String zzra();

    @Nullable
    protected final String zzaru() {
        return this.xC == null ? this.mContext.getClass().getName() : this.xC;
    }

    @Nullable
    protected abstract T zzbb(IBinder var1);

    @CallSuper
    protected void zza(@NonNull T t) {
        this.xo = System.currentTimeMillis();
    }

    @CallSuper
    protected void onConnectionSuspended(int n) {
        this.xm = n;
        this.xn = System.currentTimeMillis();
    }

    @CallSuper
    protected void onConnectionFailed(ConnectionResult connectionResult) {
        this.xp = connectionResult.getErrorCode();
        this.xq = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(int n, T t) {
        zzab.zzbo(n == 3 == (t != null));
        Object object = this.zzail;
        synchronized (object) {
            this.xy = n;
            this.xv = t;
            this.zzc(n, t);
            switch (n) {
                case 2: {
                    this.zzarv();
                    break;
                }
                case 3: {
                    this.zza(t);
                    break;
                }
                case 1: {
                    this.zzarw();
                }
            }
        }
    }

    void zzc(int n, T t) {
    }

    private void zzarv() {
        String string2;
        if (this.xx != null) {
            String string3 = String.valueOf(this.zzqz());
            string2 = String.valueOf(this.zzart());
            Log.e((String)"GmsClient", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Calling connect() while still connected, missing disconnect() for ").append(string3).append(" on ").append(string2).toString());
            this.xr.zzb(this.zzqz(), this.zzart(), this.xx, this.zzaru());
            this.xD.incrementAndGet();
        }
        this.xx = new zzh(this.xD.get());
        boolean bl = this.xr.zza(this.zzqz(), this.zzart(), this.xx, this.zzaru());
        if (!bl) {
            string2 = String.valueOf(this.zzqz());
            String string4 = String.valueOf(this.zzart());
            Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string4).length()).append("unable to connect to service: ").append(string2).append(" on ").append(string4).toString());
            this.zza(16, null, this.xD.get());
        }
    }

    private void zzarw() {
        if (this.xx != null) {
            this.xr.zzb(this.zzqz(), this.zzart(), this.xx, this.zzaru());
            this.xx = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(int n, int n2, T t) {
        Object object = this.zzail;
        synchronized (object) {
            if (this.xy != n) {
                return false;
            }
            this.zzb(n2, t);
            return true;
        }
    }

    public void zzarx() {
        int n = this.tz.isGooglePlayServicesAvailable(this.mContext);
        if (n != 0) {
            this.zzb(1, null);
            this.xu = new zzi();
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.xD.get(), n));
            return;
        }
        this.zza(new zzi());
    }

    public void zza(@NonNull zzf zzf2) {
        this.xu = zzab.zzb(zzf2, (Object)"Connection progress callbacks cannot be null.");
        this.zzb(2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.zzail;
        synchronized (object) {
            return this.xy == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnecting() {
        Object object = this.zzail;
        synchronized (object) {
            return this.xy == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.xD.incrementAndGet();
        Object object = this.xw;
        synchronized (object) {
            int n = this.xw.size();
            for (int i = 0; i < n; ++i) {
                this.xw.get(i).zzasg();
            }
            this.xw.clear();
        }
        object = this.xs;
        synchronized (object) {
            this.xt = null;
        }
        this.zzb(1, null);
    }

    public void zzgc(int n) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, this.xD.get(), n));
    }

    public void zza(zzf zzf2, ConnectionResult connectionResult) {
        this.xu = zzab.zzb(zzf2, (Object)"Connection progress callbacks cannot be null.");
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.xD.get(), connectionResult.getErrorCode(), (Object)connectionResult.getResolution()));
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final Looper getLooper() {
        return this.zzahv;
    }

    public Account getAccount() {
        return null;
    }

    public final Account zzary() {
        return this.getAccount() != null ? this.getAccount() : new Account("<<default account>>", "com.google");
    }

    protected Bundle zzaeu() {
        return new Bundle();
    }

    @BinderThread
    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, n2, -1, (Object)new zzj(n, iBinder, bundle)));
    }

    protected void zza(int n, @Nullable Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(5, n2, -1, (Object)new zzk(n, bundle)));
    }

    protected final void zzarz() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    public Bundle zzamh() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T zzasa() throws DeadObjectException {
        Object object = this.zzail;
        synchronized (object) {
            if (this.xy == 4) {
                throw new DeadObjectException();
            }
            this.zzarz();
            zzab.zza(this.xv != null, (Object)"Client is connected but service is null");
            return this.xv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void zza(zzq zzq2, Set<Scope> set) {
        try {
            Bundle bundle = this.zzaeu();
            GetServiceRequest getServiceRequest = new GetServiceRequest(this.xB).zzhl(this.mContext.getPackageName()).zzn(bundle);
            if (set != null) {
                getServiceRequest.zzf(set);
            }
            if (this.zzafk()) {
                getServiceRequest.zzd(this.zzary()).zzb(zzq2);
            } else if (this.zzasb()) {
                getServiceRequest.zzd(this.getAccount());
            }
            Object object = this.xs;
            synchronized (object) {
                if (this.xt != null) {
                    this.xt.zza((zzt)new zzg(this, this.xD.get()), getServiceRequest);
                } else {
                    Log.w((String)"GmsClient", (String)"mServiceBroker is null, client disconnected");
                }
            }
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"service died");
            this.zzgc(1);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"Remote exception occurred", (Throwable)remoteException);
        }
    }

    public boolean zzafk() {
        return false;
    }

    public boolean zzasb() {
        return false;
    }

    public boolean zzanu() {
        return true;
    }

    public boolean zzafz() {
        return false;
    }

    public Intent zzaga() {
        throw new UnsupportedOperationException("Not a sign in API");
    }

    protected Set<Scope> zzasc() {
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3;
        long l;
        T t;
        int n;
        Object object = this.zzail;
        synchronized (object) {
            n = this.xy;
            t = this.xv;
        }
        printWriter.append(string2).append("mConnectState=");
        switch (n) {
            case 2: {
                printWriter.print("CONNECTING");
                break;
            }
            case 3: {
                printWriter.print("CONNECTED");
                break;
            }
            case 4: {
                printWriter.print("DISCONNECTING");
                break;
            }
            case 1: {
                printWriter.print("DISCONNECTED");
                break;
            }
            default: {
                printWriter.print("UNKNOWN");
            }
        }
        printWriter.append(" mService=");
        if (t == null) {
            printWriter.println("null");
        } else {
            printWriter.append(this.zzra()).append("@").println(Integer.toHexString(System.identityHashCode(t.asBinder())));
        }
        object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
        if (this.xo > 0L) {
            l = this.xo;
            string3 = String.valueOf(((DateFormat)object).format(new Date(this.xo)));
            printWriter.append(string2).append("lastConnectedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.xn > 0L) {
            printWriter.append(string2).append("lastSuspendedCause=");
            switch (this.xm) {
                case 1: {
                    printWriter.append("CAUSE_SERVICE_DISCONNECTED");
                    break;
                }
                case 2: {
                    printWriter.append("CAUSE_NETWORK_LOST");
                    break;
                }
                default: {
                    printWriter.append(String.valueOf(this.xm));
                }
            }
            l = this.xn;
            string3 = String.valueOf(((DateFormat)object).format(new Date(this.xn)));
            printWriter.append(" lastSuspendedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.xq > 0L) {
            printWriter.append(string2).append("lastFailedStatus=").append(CommonStatusCodes.getStatusCodeString(this.xp));
            l = this.xq;
            string3 = String.valueOf(((DateFormat)object).format(new Date(this.xq)));
            printWriter.append(" lastFailedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IBinder zzanv() {
        Object object = this.xs;
        synchronized (object) {
            if (this.xt == null) {
                return null;
            }
            return this.xt.asBinder();
        }
    }

    public static final class zzg
    extends zzt.zza {
        private zzd xI;
        private final int xJ;

        public zzg(@NonNull zzd zzd2, int n) {
            this.xI = zzd2;
            this.xJ = n;
        }

        @Override
        @BinderThread
        public void zzb(int n, @Nullable Bundle bundle) {
            Log.wtf((String)"GmsClient", (String)"received deprecated onAccountValidationComplete callback, ignoring", (Throwable)new Exception());
        }

        @Override
        @BinderThread
        public void zza(int n, @NonNull IBinder iBinder, @Nullable Bundle bundle) {
            zzab.zzb(this.xI, (Object)"onPostInitComplete can be called only once per call to getRemoteService");
            this.xI.zza(n, iBinder, bundle, this.xJ);
            this.zzash();
        }

        private void zzash() {
            this.xI = null;
        }
    }

    private abstract class zza
    extends zze<Boolean> {
        public final int statusCode;
        public final Bundle xF;

        @BinderThread
        protected zza(int n, Bundle bundle) {
            super(true);
            this.statusCode = n;
            this.xF = bundle;
        }

        protected abstract boolean zzasd();

        protected abstract void zzl(ConnectionResult var1);

        protected void zzc(Boolean bl) {
            if (bl == null) {
                zzd.this.zzb(1, null);
                return;
            }
            switch (this.statusCode) {
                case 0: {
                    if (this.zzasd()) break;
                    zzd.this.zzb(1, null);
                    this.zzl(new ConnectionResult(8, null));
                    break;
                }
                case 10: {
                    zzd.this.zzb(1, null);
                    throw new IllegalStateException("A fatal developer error has occurred. Check the logs for further information.");
                }
                default: {
                    zzd.this.zzb(1, null);
                    PendingIntent pendingIntent = null;
                    if (this.xF != null) {
                        pendingIntent = (PendingIntent)this.xF.getParcelable("pendingIntent");
                    }
                    this.zzl(new ConnectionResult(this.statusCode, pendingIntent));
                }
            }
        }

        @Override
        protected void zzase() {
        }

        @Override
        protected /* synthetic */ void zzv(Object object) {
            this.zzc((Boolean)object);
        }
    }

    protected final class zzj
    extends zza {
        public final IBinder xK;

        @BinderThread
        public zzj(int n, IBinder iBinder, Bundle bundle) {
            super(n, bundle);
            this.xK = iBinder;
        }

        @Override
        protected void zzl(ConnectionResult connectionResult) {
            if (zzd.this.xA != null) {
                zzd.this.xA.onConnectionFailed(connectionResult);
            }
            zzd.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected boolean zzasd() {
            String string2;
            try {
                string2 = this.xK.getInterfaceDescriptor();
            }
            catch (RemoteException remoteException) {
                Log.w((String)"GmsClient", (String)"service probably died");
                return false;
            }
            if (!zzd.this.zzra().equals(string2)) {
                String string3 = String.valueOf(zzd.this.zzra());
                Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("service descriptor mismatch: ").append(string3).append(" vs. ").append(string2).toString());
                return false;
            }
            Object t = zzd.this.zzbb(this.xK);
            if (t != null && zzd.this.zza(2, 3, t)) {
                Bundle bundle = zzd.this.zzamh();
                if (zzd.this.xz != null) {
                    zzd.this.xz.onConnected(bundle);
                }
                return true;
            }
            return false;
        }
    }

    protected final class zzk
    extends zza {
        @BinderThread
        public zzk(int n, @Nullable Bundle bundle) {
            super(n, bundle);
        }

        @Override
        protected void zzl(ConnectionResult connectionResult) {
            zzd.this.xu.zzh(connectionResult);
            zzd.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected boolean zzasd() {
            zzd.this.xu.zzh(ConnectionResult.rb);
            return true;
        }
    }

    protected class zzi
    implements zzf {
        @Override
        public void zzh(@NonNull ConnectionResult connectionResult) {
            if (connectionResult.isSuccess()) {
                zzd.this.zza(null, zzd.this.zzasc());
            } else if (zzd.this.xA != null) {
                zzd.this.xA.onConnectionFailed(connectionResult);
            }
        }
    }

    protected abstract class zze<TListener> {
        private TListener mListener;
        private boolean xH;

        public zze(TListener TListener) {
            this.mListener = TListener;
            this.xH = false;
        }

        protected abstract void zzv(TListener var1);

        protected abstract void zzase();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzasf() {
            TListener TListener;
            zze zze2 = this;
            synchronized (zze2) {
                TListener = this.mListener;
                if (this.xH) {
                    String string2 = String.valueOf(this);
                    Log.w((String)"GmsClient", (String)new StringBuilder(47 + String.valueOf(string2).length()).append("Callback proxy ").append(string2).append(" being reused. This is not safe.").toString());
                }
            }
            if (TListener != null) {
                try {
                    this.zzv(TListener);
                }
                catch (RuntimeException runtimeException) {
                    this.zzase();
                    throw runtimeException;
                }
            } else {
                this.zzase();
            }
            zze2 = this;
            synchronized (zze2) {
                this.xH = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            this.zzasg();
            ArrayList arrayList = zzd.this.xw;
            synchronized (arrayList) {
                zzd.this.xw.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzasg() {
            zze zze2 = this;
            synchronized (zze2) {
                this.mListener = null;
            }
        }
    }

    final class zzd
    extends Handler {
        public zzd(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            if (zzd.this.xD.get() != message.arg1) {
                if (this.zzb(message)) {
                    this.zza(message);
                }
                return;
            }
            if (!(message.what != 1 && message.what != 5 || zzd.this.isConnecting())) {
                this.zza(message);
                return;
            }
            if (message.what == 3) {
                PendingIntent pendingIntent = message.obj instanceof PendingIntent ? (PendingIntent)message.obj : null;
                ConnectionResult connectionResult = new ConnectionResult(message.arg2, pendingIntent);
                zzd.this.xu.zzh(connectionResult);
                zzd.this.onConnectionFailed(connectionResult);
                return;
            }
            if (message.what == 4) {
                zzd.this.zzb(4, null);
                if (zzd.this.xz != null) {
                    zzd.this.xz.onConnectionSuspended(message.arg2);
                }
                zzd.this.onConnectionSuspended(message.arg2);
                zzd.this.zza(4, 1, null);
                return;
            }
            if (message.what == 2 && !zzd.this.isConnected()) {
                this.zza(message);
                return;
            }
            if (this.zzb(message)) {
                zze zze2 = (zze)message.obj;
                zze2.zzasf();
                return;
            }
            int n = message.what;
            Log.wtf((String)"GmsClient", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        }

        private void zza(Message message) {
            zze zze2 = (zze)message.obj;
            zze2.zzase();
            zze2.unregister();
        }

        private boolean zzb(Message message) {
            return message.what == 2 || message.what == 1 || message.what == 5;
        }
    }

    public static interface zzf {
        public void zzh(@NonNull ConnectionResult var1);
    }

    public static interface zzc {
        public void onConnectionFailed(@NonNull ConnectionResult var1);
    }

    public static interface zzb {
        public void onConnected(@Nullable Bundle var1);

        public void onConnectionSuspended(int var1);
    }

    public final class zzh
    implements ServiceConnection {
        private final int xJ;

        public zzh(int n) {
            this.xJ = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            zzab.zzb(iBinder, (Object)"Expecting a valid IBinder");
            Object object = zzd.this.xs;
            synchronized (object) {
                zzd.this.xt = zzu.zza.zzdt(iBinder);
            }
            zzd.this.zza(0, null, this.xJ);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(ComponentName componentName) {
            Object object = zzd.this.xs;
            synchronized (object) {
                zzd.this.xt = null;
            }
            zzd.this.mHandler.sendMessage(zzd.this.mHandler.obtainMessage(4, this.xJ, 1));
        }
    }
}

