/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzamt;
import com.google.android.gms.internal.zzamu;
import com.google.android.gms.internal.zzamv;
import com.google.android.gms.internal.zzamz;
import com.google.android.gms.internal.zzanb;
import com.google.android.gms.internal.zzanc;
import com.google.android.gms.internal.zzand;
import com.google.android.gms.internal.zzane;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class zzamk
implements zzamu<Date>,
zzand<Date> {
    private final DateFormat bdE;
    private final DateFormat bdF;
    private final DateFormat bdG;

    zzamk() {
        this(DateFormat.getDateTimeInstance(2, 2, Locale.US), DateFormat.getDateTimeInstance(2, 2));
    }

    zzamk(String string2) {
        this(new SimpleDateFormat(string2, Locale.US), new SimpleDateFormat(string2));
    }

    public zzamk(int n, int n2) {
        this(DateFormat.getDateTimeInstance(n, n2, Locale.US), DateFormat.getDateTimeInstance(n, n2));
    }

    zzamk(DateFormat dateFormat, DateFormat dateFormat2) {
        this.bdE = dateFormat;
        this.bdF = dateFormat2;
        this.bdG = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        this.bdG.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public zzamv zza(Date date, Type type, zzanc zzanc2) {
        DateFormat dateFormat = this.bdF;
        synchronized (dateFormat) {
            String string2 = this.bdE.format(date);
            return new zzanb(string2);
        }
    }

    public Date zza(zzamv zzamv2, Type type, zzamt zzamt2) throws zzamz {
        if (!(zzamv2 instanceof zzanb)) {
            throw new zzamz("The date should be a string value");
        }
        Date date = this.zza(zzamv2);
        if (type == Date.class) {
            return date;
        }
        if (type == Timestamp.class) {
            return new Timestamp(date.getTime());
        }
        if (type == java.sql.Date.class) {
            return new java.sql.Date(date.getTime());
        }
        String string2 = String.valueOf(this.getClass());
        String string3 = String.valueOf(type);
        throw new IllegalArgumentException(new StringBuilder(23 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(" cannot deserialize to ").append(string3).toString());
    }

    private Date zza(zzamv zzamv2) {
        DateFormat dateFormat = this.bdF;
        synchronized (dateFormat) {
            try {
                return this.bdF.parse(zzamv2.zzczf());
            }
            catch (ParseException parseException) {
                try {
                    return this.bdE.parse(zzamv2.zzczf());
                }
                catch (ParseException parseException2) {
                    try {
                        return this.bdG.parse(zzamv2.zzczf());
                    }
                    catch (ParseException parseException3) {
                        throw new zzane(zzamv2.zzczf(), parseException3);
                    }
                }
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(zzamk.class.getSimpleName());
        stringBuilder.append('(').append(this.bdF.getClass().getSimpleName()).append(')');
        return stringBuilder.toString();
    }

    @Override
    public /* synthetic */ Object zzb(zzamv zzamv2, Type type, zzamt zzamt2) throws zzamz {
        return this.zza(zzamv2, type, zzamt2);
    }
}

