/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.internal.zzqj;
import com.google.android.gms.internal.zzqk;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;

@TargetApi(value=11)
public final class zzql
extends Fragment
implements zzqk {
    private static WeakHashMap<Activity, WeakReference<zzql>> vn = new WeakHashMap();
    private Map<String, zzqj> vo = new ArrayMap();
    private int zzblv = 0;
    private Bundle vp;

    public static zzql zzt(Activity activity) {
        zzql zzql2;
        WeakReference<zzql> weakReference = vn.get(activity);
        if (weakReference != null && (zzql2 = (zzql)weakReference.get()) != null) {
            return zzql2;
        }
        try {
            zzql2 = (zzql)activity.getFragmentManager().findFragmentByTag("LifecycleFragmentImpl");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Fragment with tag LifecycleFragmentImpl is not a LifecycleFragmentImpl", classCastException);
        }
        if (zzql2 == null || zzql2.isRemoving()) {
            zzql2 = new zzql();
            activity.getFragmentManager().beginTransaction().add((Fragment)zzql2, "LifecycleFragmentImpl").commitAllowingStateLoss();
        }
        vn.put(activity, new WeakReference<zzql>(zzql2));
        return zzql2;
    }

    @Override
    public <T extends zzqj> T zza(String string2, Class<T> clazz) {
        return (T)((zzqj)clazz.cast(this.vo.get(string2)));
    }

    @Override
    public void zza(String string2, @NonNull zzqj zzqj2) {
        if (this.vo.containsKey(string2)) {
            throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string2).length()).append("LifecycleCallback with tag ").append(string2).append(" already added to this fragment.").toString());
        }
        this.vo.put(string2, zzqj2);
        this.zzb(string2, zzqj2);
    }

    private void zzb(final String string2, final @NonNull zzqj zzqj2) {
        if (this.zzblv > 0) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    if (zzql.this.zzblv >= 1) {
                        zzqj2.onCreate(zzql.this.vp != null ? zzql.this.vp.getBundle(string2) : null);
                    }
                    if (zzql.this.zzblv >= 2) {
                        zzqj2.onStart();
                    }
                    if (zzql.this.zzblv >= 3) {
                        zzqj2.onStop();
                    }
                }
            });
        }
    }

    @Override
    public Activity zzaqt() {
        return this.getActivity();
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.zzblv = 1;
        this.vp = bundle;
        for (Map.Entry<String, zzqj> entry : this.vo.entrySet()) {
            entry.getValue().onCreate(bundle != null ? bundle.getBundle(entry.getKey()) : null);
        }
    }

    public void onStart() {
        super.onStop();
        this.zzblv = 2;
        for (zzqj zzqj2 : this.vo.values()) {
            zzqj2.onStart();
        }
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        for (zzqj zzqj2 : this.vo.values()) {
            zzqj2.onActivityResult(n, n2, intent);
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        if (bundle == null) {
            return;
        }
        for (Map.Entry<String, zzqj> entry : this.vo.entrySet()) {
            Bundle bundle2 = new Bundle();
            entry.getValue().onSaveInstanceState(bundle2);
            bundle.putBundle(entry.getKey(), bundle2);
        }
    }

    public void onStop() {
        super.onStop();
        this.zzblv = 3;
        for (zzqj zzqj2 : this.vo.values()) {
            zzqj2.onStop();
        }
    }

    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        super.dump(string2, fileDescriptor, printWriter, stringArray);
        for (zzqj zzqj2 : this.vo.values()) {
            zzqj2.dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }
}

