/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.phenotype;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.phenotype.zzb;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;

public class Flag
extends AbstractSafeParcelable
implements Comparable<Flag> {
    public static final Parcelable.Creator<Flag> CREATOR = new zzb();
    final int mVersionCode;
    public final String name;
    final long arl;
    final boolean ZV;
    final double ZX;
    final String zD;
    final byte[] arm;
    public final int arn;
    public final int aro;
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final zza arp = new zza();

    Flag(int n, String string2, long l, boolean bl, double d, String string3, byte[] byArray, int n2, int n3) {
        this.mVersionCode = n;
        this.name = string2;
        this.arl = l;
        this.ZV = bl;
        this.ZX = d;
        this.zD = string3;
        this.arm = byArray;
        this.arn = n2;
        this.aro = n3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Flag(");
        stringBuilder.append(this.mVersionCode);
        stringBuilder.append(", ");
        stringBuilder.append(this.name);
        stringBuilder.append(", ");
        switch (this.arn) {
            case 1: {
                stringBuilder.append(this.arl);
                break;
            }
            case 2: {
                stringBuilder.append(this.ZV);
                break;
            }
            case 3: {
                stringBuilder.append(this.ZX);
                break;
            }
            case 4: {
                stringBuilder.append("'");
                stringBuilder.append(this.zD);
                stringBuilder.append("'");
                break;
            }
            case 5: {
                if (this.arm == null) {
                    stringBuilder.append("null");
                    break;
                }
                stringBuilder.append("'");
                stringBuilder.append(new String(this.arm, UTF_8));
                stringBuilder.append("'");
                break;
            }
            default: {
                int n = this.arn;
                throw new AssertionError((Object)new StringBuilder(31).append("Invalid enum value: ").append(n).toString());
            }
        }
        stringBuilder.append(", ");
        stringBuilder.append(this.arn);
        stringBuilder.append(", ");
        stringBuilder.append(this.aro);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Flag) {
            Flag flag = (Flag)object;
            if (this.mVersionCode != flag.mVersionCode || !zzaa.equal(this.name, flag.name) || this.arn != flag.arn || this.aro != flag.aro) {
                return false;
            }
            switch (this.arn) {
                case 1: {
                    return this.arl == flag.arl;
                }
                case 2: {
                    return this.ZV == flag.ZV;
                }
                case 3: {
                    return this.ZX == flag.ZX;
                }
                case 4: {
                    return zzaa.equal(this.zD, flag.zD);
                }
                case 5: {
                    return Arrays.equals(this.arm, flag.arm);
                }
            }
            int n = this.arn;
            throw new AssertionError((Object)new StringBuilder(31).append("Invalid enum value: ").append(n).toString());
        }
        return false;
    }

    public int zza(Flag flag) {
        int n = this.name.compareTo(flag.name);
        if (n != 0) {
            return n;
        }
        n = Flag.compare(this.arn, flag.arn);
        if (n != 0) {
            return n;
        }
        switch (this.arn) {
            case 1: {
                return Flag.compare(this.arl, flag.arl);
            }
            case 2: {
                return Flag.compare(this.ZV, flag.ZV);
            }
            case 3: {
                return Double.compare(this.ZX, flag.ZX);
            }
            case 4: {
                return Flag.compare(this.zD, flag.zD);
            }
            case 5: {
                if (this.arm == flag.arm) {
                    return 0;
                }
                if (this.arm == null) {
                    return -1;
                }
                if (flag.arm == null) {
                    return 1;
                }
                for (int i = 0; i < Math.min(this.arm.length, flag.arm.length); ++i) {
                    n = Flag.compare(this.arm[i], flag.arm[i]);
                    if (n == 0) continue;
                    return n;
                }
                return Flag.compare(this.arm.length, flag.arm.length);
            }
        }
        int n2 = this.arn;
        throw new AssertionError((Object)new StringBuilder(31).append("Invalid enum value: ").append(n2).toString());
    }

    private static int compare(String string2, String string3) {
        if (string2 == string3) {
            return 0;
        }
        if (string2 == null) {
            return -1;
        }
        if (string3 == null) {
            return 1;
        }
        return string2.compareTo(string3);
    }

    private static int compare(int n, int n2) {
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    private static int compare(long l, long l2) {
        return l < l2 ? -1 : (l == l2 ? 0 : 1);
    }

    private static int compare(boolean bl, boolean bl2) {
        return bl == bl2 ? 0 : (bl ? 1 : -1);
    }

    private static int compare(byte by, byte by2) {
        return by - by2;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.zza((Flag)object);
    }

    public static class zza
    implements Comparator<Flag> {
        public int zza(Flag flag, Flag flag2) {
            if (flag.aro == flag2.aro) {
                return flag.name.compareTo(flag2.name);
            }
            return flag.aro - flag2.aro;
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.zza((Flag)object, (Flag)object2);
        }
    }
}

