/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.BinderThread;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.GetServiceRequest;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzn;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.common.internal.zzv;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class zze<T extends IInterface> {
    private int Ba;
    private long Bb;
    private long Bc;
    private int Bd;
    private long Be;
    private final Context mContext;
    private final Looper zzajn;
    private final zzn Bf;
    private final com.google.android.gms.common.zzc xn;
    final Handler mHandler;
    private final Object zzakd = new Object();
    private final Object Bg = new Object();
    private zzv Bh;
    private zzf Bi;
    private T Bj;
    private final ArrayList<zze<?>> Bk = new ArrayList();
    private zzh Bl;
    private int Bm = 1;
    private final zzb Bn;
    private final zzc Bo;
    private final int Bp;
    private final String Bq;
    protected AtomicInteger Br = new AtomicInteger(0);
    public static final String[] Bs = new String[]{"service_esmobile", "service_googleme"};

    protected zze(Context context, Looper looper, int n, zzb zzb2, zzc zzc2, String string2) {
        this(context, looper, zzn.zzcf(context), com.google.android.gms.common.zzc.zzapd(), n, zzac.zzy(zzb2), zzac.zzy(zzc2), string2);
    }

    protected zze(Context context, Looper looper, zzn zzn2, com.google.android.gms.common.zzc zzc2, int n, zzb zzb2, zzc zzc3, String string2) {
        this.mContext = zzac.zzb(context, (Object)"Context must not be null");
        this.zzajn = zzac.zzb(looper, (Object)"Looper must not be null");
        this.Bf = zzac.zzb(zzn2, (Object)"Supervisor must not be null");
        this.xn = zzac.zzb(zzc2, (Object)"API availability must not be null");
        this.mHandler = new zzd(looper);
        this.Bp = n;
        this.Bn = zzb2;
        this.Bo = zzc3;
        this.Bq = string2;
    }

    @NonNull
    protected abstract String zzix();

    protected String zzatq() {
        return "com.google.android.gms";
    }

    @NonNull
    protected abstract String zziy();

    @Nullable
    protected final String zzatr() {
        return this.Bq == null ? this.mContext.getClass().getName() : this.Bq;
    }

    @Nullable
    protected abstract T zzh(IBinder var1);

    @CallSuper
    protected void zza(@NonNull T t) {
        this.Bc = System.currentTimeMillis();
    }

    @CallSuper
    protected void onConnectionSuspended(int n) {
        this.Ba = n;
        this.Bb = System.currentTimeMillis();
    }

    @CallSuper
    protected void onConnectionFailed(ConnectionResult connectionResult) {
        this.Bd = connectionResult.getErrorCode();
        this.Be = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(int n, T t) {
        zzac.zzbs(n == 3 == (t != null));
        Object object = this.zzakd;
        synchronized (object) {
            this.Bm = n;
            this.Bj = t;
            this.zzc(n, t);
            switch (n) {
                case 2: {
                    this.zzats();
                    break;
                }
                case 3: {
                    this.zza(t);
                    break;
                }
                case 1: {
                    this.zzatt();
                }
            }
        }
    }

    void zzc(int n, T t) {
    }

    private void zzats() {
        String string2;
        if (this.Bl != null) {
            String string3 = String.valueOf(this.zzix());
            string2 = String.valueOf(this.zzatq());
            Log.e((String)"GmsClient", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Calling connect() while still connected, missing disconnect() for ").append(string3).append(" on ").append(string2).toString());
            this.Bf.zzb(this.zzix(), this.zzatq(), this.Bl, this.zzatr());
            this.Br.incrementAndGet();
        }
        this.Bl = new zzh(this.Br.get());
        boolean bl = this.Bf.zza(this.zzix(), this.zzatq(), this.Bl, this.zzatr());
        if (!bl) {
            string2 = String.valueOf(this.zzix());
            String string4 = String.valueOf(this.zzatq());
            Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string4).length()).append("unable to connect to service: ").append(string2).append(" on ").append(string4).toString());
            this.zza(16, null, this.Br.get());
        }
    }

    private void zzatt() {
        if (this.Bl != null) {
            this.Bf.zzb(this.zzix(), this.zzatq(), this.Bl, this.zzatr());
            this.Bl = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(int n, int n2, T t) {
        Object object = this.zzakd;
        synchronized (object) {
            if (this.Bm != n) {
                return false;
            }
            this.zzb(n2, t);
            return true;
        }
    }

    public void zzatu() {
        int n = this.xn.isGooglePlayServicesAvailable(this.mContext);
        if (n != 0) {
            this.zzb(1, null);
            this.Bi = new zzi();
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.Br.get(), n));
            return;
        }
        this.zza(new zzi());
    }

    public void zza(@NonNull zzf zzf2) {
        this.Bi = zzac.zzb(zzf2, (Object)"Connection progress callbacks cannot be null.");
        this.zzb(2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.zzakd;
        synchronized (object) {
            return this.Bm == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnecting() {
        Object object = this.zzakd;
        synchronized (object) {
            return this.Bm == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.Br.incrementAndGet();
        Object object = this.Bk;
        synchronized (object) {
            int n = this.Bk.size();
            for (int i = 0; i < n; ++i) {
                this.Bk.get(i).zzaud();
            }
            this.Bk.clear();
        }
        object = this.Bg;
        synchronized (object) {
            this.Bh = null;
        }
        this.zzb(1, null);
    }

    public void zzgl(int n) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, this.Br.get(), n));
    }

    public void zza(zzf zzf2, ConnectionResult connectionResult) {
        this.Bi = zzac.zzb(zzf2, (Object)"Connection progress callbacks cannot be null.");
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.Br.get(), connectionResult.getErrorCode(), (Object)connectionResult.getResolution()));
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final Looper getLooper() {
        return this.zzajn;
    }

    public Account getAccount() {
        return null;
    }

    public final Account zzatv() {
        return this.getAccount() != null ? this.getAccount() : new Account("<<default account>>", "com.google");
    }

    protected Bundle zzagl() {
        return new Bundle();
    }

    @BinderThread
    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, n2, -1, (Object)new zzj(n, iBinder, bundle)));
    }

    protected void zza(int n, @Nullable Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(5, n2, -1, (Object)new zzk(n, bundle)));
    }

    protected final void zzatw() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    public Bundle zzaoe() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T zzatx() throws DeadObjectException {
        Object object = this.zzakd;
        synchronized (object) {
            if (this.Bm == 4) {
                throw new DeadObjectException();
            }
            this.zzatw();
            zzac.zza(this.Bj != null, (Object)"Client is connected but service is null");
            return this.Bj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void zza(zzr zzr2, Set<Scope> set) {
        try {
            Bundle bundle = this.zzagl();
            GetServiceRequest getServiceRequest = new GetServiceRequest(this.Bp).zzht(this.mContext.getPackageName()).zzo(bundle);
            if (set != null) {
                getServiceRequest.zzf(set);
            }
            if (this.zzahd()) {
                getServiceRequest.zzd(this.zzatv()).zzb(zzr2);
            } else if (this.zzaty()) {
                getServiceRequest.zzd(this.getAccount());
            }
            Object object = this.Bg;
            synchronized (object) {
                if (this.Bh != null) {
                    this.Bh.zza((zzu)new zzg(this, this.Br.get()), getServiceRequest);
                } else {
                    Log.w((String)"GmsClient", (String)"mServiceBroker is null, client disconnected");
                }
            }
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"service died");
            this.zzgl(1);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"Remote exception occurred", (Throwable)remoteException);
        }
    }

    public boolean zzahd() {
        return false;
    }

    public boolean zzaty() {
        return false;
    }

    public boolean zzapr() {
        return true;
    }

    public boolean zzahs() {
        return false;
    }

    public Intent zzaht() {
        throw new UnsupportedOperationException("Not a sign in API");
    }

    protected Set<Scope> zzatz() {
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3;
        long l;
        T t;
        int n;
        Object object = this.zzakd;
        synchronized (object) {
            n = this.Bm;
            t = this.Bj;
        }
        printWriter.append(string2).append("mConnectState=");
        switch (n) {
            case 2: {
                printWriter.print("CONNECTING");
                break;
            }
            case 3: {
                printWriter.print("CONNECTED");
                break;
            }
            case 4: {
                printWriter.print("DISCONNECTING");
                break;
            }
            case 1: {
                printWriter.print("DISCONNECTED");
                break;
            }
            default: {
                printWriter.print("UNKNOWN");
            }
        }
        printWriter.append(" mService=");
        if (t == null) {
            printWriter.println("null");
        } else {
            printWriter.append(this.zziy()).append("@").println(Integer.toHexString(System.identityHashCode(t.asBinder())));
        }
        object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
        if (this.Bc > 0L) {
            l = this.Bc;
            string3 = String.valueOf(((DateFormat)object).format(new Date(this.Bc)));
            printWriter.append(string2).append("lastConnectedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.Bb > 0L) {
            printWriter.append(string2).append("lastSuspendedCause=");
            switch (this.Ba) {
                case 1: {
                    printWriter.append("CAUSE_SERVICE_DISCONNECTED");
                    break;
                }
                case 2: {
                    printWriter.append("CAUSE_NETWORK_LOST");
                    break;
                }
                default: {
                    printWriter.append(String.valueOf(this.Ba));
                }
            }
            l = this.Bb;
            string3 = String.valueOf(((DateFormat)object).format(new Date(this.Bb)));
            printWriter.append(" lastSuspendedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.Be > 0L) {
            printWriter.append(string2).append("lastFailedStatus=").append(CommonStatusCodes.getStatusCodeString(this.Bd));
            l = this.Be;
            string3 = String.valueOf(((DateFormat)object).format(new Date(this.Be)));
            printWriter.append(" lastFailedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IBinder zzaps() {
        Object object = this.Bg;
        synchronized (object) {
            if (this.Bh == null) {
                return null;
            }
            return this.Bh.asBinder();
        }
    }

    public static final class zzg
    extends zzu.zza {
        private zze Bw;
        private final int Bx;

        public zzg(@NonNull zze zze2, int n) {
            this.Bw = zze2;
            this.Bx = n;
        }

        @Override
        @BinderThread
        public void zzb(int n, @Nullable Bundle bundle) {
            Log.wtf((String)"GmsClient", (String)"received deprecated onAccountValidationComplete callback, ignoring", (Throwable)new Exception());
        }

        @Override
        @BinderThread
        public void zza(int n, @NonNull IBinder iBinder, @Nullable Bundle bundle) {
            zzac.zzb(this.Bw, (Object)"onPostInitComplete can be called only once per call to getRemoteService");
            this.Bw.zza(n, iBinder, bundle, this.Bx);
            this.zzaue();
        }

        private void zzaue() {
            this.Bw = null;
        }
    }

    private abstract class zza
    extends zze<Boolean> {
        public final int statusCode;
        public final Bundle Bt;

        @BinderThread
        protected zza(int n, Bundle bundle) {
            super(true);
            this.statusCode = n;
            this.Bt = bundle;
        }

        protected abstract boolean zzaua();

        protected abstract void zzm(ConnectionResult var1);

        protected void zzc(Boolean bl) {
            if (bl == null) {
                zze.this.zzb(1, null);
                return;
            }
            switch (this.statusCode) {
                case 0: {
                    if (this.zzaua()) break;
                    zze.this.zzb(1, null);
                    this.zzm(new ConnectionResult(8, null));
                    break;
                }
                case 10: {
                    zze.this.zzb(1, null);
                    throw new IllegalStateException("A fatal developer error has occurred. Check the logs for further information.");
                }
                default: {
                    zze.this.zzb(1, null);
                    PendingIntent pendingIntent = null;
                    if (this.Bt != null) {
                        pendingIntent = (PendingIntent)this.Bt.getParcelable("pendingIntent");
                    }
                    this.zzm(new ConnectionResult(this.statusCode, pendingIntent));
                }
            }
        }

        @Override
        protected void zzaub() {
        }

        @Override
        protected /* synthetic */ void zzv(Object object) {
            this.zzc((Boolean)object);
        }
    }

    protected final class zzj
    extends zza {
        public final IBinder By;

        @BinderThread
        public zzj(int n, IBinder iBinder, Bundle bundle) {
            super(n, bundle);
            this.By = iBinder;
        }

        @Override
        protected void zzm(ConnectionResult connectionResult) {
            if (zze.this.Bo != null) {
                zze.this.Bo.onConnectionFailed(connectionResult);
            }
            zze.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected boolean zzaua() {
            String string2;
            try {
                string2 = this.By.getInterfaceDescriptor();
            }
            catch (RemoteException remoteException) {
                Log.w((String)"GmsClient", (String)"service probably died");
                return false;
            }
            if (!zze.this.zziy().equals(string2)) {
                String string3 = String.valueOf(zze.this.zziy());
                Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("service descriptor mismatch: ").append(string3).append(" vs. ").append(string2).toString());
                return false;
            }
            Object t = zze.this.zzh(this.By);
            if (t != null && zze.this.zza(2, 3, t)) {
                Bundle bundle = zze.this.zzaoe();
                if (zze.this.Bn != null) {
                    zze.this.Bn.onConnected(bundle);
                }
                return true;
            }
            return false;
        }
    }

    protected final class zzk
    extends zza {
        @BinderThread
        public zzk(int n, @Nullable Bundle bundle) {
            super(n, bundle);
        }

        @Override
        protected void zzm(ConnectionResult connectionResult) {
            zze.this.Bi.zzh(connectionResult);
            zze.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected boolean zzaua() {
            zze.this.Bi.zzh(ConnectionResult.uJ);
            return true;
        }
    }

    protected class zzi
    implements zzf {
        @Override
        public void zzh(@NonNull ConnectionResult connectionResult) {
            if (connectionResult.isSuccess()) {
                zze.this.zza(null, zze.this.zzatz());
            } else if (zze.this.Bo != null) {
                zze.this.Bo.onConnectionFailed(connectionResult);
            }
        }
    }

    protected abstract class zze<TListener> {
        private TListener mListener;
        private boolean Bv;

        public zze(TListener TListener) {
            this.mListener = TListener;
            this.Bv = false;
        }

        protected abstract void zzv(TListener var1);

        protected abstract void zzaub();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzauc() {
            TListener TListener;
            zze zze2 = this;
            synchronized (zze2) {
                TListener = this.mListener;
                if (this.Bv) {
                    String string2 = String.valueOf(this);
                    Log.w((String)"GmsClient", (String)new StringBuilder(47 + String.valueOf(string2).length()).append("Callback proxy ").append(string2).append(" being reused. This is not safe.").toString());
                }
            }
            if (TListener != null) {
                try {
                    this.zzv(TListener);
                }
                catch (RuntimeException runtimeException) {
                    this.zzaub();
                    throw runtimeException;
                }
            } else {
                this.zzaub();
            }
            zze2 = this;
            synchronized (zze2) {
                this.Bv = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            this.zzaud();
            ArrayList arrayList = zze.this.Bk;
            synchronized (arrayList) {
                zze.this.Bk.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzaud() {
            zze zze2 = this;
            synchronized (zze2) {
                this.mListener = null;
            }
        }
    }

    final class zzd
    extends Handler {
        public zzd(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            if (zze.this.Br.get() != message.arg1) {
                if (this.zzb(message)) {
                    this.zza(message);
                }
                return;
            }
            if (!(message.what != 1 && message.what != 5 || zze.this.isConnecting())) {
                this.zza(message);
                return;
            }
            if (message.what == 3) {
                PendingIntent pendingIntent = message.obj instanceof PendingIntent ? (PendingIntent)message.obj : null;
                ConnectionResult connectionResult = new ConnectionResult(message.arg2, pendingIntent);
                zze.this.Bi.zzh(connectionResult);
                zze.this.onConnectionFailed(connectionResult);
                return;
            }
            if (message.what == 4) {
                zze.this.zzb(4, null);
                if (zze.this.Bn != null) {
                    zze.this.Bn.onConnectionSuspended(message.arg2);
                }
                zze.this.onConnectionSuspended(message.arg2);
                zze.this.zza(4, 1, null);
                return;
            }
            if (message.what == 2 && !zze.this.isConnected()) {
                this.zza(message);
                return;
            }
            if (this.zzb(message)) {
                zze zze2 = (zze)message.obj;
                zze2.zzauc();
                return;
            }
            int n = message.what;
            Log.wtf((String)"GmsClient", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        }

        private void zza(Message message) {
            zze zze2 = (zze)message.obj;
            zze2.zzaub();
            zze2.unregister();
        }

        private boolean zzb(Message message) {
            return message.what == 2 || message.what == 1 || message.what == 5;
        }
    }

    public static interface zzf {
        public void zzh(@NonNull ConnectionResult var1);
    }

    public static interface zzc {
        public void onConnectionFailed(@NonNull ConnectionResult var1);
    }

    public static interface zzb {
        public void onConnected(@Nullable Bundle var1);

        public void onConnectionSuspended(int var1);
    }

    public final class zzh
    implements ServiceConnection {
        private final int Bx;

        public zzh(int n) {
            this.Bx = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            zzac.zzb(iBinder, (Object)"Expecting a valid IBinder");
            Object object = zze.this.Bg;
            synchronized (object) {
                zze.this.Bh = zzv.zza.zzdv(iBinder);
            }
            zze.this.zza(0, null, this.Bx);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(ComponentName componentName) {
            Object object = zze.this.Bg;
            synchronized (object) {
                zze.this.Bh = null;
            }
            zze.this.mHandler.sendMessage(zze.this.mHandler.obtainMessage(4, this.Bx, 1));
        }
    }
}

