/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.phenotype;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.phenotype.Flag;
import com.google.android.gms.phenotype.zza;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;

public class Configuration
extends AbstractSafeParcelable
implements Comparable<Configuration> {
    public static final Parcelable.Creator<Configuration> CREATOR = new zza();
    final int mVersionCode;
    public final int axl;
    public final Flag[] axm;
    public final String[] axn;
    public final Map<String, Flag> axo;

    Configuration(int n, int n2, Flag[] flagArray, String[] stringArray) {
        this.mVersionCode = n;
        this.axl = n2;
        this.axm = flagArray;
        this.axo = new TreeMap<String, Flag>();
        for (Flag flag : flagArray) {
            this.axo.put(flag.name, flag);
        }
        this.axn = stringArray;
        if (this.axn != null) {
            Arrays.sort(this.axn);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Configuration(");
        stringBuilder.append(this.mVersionCode);
        stringBuilder.append(", ");
        stringBuilder.append(this.axl);
        stringBuilder.append(", ");
        stringBuilder.append("(");
        for (Flag flag : this.axo.values()) {
            stringBuilder.append(flag);
            stringBuilder.append(", ");
        }
        stringBuilder.append(")");
        stringBuilder.append(", ");
        stringBuilder.append("(");
        if (this.axn != null) {
            for (String string : this.axn) {
                stringBuilder.append(string);
                stringBuilder.append(", ");
            }
        } else {
            stringBuilder.append("null");
        }
        stringBuilder.append(")");
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Configuration) {
            Configuration configuration = (Configuration)object;
            return this.mVersionCode == configuration.mVersionCode && this.axl == configuration.axl && zzab.equal(this.axo, configuration.axo) && Arrays.equals(this.axn, configuration.axn);
        }
        return false;
    }

    public int zza(Configuration configuration) {
        return this.axl - configuration.axl;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zza.zza(this, parcel, n);
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.zza((Configuration)object);
    }
}

