/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.server.response;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.server.converter.ConverterWrapper;
import com.google.android.gms.common.server.response.FieldMappingDictionary;
import com.google.android.gms.common.server.response.SafeParcelResponse;
import com.google.android.gms.common.util.zzc;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.common.util.zzq;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class FastJsonResponse {
    public abstract Map<String, Field<?, ?>> zzavs();

    protected abstract Object zzia(String var1);

    protected boolean zza(Field field) {
        if (field.zzavr() == 11) {
            if (field.zzavw()) {
                return this.zzid(field.zzavx());
            }
            return this.zzic(field.zzavx());
        }
        return this.zzib(field.zzavx());
    }

    protected abstract boolean zzib(String var1);

    protected boolean zzic(String string2) {
        throw new UnsupportedOperationException("Concrete types not supported");
    }

    protected boolean zzid(String string2) {
        throw new UnsupportedOperationException("Concrete type arrays not supported");
    }

    protected <O, I> I zza(Field<I, O> field, Object object) {
        if (((Field)field).DC != null) {
            return field.convertBack(object);
        }
        return (I)object;
    }

    public HashMap<String, Object> zzavt() {
        return null;
    }

    public HashMap<String, Object> zzavu() {
        return null;
    }

    public String toString() {
        Map<String, Field<?, ?>> map = this.zzavs();
        StringBuilder stringBuilder = new StringBuilder(100);
        block5: for (String string2 : map.keySet()) {
            Field<?, ?> field = map.get(string2);
            if (!this.zza(field)) continue;
            Object object = this.zzb(field);
            Object obj = this.zza(field, object);
            if (stringBuilder.length() == 0) {
                stringBuilder.append("{");
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append("\"").append(string2).append("\":");
            if (obj == null) {
                stringBuilder.append("null");
                continue;
            }
            switch (field.zzavr()) {
                case 8: {
                    stringBuilder.append("\"").append(zzc.zzp((byte[])obj)).append("\"");
                    continue block5;
                }
                case 9: {
                    stringBuilder.append("\"").append(zzc.zzq((byte[])obj)).append("\"");
                    continue block5;
                }
                case 10: {
                    HashMap hashMap = (HashMap)obj;
                    zzq.zza(stringBuilder, hashMap);
                    continue block5;
                }
            }
            if (field.zzavv()) {
                this.zza(stringBuilder, field, (ArrayList)obj);
                continue;
            }
            this.zza(stringBuilder, field, obj);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append("}");
        } else {
            stringBuilder.append("{}");
        }
        return stringBuilder.toString();
    }

    protected Object zzb(Field field) {
        String string2 = field.zzavx();
        if (field.zzavz() != null) {
            HashMap<String, Object> hashMap;
            zzac.zza(this.zzia(field.zzavx()) == null, "Concrete field shouldn't be value object: %s", field.zzavx());
            HashMap<String, Object> hashMap2 = hashMap = field.zzavw() ? this.zzavu() : this.zzavt();
            if (hashMap != null) {
                return hashMap.get(string2);
            }
            try {
                char c = Character.toUpperCase(string2.charAt(0));
                String string3 = String.valueOf(string2.substring(1));
                String string4 = new StringBuilder(4 + String.valueOf(string3).length()).append("get").append(c).append(string3).toString();
                return this.getClass().getMethod(string4, new Class[0]).invoke((Object)this, new Object[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return this.zzia(field.zzavx());
    }

    private void zza(StringBuilder stringBuilder, Field field, Object object) {
        if (field.zzavq() == 11) {
            Class<FastJsonResponse> clazz = field.zzavz();
            stringBuilder.append(clazz.cast(object).toString());
        } else if (field.zzavq() == 7) {
            stringBuilder.append("\"");
            stringBuilder.append(zzp.zzii((String)object));
            stringBuilder.append("\"");
        } else {
            stringBuilder.append(object);
        }
    }

    private void zza(StringBuilder stringBuilder, Field field, ArrayList<Object> arrayList) {
        stringBuilder.append("[");
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            if (i > 0) {
                stringBuilder.append(",");
            }
            if ((object = arrayList.get(i)) == null) continue;
            this.zza(stringBuilder, field, object);
        }
        stringBuilder.append("]");
    }

    public static interface zza<I, O> {
        public int zzavq();

        public int zzavr();

        public I convertBack(O var1);
    }

    public static class Field<I, O>
    extends AbstractSafeParcelable {
        private final int mVersionCode;
        protected final int Dt;
        protected final boolean Du;
        protected final int Dv;
        protected final boolean Dw;
        protected final String Dx;
        protected final int Dy;
        protected final Class<? extends FastJsonResponse> Dz;
        protected final String DA;
        private FieldMappingDictionary DB;
        private zza<I, O> DC;
        public static final com.google.android.gms.common.server.response.zza CREATOR = new com.google.android.gms.common.server.response.zza();

        Field(int n, int n2, boolean bl, int n3, boolean bl2, String string2, int n4, String string3, ConverterWrapper converterWrapper) {
            this.mVersionCode = n;
            this.Dt = n2;
            this.Du = bl;
            this.Dv = n3;
            this.Dw = bl2;
            this.Dx = string2;
            this.Dy = n4;
            if (string3 == null) {
                this.Dz = null;
                this.DA = null;
            } else {
                this.Dz = SafeParcelResponse.class;
                this.DA = string3;
            }
            this.DC = converterWrapper == null ? null : converterWrapper.zzavo();
        }

        protected Field(int n, boolean bl, int n2, boolean bl2, String string2, int n3, Class<? extends FastJsonResponse> clazz, zza<I, O> zza2) {
            this.mVersionCode = 1;
            this.Dt = n;
            this.Du = bl;
            this.Dv = n2;
            this.Dw = bl2;
            this.Dx = string2;
            this.Dy = n3;
            this.Dz = clazz;
            this.DA = clazz == null ? null : clazz.getCanonicalName();
            this.DC = zza2;
        }

        public int getVersionCode() {
            return this.mVersionCode;
        }

        public int zzavq() {
            return this.Dt;
        }

        public boolean zzavv() {
            return this.Du;
        }

        public int zzavr() {
            return this.Dv;
        }

        public boolean zzavw() {
            return this.Dw;
        }

        public String zzavx() {
            return this.Dx;
        }

        public int zzavy() {
            return this.Dy;
        }

        public Class<? extends FastJsonResponse> zzavz() {
            return this.Dz;
        }

        String zzawa() {
            if (this.DA == null) {
                return null;
            }
            return this.DA;
        }

        public boolean zzawb() {
            return this.DC != null;
        }

        public void zza(FieldMappingDictionary fieldMappingDictionary) {
            this.DB = fieldMappingDictionary;
        }

        ConverterWrapper zzawc() {
            if (this.DC == null) {
                return null;
            }
            return ConverterWrapper.zza(this.DC);
        }

        public Map<String, Field<?, ?>> zzawd() {
            zzac.zzy(this.DA);
            zzac.zzy(this.DB);
            return this.DB.zzie(this.DA);
        }

        public I convertBack(O o) {
            return this.DC.convertBack(o);
        }

        public static Field<Integer, Integer> zzk(String string2, int n) {
            return new Field<Integer, Integer>(0, false, 0, false, string2, n, null, null);
        }

        public static Field<Boolean, Boolean> zzl(String string2, int n) {
            return new Field<Boolean, Boolean>(6, false, 6, false, string2, n, null, null);
        }

        public static Field<String, String> zzm(String string2, int n) {
            return new Field<String, String>(7, false, 7, false, string2, n, null, null);
        }

        public static <T extends FastJsonResponse> Field<T, T> zza(String string2, int n, Class<T> clazz) {
            return new Field(11, false, 11, false, string2, n, clazz, null);
        }

        public static <T extends FastJsonResponse> Field<ArrayList<T>, ArrayList<T>> zzb(String string2, int n, Class<T> clazz) {
            return new Field<ArrayList<T>, ArrayList<T>>(11, true, 11, true, string2, n, clazz, null);
        }

        public static Field zza(String string2, int n, zza<?, ?> zza2, boolean bl) {
            return new Field(zza2.zzavq(), bl, zza2.zzavr(), false, string2, n, null, zza2);
        }

        public void writeToParcel(Parcel parcel, int n) {
            com.google.android.gms.common.server.response.zza.zza(this, parcel, n);
        }

        public String toString() {
            zzab.zza zza2 = zzab.zzx(this).zzg("versionCode", this.mVersionCode).zzg("typeIn", this.Dt).zzg("typeInArray", this.Du).zzg("typeOut", this.Dv).zzg("typeOutArray", this.Dw).zzg("outputFieldName", this.Dx).zzg("safeParcelFieldId", this.Dy).zzg("concreteTypeName", this.zzawa());
            Class<FastJsonResponse> clazz = this.zzavz();
            if (clazz != null) {
                zza2.zzg("concreteType.class", clazz.getCanonicalName());
            }
            if (this.DC != null) {
                zza2.zzg("converterName", this.DC.getClass().getCanonicalName());
            }
            return zza2.toString();
        }
    }
}

