/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.WorkSource;
import android.util.Log;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.common.util.zzv;
import com.google.android.gms.internal.zzsz;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class zzy {
    private static final Method GH = zzy.zzaza();
    private static final Method GI = zzy.zzazb();
    private static final Method GJ = zzy.zzazc();
    private static final Method GK = zzy.zzazd();
    private static final Method GL = zzy.zzaze();

    public static WorkSource zzf(int n, String string2) {
        WorkSource workSource = new WorkSource();
        zzy.zza(workSource, n, string2);
        return workSource;
    }

    public static WorkSource zzy(Context context, String string2) {
        if (context == null || context.getPackageManager() == null) {
            return null;
        }
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = zzsz.zzco(context).getApplicationInfo(string2, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string3 = String.valueOf(string2);
            Log.e((String)"WorkSourceUtil", (String)(string3.length() != 0 ? "Could not find package: ".concat(string3) : new String("Could not find package: ")));
            return null;
        }
        if (applicationInfo == null) {
            String string4 = String.valueOf(string2);
            Log.e((String)"WorkSourceUtil", (String)(string4.length() != 0 ? "Could not get applicationInfo from package: ".concat(string4) : new String("Could not get applicationInfo from package: ")));
            return null;
        }
        return zzy.zzf(applicationInfo.uid, string2);
    }

    public static void zza(WorkSource workSource, int n, String string2) {
        if (GI != null) {
            if (string2 == null) {
                string2 = "";
            }
            try {
                GI.invoke((Object)workSource, n, string2);
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
            return;
        }
        if (GH != null) {
            try {
                GH.invoke((Object)workSource, n);
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
        }
    }

    public static int zza(WorkSource workSource) {
        if (GJ != null) {
            try {
                return (Integer)GJ.invoke((Object)workSource, new Object[0]);
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
        }
        return 0;
    }

    public static String zza(WorkSource workSource, int n) {
        if (GL != null) {
            try {
                return (String)GL.invoke((Object)workSource, n);
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
        }
        return null;
    }

    public static List<String> zzb(WorkSource workSource) {
        int n;
        int n2 = n = workSource == null ? 0 : zzy.zza(workSource);
        if (n == 0) {
            return Collections.EMPTY_LIST;
        }
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            string2 = zzy.zza(workSource, i);
            if (zzv.zzij(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static boolean zzcm(Context context) {
        if (context == null) {
            return false;
        }
        PackageManager packageManager = context.getPackageManager();
        if (packageManager == null) {
            return false;
        }
        int n = zzsz.zzco(context).checkPermission("android.permission.UPDATE_DEVICE_STATS", context.getPackageName());
        return n == 0;
    }

    private static Method zzaza() {
        Method method = null;
        try {
            method = WorkSource.class.getMethod("add", Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    private static Method zzazb() {
        Method method = null;
        if (zzs.zzayt()) {
            try {
                method = WorkSource.class.getMethod("add", Integer.TYPE, String.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return method;
    }

    private static Method zzazc() {
        Method method = null;
        try {
            method = WorkSource.class.getMethod("size", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    private static Method zzazd() {
        Method method = null;
        try {
            method = WorkSource.class.getMethod("get", Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    private static Method zzaze() {
        Method method = null;
        if (zzs.zzayt()) {
            try {
                method = WorkSource.class.getMethod("getName", Integer.TYPE);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return method;
    }
}

