/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.zzf;
import com.google.android.gms.cast.framework.zzh;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzwq;
import com.google.android.gms.internal.zzws;
import com.google.android.gms.internal.zzxe;
import com.google.android.gms.internal.zzyu;
import com.google.android.gms.internal.zzyv;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class CastSession
extends Session {
    private static final zzyu zzaoQ = new zzyu("CastSession");
    private final Context zzOZ;
    private final Set<Cast.Listener> zzapf = new HashSet<Cast.Listener>();
    private final zzh zzapg;
    private final CastOptions zzaoW;
    private final Cast.CastApi zzaph;
    private final zzws zzapi;
    private final zzxe zzapj;
    private GoogleApiClient zzamy;
    private RemoteMediaClient zzapk;
    private CastDevice zzapl;
    private Cast.ApplicationConnectionResult zzapm;

    public CastSession(Context context, String string2, String string3, CastOptions castOptions, Cast.CastApi castApi, zzws zzws2, zzxe zzxe2) {
        super(context, string2, string3);
        this.zzOZ = context.getApplicationContext();
        this.zzaoW = castOptions;
        this.zzaph = castApi;
        this.zzapi = zzws2;
        this.zzapj = zzxe2;
        this.zzapg = zzwq.zza(context, castOptions, this.zzsp(), new zzb());
    }

    @Override
    protected void start(Bundle bundle) {
        this.zzl(bundle);
    }

    @Override
    protected void resume(Bundle bundle) {
        this.zzl(bundle);
    }

    @Override
    protected void end(boolean bl) {
        try {
            this.zzapg.zzb(bl, 0);
        }
        catch (RemoteException remoteException) {
            zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"disconnectFromDevice", zzh.class.getSimpleName()});
        }
        this.notifySessionEnded(0);
    }

    public RemoteMediaClient getRemoteMediaClient() {
        zzac.zzdn((String)"Must be called from the main thread.");
        return this.zzapk;
    }

    public CastDevice getCastDevice() {
        zzac.zzdn((String)"Must be called from the main thread.");
        return this.zzapl;
    }

    public void requestStatus() throws IOException, IllegalStateException {
        zzac.zzdn((String)"Must be called from the main thread.");
        if (this.zzamy != null) {
            this.zzaph.requestStatus(this.zzamy);
        }
    }

    public int getActiveInputState() throws IllegalStateException {
        zzac.zzdn((String)"Must be called from the main thread.");
        return this.zzamy != null ? this.zzaph.getActiveInputState(this.zzamy) : -1;
    }

    public int getStandbyState() throws IllegalStateException {
        zzac.zzdn((String)"Must be called from the main thread.");
        return this.zzamy != null ? this.zzaph.getStandbyState(this.zzamy) : -1;
    }

    public ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        zzac.zzdn((String)"Must be called from the main thread.");
        return this.zzamy != null ? this.zzaph.getApplicationMetadata(this.zzamy) : null;
    }

    public String getApplicationStatus() throws IllegalStateException {
        zzac.zzdn((String)"Must be called from the main thread.");
        return this.zzamy != null ? this.zzaph.getApplicationStatus(this.zzamy) : null;
    }

    public void setVolume(double d) throws IOException {
        zzac.zzdn((String)"Must be called from the main thread.");
        if (this.zzamy != null) {
            this.zzaph.setVolume(this.zzamy, d);
        }
    }

    public double getVolume() throws IllegalStateException {
        zzac.zzdn((String)"Must be called from the main thread.");
        return this.zzamy != null ? this.zzaph.getVolume(this.zzamy) : 0.0;
    }

    public void setMute(boolean bl) throws IOException, IllegalStateException {
        zzac.zzdn((String)"Must be called from the main thread.");
        if (this.zzamy != null) {
            this.zzaph.setMute(this.zzamy, bl);
        }
    }

    public boolean isMute() throws IllegalStateException {
        zzac.zzdn((String)"Must be called from the main thread.");
        return this.zzamy != null ? this.zzaph.isMute(this.zzamy) : false;
    }

    public Cast.ApplicationConnectionResult getApplicationConnectionResult() {
        zzac.zzdn((String)"Must be called from the main thread.");
        return this.zzapm;
    }

    public void setMessageReceivedCallbacks(String string2, Cast.MessageReceivedCallback messageReceivedCallback) throws IOException, IllegalStateException {
        zzac.zzdn((String)"Must be called from the main thread.");
        if (this.zzamy != null) {
            this.zzaph.setMessageReceivedCallbacks(this.zzamy, string2, messageReceivedCallback);
        }
    }

    public void removeMessageReceivedCallbacks(String string2) throws IOException, IllegalArgumentException {
        zzac.zzdn((String)"Must be called from the main thread.");
        if (this.zzamy != null) {
            this.zzaph.removeMessageReceivedCallbacks(this.zzamy, string2);
        }
    }

    public PendingResult<Status> sendMessage(String string2, String string3) {
        zzac.zzdn((String)"Must be called from the main thread.");
        return this.zzamy != null ? this.zzaph.sendMessage(this.zzamy, string2, string3) : null;
    }

    public void addCastListener(Cast.Listener listener) {
        zzac.zzdn((String)"Must be called from the main thread.");
        if (listener != null) {
            this.zzapf.add(listener);
        }
    }

    public void removeCastListener(Cast.Listener listener) {
        zzac.zzdn((String)"Must be called from the main thread.");
        if (listener != null) {
            this.zzapf.remove(listener);
        }
    }

    private void zzl(Bundle bundle) {
        this.zzapl = CastDevice.getFromBundle((Bundle)bundle);
        if (this.zzapl == null) {
            if (this.isResuming()) {
                this.notifyFailedToResumeSession(8);
            } else {
                this.notifyFailedToStartSession(8);
            }
            return;
        }
        if (this.zzamy != null) {
            this.zzamy.disconnect();
            this.zzamy = null;
        }
        zzaoQ.zzb("Acquiring a connection to Google Play Services for %s", new Object[]{this.zzapl});
        zzd zzd2 = new zzd();
        this.zzamy = this.zzapi.zza(this.zzOZ, this.zzapl, this.zzaoW, new zzc(), zzd2, zzd2);
        this.zzamy.connect();
    }

    private void zzbV(int n) {
        this.zzapj.zzcb(n);
        if (this.zzamy != null) {
            this.zzamy.disconnect();
            this.zzamy = null;
        }
        this.zzapl = null;
        if (this.zzapk != null) {
            try {
                this.zzapk.zzd(null);
            }
            catch (IOException iOException) {
                zzaoQ.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
            }
            this.zzapk = null;
        }
        this.zzapm = null;
    }

    @Override
    public long getSessionRemainingTimeMs() {
        zzac.zzdn((String)"Must be called from the main thread.");
        if (this.zzapk == null) {
            return 0L;
        }
        return this.zzapk.getStreamDuration() - this.zzapk.getApproximateStreamPosition();
    }

    private class zzb
    extends zzf.zza {
        private zzb() {
        }

        @Override
        public int zzsd() {
            return 10084208;
        }

        @Override
        public void zzy(String string, String string2) {
            CastSession.this.zzaph.joinApplication(CastSession.this.zzamy, string, string2).setResultCallback((ResultCallback)new zza("joinApplication"));
        }

        @Override
        public void zza(String string, LaunchOptions launchOptions) {
            CastSession.this.zzaph.launchApplication(CastSession.this.zzamy, string, launchOptions).setResultCallback((ResultCallback)new zza("launchApplication"));
        }

        @Override
        public void zzcJ(String string) {
            CastSession.this.zzaph.stopApplication(CastSession.this.zzamy, string);
        }

        @Override
        public void zzbV(int n) {
            CastSession.this.zzbV(n);
        }
    }

    private class zza
    implements ResultCallback<Cast.ApplicationConnectionResult> {
        String zzapn;

        zza(String string) {
            this.zzapn = string;
        }

        public void zza(@NonNull Cast.ApplicationConnectionResult applicationConnectionResult) {
            block5: {
                CastSession.this.zzapm = applicationConnectionResult;
                try {
                    if (applicationConnectionResult.getStatus().isSuccess()) {
                        zzaoQ.zzb("%s() -> success result", new Object[]{this.zzapn});
                        CastSession.this.zzapk = new RemoteMediaClient(new zzyv(null), CastSession.this.zzaph);
                        try {
                            CastSession.this.zzapk.zzd(CastSession.this.zzamy);
                            CastSession.this.zzapk.requestStatus();
                            CastSession.this.zzapj.zza(CastSession.this.zzapk, CastSession.this.getCastDevice());
                        }
                        catch (IOException iOException) {
                            zzaoQ.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
                            CastSession.this.zzapk = null;
                        }
                        CastSession.this.zzapg.zza(applicationConnectionResult.getApplicationMetadata(), applicationConnectionResult.getApplicationStatus(), applicationConnectionResult.getSessionId(), applicationConnectionResult.getWasLaunched());
                        break block5;
                    }
                    zzaoQ.zzb("%s() -> failure result", new Object[]{this.zzapn});
                    CastSession.this.zzapg.zzbW(applicationConnectionResult.getStatus().getStatusCode());
                }
                catch (RemoteException remoteException) {
                    zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"methods", zzh.class.getSimpleName()});
                }
            }
        }

        public /* synthetic */ void onResult(@NonNull Result result) {
            this.zza((Cast.ApplicationConnectionResult)result);
        }
    }

    private class zzc
    extends Cast.Listener {
        private zzc() {
        }

        public void onApplicationDisconnected(int n) {
            CastSession.this.zzbV(n);
            CastSession.this.notifySessionEnded(n);
            HashSet hashSet = new HashSet(CastSession.this.zzapf);
            for (Cast.Listener listener : hashSet) {
                listener.onApplicationDisconnected(n);
            }
        }

        public void onApplicationStatusChanged() {
            HashSet hashSet = new HashSet(CastSession.this.zzapf);
            for (Cast.Listener listener : hashSet) {
                listener.onApplicationStatusChanged();
            }
        }

        public void onApplicationMetadataChanged(ApplicationMetadata applicationMetadata) {
            HashSet hashSet = new HashSet(CastSession.this.zzapf);
            for (Cast.Listener listener : hashSet) {
                listener.onApplicationMetadataChanged(applicationMetadata);
            }
        }

        public void onActiveInputStateChanged(int n) {
            HashSet hashSet = new HashSet(CastSession.this.zzapf);
            for (Cast.Listener listener : hashSet) {
                listener.onActiveInputStateChanged(n);
            }
        }

        public void onStandbyStateChanged(int n) {
            HashSet hashSet = new HashSet(CastSession.this.zzapf);
            for (Cast.Listener listener : hashSet) {
                listener.onStandbyStateChanged(n);
            }
        }

        public void onVolumeChanged() {
            HashSet hashSet = new HashSet(CastSession.this.zzapf);
            for (Cast.Listener listener : hashSet) {
                listener.onVolumeChanged();
            }
        }
    }

    private class zzd
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private zzd() {
        }

        public void onConnected(Bundle bundle) {
            try {
                CastSession.this.zzapg.onConnected(bundle);
            }
            catch (RemoteException remoteException) {
                zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnected", zzh.class.getSimpleName()});
            }
        }

        public void onConnectionSuspended(int n) {
            try {
                CastSession.this.zzapg.onConnectionSuspended(n);
            }
            catch (RemoteException remoteException) {
                zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnectionSuspended", zzh.class.getSimpleName()});
            }
        }

        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            try {
                CastSession.this.zzapg.onConnectionFailed(connectionResult);
            }
            catch (RemoteException remoteException) {
                zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnectionFailed", zzh.class.getSimpleName()});
            }
        }
    }
}

