/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.widget;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Bundle;
import android.support.annotation.DrawableRes;
import android.support.v4.app.Fragment;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.uicontroller.UIMediaController;
import com.google.android.gms.cast.framework.media.widget.ControlButtonsContainer;
import com.google.android.gms.cast.framework.media.widget.zza;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzyu;

public class MiniControllerFragment
extends Fragment
implements ControlButtonsContainer {
    private static final zzyu zzaoQ = new zzyu("MiniControllerFragment");
    private boolean zzatM;
    private int zzatN;
    private int zzatO;
    private int zzatP;
    private int zzatQ;
    private int zzaty;
    private int[] zzatD;
    private ImageView[] zzatE = new ImageView[3];
    private int zzatR;
    @DrawableRes
    private int zzatp;
    @DrawableRes
    private int zzatq;
    @DrawableRes
    private int zzatr;
    @DrawableRes
    private int zzatS;
    @DrawableRes
    private int zzatT;
    @DrawableRes
    private int zzatU;
    @DrawableRes
    private int zzats;
    @DrawableRes
    private int zzatt;
    @DrawableRes
    private int zzatu;
    @DrawableRes
    private int zzatv;
    @DrawableRes
    private int zzatw;
    @DrawableRes
    private int zzatx;
    private UIMediaController zzatK;

    public void onInflate(Context context, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(context, attributeSet, bundle);
        this.zza(context, attributeSet);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        this.zzatK = new UIMediaController((Activity)this.getActivity());
        View view = layoutInflater.inflate(R.layout.cast_mini_controller, viewGroup);
        view.setVisibility(8);
        this.zzatK.bindViewVisibilityToMediaSession(view, 8);
        RelativeLayout relativeLayout = (RelativeLayout)view.findViewById(R.id.container_current);
        if (this.zzatP != 0) {
            relativeLayout.setBackgroundResource(this.zzatP);
        }
        ImageView imageView = (ImageView)view.findViewById(R.id.icon_view);
        TextView textView = (TextView)view.findViewById(R.id.title_view);
        if (this.zzatN != 0) {
            textView.setTextAppearance((Context)this.getActivity(), this.zzatN);
        }
        TextView textView2 = (TextView)view.findViewById(R.id.subtitle_view);
        if (this.zzatO != 0) {
            textView2.setTextAppearance((Context)this.getActivity(), this.zzatO);
        }
        ProgressBar progressBar = (ProgressBar)view.findViewById(R.id.progressBar);
        if (this.zzatQ != 0) {
            LayerDrawable layerDrawable = (LayerDrawable)progressBar.getProgressDrawable();
            layerDrawable.setColorFilter(this.zzatQ, PorterDuff.Mode.SRC_IN);
        }
        this.zzatK.bindTextViewToMetadataOfCurrentItem(textView, "com.google.android.gms.cast.metadata.TITLE");
        this.zzatK.bindTextViewToMetadataOfCurrentItem(textView2, "com.google.android.gms.cast.metadata.SUBTITLE");
        this.zzatK.bindProgressBar(progressBar);
        this.zzatK.bindViewToLaunchExpandedController((View)relativeLayout);
        if (this.zzatM) {
            int n = this.getResources().getDimensionPixelSize(R.dimen.cast_mini_controller_icon_width);
            int n2 = this.getResources().getDimensionPixelSize(R.dimen.cast_mini_controller_icon_height);
            this.zzatK.bindImageViewToImageOfCurrentItem(imageView, new ImageHints(2, n, n2), R.drawable.cast_album_art_placeholder);
        } else {
            imageView.setVisibility(8);
        }
        this.zzatE[0] = (ImageView)relativeLayout.findViewById(R.id.button_0);
        this.zzatE[1] = (ImageView)relativeLayout.findViewById(R.id.button_1);
        this.zzatE[2] = (ImageView)relativeLayout.findViewById(R.id.button_2);
        this.zza(relativeLayout, R.id.button_0, 0);
        this.zza(relativeLayout, R.id.button_1, 1);
        this.zza(relativeLayout, R.id.button_2, 2);
        return view;
    }

    public void onDestroy() {
        if (this.zzatK != null) {
            this.zzatK.dispose();
            this.zzatK = null;
        }
        super.onDestroy();
    }

    private void zza(Context context, AttributeSet attributeSet) {
        if (this.zzatD != null) {
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.CastMiniController, R.attr.castMiniControllerStyle, R.style.CastMiniController);
        this.zzatM = typedArray.getBoolean(R.styleable.CastMiniController_castShowImageThumbnail, true);
        this.zzatN = typedArray.getResourceId(R.styleable.CastMiniController_castTitleTextAppearance, 0);
        this.zzatO = typedArray.getResourceId(R.styleable.CastMiniController_castSubtitleTextAppearance, 0);
        this.zzatP = typedArray.getResourceId(R.styleable.CastMiniController_castBackground, 0);
        this.zzatQ = typedArray.getColor(R.styleable.CastMiniController_castProgressBarColor, 0);
        this.zzaty = typedArray.getResourceId(R.styleable.CastMiniController_castButtonColor, 0);
        this.zzatp = typedArray.getResourceId(R.styleable.CastMiniController_castPlayButtonDrawable, 0);
        this.zzatq = typedArray.getResourceId(R.styleable.CastMiniController_castPauseButtonDrawable, 0);
        this.zzatr = typedArray.getResourceId(R.styleable.CastMiniController_castStopButtonDrawable, 0);
        this.zzatS = typedArray.getResourceId(R.styleable.CastMiniController_castPlayButtonDrawable, 0);
        this.zzatT = typedArray.getResourceId(R.styleable.CastMiniController_castPauseButtonDrawable, 0);
        this.zzatU = typedArray.getResourceId(R.styleable.CastMiniController_castStopButtonDrawable, 0);
        this.zzats = typedArray.getResourceId(R.styleable.CastMiniController_castSkipPreviousButtonDrawable, 0);
        this.zzatt = typedArray.getResourceId(R.styleable.CastMiniController_castSkipNextButtonDrawable, 0);
        this.zzatu = typedArray.getResourceId(R.styleable.CastMiniController_castRewind30ButtonDrawable, 0);
        this.zzatv = typedArray.getResourceId(R.styleable.CastMiniController_castForward30ButtonDrawable, 0);
        this.zzatw = typedArray.getResourceId(R.styleable.CastMiniController_castMuteToggleButtonDrawable, 0);
        this.zzatx = typedArray.getResourceId(R.styleable.CastMiniController_castClosedCaptionsButtonDrawable, 0);
        int n = typedArray.getResourceId(R.styleable.CastMiniController_castControlButtons, 0);
        if (n != 0) {
            TypedArray typedArray2 = context.getResources().obtainTypedArray(n);
            zzac.zzas((typedArray2.length() == 3 ? 1 : 0) != 0);
            this.zzatD = new int[typedArray2.length()];
            for (int i = 0; i < typedArray2.length(); ++i) {
                this.zzatD[i] = typedArray2.getResourceId(i, 0);
            }
            typedArray2.recycle();
            if (this.zzatM) {
                this.zzatD[0] = R.id.cast_button_type_empty;
            }
            this.zzatR = 0;
            for (int n2 : this.zzatD) {
                if (n2 == R.id.cast_button_type_empty) continue;
                ++this.zzatR;
            }
        } else {
            zzaoQ.zzf("Unable to read attribute castControlButtons.", new Object[0]);
            this.zzatD = new int[]{R.id.cast_button_type_empty, R.id.cast_button_type_empty, R.id.cast_button_type_empty};
        }
        typedArray.recycle();
    }

    @Override
    public final int getButtonSlotCount() {
        return 3;
    }

    @Override
    public final int getButtonTypeAt(int n) throws IndexOutOfBoundsException {
        return this.zzatD[n];
    }

    @Override
    public final ImageView getButtonImageViewAt(int n) throws IndexOutOfBoundsException {
        return this.zzatE[n];
    }

    @Override
    public UIMediaController getUIMediaController() {
        return this.zzatK;
    }

    private void zza(RelativeLayout relativeLayout, int n, int n2) {
        ImageView imageView = (ImageView)relativeLayout.findViewById(n);
        int n3 = this.zzatD[n2];
        if (n3 == R.id.cast_button_type_empty) {
            imageView.setVisibility(4);
        } else if (n3 != R.id.cast_button_type_custom) {
            if (n3 == R.id.cast_button_type_play_pause_toggle) {
                int n4 = this.zzatp;
                int n5 = this.zzatq;
                int n6 = this.zzatr;
                if (this.zzatR == 1) {
                    n4 = this.zzatS;
                    n5 = this.zzatT;
                    n6 = this.zzatU;
                }
                Drawable drawable2 = zza.zza(this.getContext(), this.zzaty, n4);
                Drawable drawable3 = zza.zza(this.getContext(), this.zzaty, n5);
                Drawable drawable4 = zza.zza(this.getContext(), this.zzaty, n6);
                imageView.setImageDrawable(drawable3);
                ProgressBar progressBar = this.zzcd(n);
                relativeLayout.addView((View)progressBar);
                this.zzatK.bindImageViewToPlayPauseToggle(imageView, drawable2, drawable3, drawable4, (View)progressBar, true);
            } else if (n3 == R.id.cast_button_type_skip_previous) {
                imageView.setImageDrawable(zza.zza(this.getContext(), this.zzaty, this.zzats));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_prev));
                this.zzatK.bindViewToSkipPrev((View)imageView, 0);
            } else if (n3 == R.id.cast_button_type_skip_next) {
                imageView.setImageDrawable(zza.zza(this.getContext(), this.zzaty, this.zzatt));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_next));
                this.zzatK.bindViewToSkipNext((View)imageView, 0);
            } else if (n3 == R.id.cast_button_type_rewind_30_seconds) {
                imageView.setImageDrawable(zza.zza(this.getContext(), this.zzaty, this.zzatu));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_rewind_30));
                this.zzatK.bindViewToRewind((View)imageView, 30000L);
            } else if (n3 == R.id.cast_button_type_forward_30_seconds) {
                imageView.setImageDrawable(zza.zza(this.getContext(), this.zzaty, this.zzatv));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_forward_30));
                this.zzatK.bindViewToForward((View)imageView, 30000L);
            } else if (n3 == R.id.cast_button_type_mute_toggle) {
                imageView.setImageDrawable(zza.zza(this.getContext(), this.zzaty, this.zzatw));
                this.zzatK.bindImageViewToMuteToggle(imageView);
            } else if (n3 == R.id.cast_button_type_closed_caption) {
                imageView.setImageDrawable(zza.zza(this.getContext(), this.zzaty, this.zzatx));
                this.zzatK.bindViewToClosedCaption((View)imageView);
            }
        }
    }

    private ProgressBar zzcd(int n) {
        ProgressBar progressBar = new ProgressBar(this.getContext());
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(8, n);
        layoutParams.addRule(6, n);
        layoutParams.addRule(5, n);
        layoutParams.addRule(7, n);
        layoutParams.addRule(15);
        progressBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        progressBar.setVisibility(8);
        Drawable drawable2 = progressBar.getIndeterminateDrawable();
        if (this.zzatQ != 0 && drawable2 != null) {
            drawable2.setColorFilter(this.zzatQ, PorterDuff.Mode.SRC_IN);
        }
        return progressBar;
    }
}

