/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.IntroductoryOverlay;
import com.google.android.gms.internal.zzww;

public class zzwx
extends RelativeLayout
implements IntroductoryOverlay {
    private final boolean zzapI;
    private Activity mActivity;
    private int zzapN;
    private boolean zzapK;
    private IntroductoryOverlay.OnOverlayDismissedListener zzapu;
    private final zza zzapO;

    public zzwx(IntroductoryOverlay.Builder builder) {
        this(builder, null, R.attr.castIntroOverlayStyle);
    }

    @TargetApi(value=14)
    public zzwx(IntroductoryOverlay.Builder builder, AttributeSet attributeSet, int n) {
        super((Context)builder.getActivity(), attributeSet, n);
        Rect rect;
        this.mActivity = builder.getActivity();
        this.zzapI = builder.zzsw();
        this.zzapu = builder.zzsu();
        TypedArray typedArray = this.mActivity.getTheme().obtainStyledAttributes(attributeSet, R.styleable.CastIntroOverlay, n, R.style.CastIntroOverlay);
        if (builder.zzst() != null) {
            rect = new Rect();
            builder.zzst().getGlobalVisibleRect(rect);
            this.zzapO = new zza();
            this.zzapO.x = rect.centerX();
            this.zzapO.y = rect.centerY();
            this.zzapO.zzapR = this.zzsF();
            this.zzapO.zzapS = builder.zzsz();
            if (this.zzapO.zzapS == 0.0f) {
                this.zzapO.zzapS = typedArray.getDimension(R.styleable.CastIntroOverlay_castFocusRadius, 0.0f);
            }
        } else {
            this.zzapO = null;
        }
        rect = LayoutInflater.from((Context)this.mActivity);
        rect.inflate(R.layout.cast_intro_overlay, (ViewGroup)this);
        this.zzapN = builder.zzsv();
        if (this.zzapN == 0) {
            this.zzapN = typedArray.getColor(R.styleable.CastIntroOverlay_castBackgroundColor, Color.argb((int)0, (int)0, (int)0, (int)0));
        }
        TextView textView = (TextView)this.findViewById(R.id.textTitle);
        if (!TextUtils.isEmpty((CharSequence)builder.zzsx())) {
            textView.setText((CharSequence)builder.zzsx());
            int n2 = typedArray.getResourceId(R.styleable.CastIntroOverlay_castTitleTextAppearance, 0);
            if (n2 != 0) {
                textView.setTextAppearance((Context)this.mActivity, n2);
            }
        }
        this.zza(builder.zzsy(), typedArray);
        typedArray.recycle();
        if (Build.VERSION.SDK_INT >= 14) {
            this.setFitsSystemWindows(true);
        }
    }

    @Override
    public void show() {
        if (this.mActivity == null) {
            return;
        }
        if (zzww.zzaf((Context)this.mActivity)) {
            return;
        }
        if (this.zzapI && IntroductoryOverlay.zza.zzad((Context)this.mActivity)) {
            this.mActivity = null;
            this.zzapu = null;
            return;
        }
        if (!this.zzapK) {
            this.zzapK = true;
            ((ViewGroup)this.mActivity.getWindow().getDecorView()).addView((View)this);
        }
    }

    @Override
    public void remove() {
        if (this.mActivity != null) {
            ((ViewGroup)this.mActivity.getWindow().getDecorView()).removeView((View)this);
            this.mActivity = null;
        }
        this.zzapu = null;
    }

    @TargetApi(value=11)
    private void zza(String string2, TypedArray typedArray) {
        String string3 = string2;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string3 = typedArray.getString(R.styleable.CastIntroOverlay_castButtonText);
        }
        int n = typedArray.getColor(R.styleable.CastIntroOverlay_castButtonBackgroundColor, Color.argb((int)0, (int)0, (int)0, (int)0));
        Button button = (Button)this.findViewById(R.id.button);
        button.setText((CharSequence)string3);
        button.getBackground().setColorFilter(n, PorterDuff.Mode.MULTIPLY);
        int n2 = typedArray.getResourceId(R.styleable.CastIntroOverlay_castButtonTextAppearance, 0);
        if (n2 != 0) {
            button.setTextAppearance((Context)this.mActivity, n2);
        }
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (Build.VERSION.SDK_INT >= 16) {
                    ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this, (String)"alpha", (float[])new float[]{0.0f});
                    objectAnimator.setDuration(400L).addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animator) {
                            zzwx.this.zzsG();
                        }
                    });
                    objectAnimator.start();
                } else {
                    zzwx.this.zzsG();
                }
            }
        });
    }

    private Paint zzsF() {
        PorterDuffXfermode porterDuffXfermode = new PorterDuffXfermode(PorterDuff.Mode.MULTIPLY);
        Paint paint = new Paint();
        paint.setColor(-1);
        paint.setAlpha(0);
        paint.setXfermode((Xfermode)porterDuffXfermode);
        paint.setAntiAlias(true);
        return paint;
    }

    protected void dispatchDraw(Canvas canvas) {
        Bitmap bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas2 = new Canvas(bitmap);
        canvas2.drawColor(this.zzapN);
        if (this.zzapO != null) {
            canvas2.drawCircle((float)this.zzapO.x, (float)this.zzapO.y, this.zzapO.zzapS, this.zzapO.zzapR);
        }
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        bitmap.recycle();
        super.dispatchDraw(canvas);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        return true;
    }

    protected void onDetachedFromWindow() {
        if (this.mActivity != null) {
            this.mActivity = null;
        }
        super.onDetachedFromWindow();
    }

    private void zzsG() {
        IntroductoryOverlay.zza.zzac((Context)this.mActivity);
        if (this.zzapu != null) {
            this.zzapu.onOverlayDismissed();
            this.zzapu = null;
        }
        this.remove();
    }

    private static class zza {
        public int x;
        public int y;
        public Paint zzapR;
        public float zzapS;

        private zza() {
        }
    }
}

