/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.widget.ImageView;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaUtils;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zzxa;

public class zzxh
extends UIController {
    private final ImageView zzasy;
    private final ImageHints zzarV;
    private final Bitmap zzasz;
    private final ImagePicker zzaqL;
    private final zzxa zzasA;

    public zzxh(ImageView imageView, Context context, @NonNull ImageHints imageHints, int n) {
        this.zzasy = imageView;
        this.zzarV = imageHints;
        this.zzasz = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n);
        CastMediaOptions castMediaOptions = CastContext.getSharedInstance(context).getCastOptions().getCastMediaOptions();
        this.zzaqL = castMediaOptions != null ? castMediaOptions.getImagePicker() : null;
        this.zzasA = new zzxa(context.getApplicationContext());
    }

    @Override
    public void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzasA.zza(new zzxa.zza(){

            @Override
            public void zzc(Bitmap bitmap) {
                if (bitmap != null) {
                    zzxh.this.zzasy.setImageBitmap(bitmap);
                }
            }
        });
        this.zzasy.setImageBitmap(this.zzasz);
        this.zztx();
    }

    @Override
    public void onSessionEnded() {
        this.zzasA.clear();
        this.zzasy.setImageBitmap(this.zzasz);
        super.onSessionEnded();
    }

    @Override
    public void onMediaStatusUpdated() {
        this.zztx();
    }

    private void zztx() {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.zzasy.setImageBitmap(this.zzasz);
            return;
        }
        Uri uri = this.zza(remoteMediaClient.getPreloadedItem());
        if (uri == null) {
            this.zzasy.setImageBitmap(this.zzasz);
        } else {
            this.zzasA.zzo(uri);
        }
    }

    private Uri zza(MediaQueueItem mediaQueueItem) {
        WebImage webImage;
        if (mediaQueueItem == null) {
            return null;
        }
        MediaInfo mediaInfo = mediaQueueItem.getMedia();
        if (mediaInfo == null) {
            return null;
        }
        if (this.zzaqL != null && (webImage = this.zzaqL.onPickImage(mediaInfo.getMetadata(), this.zzarV)) != null && webImage.getUrl() != null) {
            return webImage.getUrl();
        }
        return MediaUtils.getImageUri(mediaInfo, 0);
    }
}

