/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.internal.featurehighlight;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import com.google.android.gms.R;
import com.google.android.gms.internal.zzbik;
import com.google.android.gms.internal.zzbim;

class zzc
extends Drawable {
    private final Paint zzapR = new Paint();
    private final Paint zzaqr = new Paint();
    private final Rect zzapW = new Rect();
    private final int zzaqs;
    private final int zzaqt;
    private float zzapS;
    private float zzaqu = 1.0f;
    private float centerX;
    private float centerY;

    public zzc(Context context) {
        Resources resources = context.getResources();
        this.zzaqs = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_inner_radius);
        this.zzaqt = resources.getInteger(R.integer.cast_libraries_material_featurehighlight_pulse_base_alpha);
        this.zzapR.setAntiAlias(true);
        this.zzapR.setStyle(Paint.Style.FILL);
        this.zzaqr.setAntiAlias(true);
        this.zzaqr.setStyle(Paint.Style.FILL);
        this.setColor(-1);
    }

    public void draw(Canvas canvas) {
        canvas.drawCircle(this.centerX, this.centerY, this.zzapS * this.zzaqu, this.zzapR);
    }

    public void setAlpha(int n) {
        this.zzapR.setAlpha(n);
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.zzapR.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    public void setColor(@ColorInt int n) {
        this.zzapR.setColor(n);
        this.zzaqr.setColor(n);
        this.invalidateSelf();
    }

    public void zzc(Rect rect) {
        this.zzapW.set(rect);
        this.centerX = this.zzapW.exactCenterX();
        this.centerY = this.zzapW.exactCenterY();
        this.zzapS = Math.max((float)this.zzaqs, Math.max((float)this.zzapW.width() / 2.0f, (float)this.zzapW.height() / 2.0f));
        this.invalidateSelf();
    }

    public Animator zzsM() {
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{0.0f, 1.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{0.0f, 1.0f});
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2});
        objectAnimator.setInterpolator((TimeInterpolator)zzbim.zzTk());
        return objectAnimator.setDuration(350L);
    }

    public Animator zzsN() {
        AnimatorSet animatorSet = new AnimatorSet();
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scale", (float[])new float[]{1.0f, 1.1f}).setDuration(500L);
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scale", (float[])new float[]{1.1f, 1.0f}).setDuration(500L);
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"pulseScale", (float[])new float[]{1.1f, 2.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofFloat((String)"pulseAlpha", (float[])new float[]{1.0f, 0.0f});
        ObjectAnimator objectAnimator3 = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2}).setDuration(500L);
        animatorSet.play((Animator)objectAnimator);
        animatorSet.play((Animator)objectAnimator2).with((Animator)objectAnimator3).after((Animator)objectAnimator);
        animatorSet.setInterpolator((TimeInterpolator)zzbim.zzTm());
        animatorSet.setStartDelay(500L);
        zzbik.zzc((Animator)animatorSet);
        return animatorSet;
    }

    public Animator zzsO() {
        return this.zzsP();
    }

    public Animator zzsP() {
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder3 = PropertyValuesHolder.ofFloat((String)"pulseScale", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder4 = PropertyValuesHolder.ofFloat((String)"pulseAlpha", (float[])new float[]{0.0f});
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2, propertyValuesHolder3, propertyValuesHolder4});
        objectAnimator.setInterpolator((TimeInterpolator)zzbim.zzTl());
        return objectAnimator.setDuration(200L);
    }
}

