/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.uicontroller;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzxg;
import com.google.android.gms.internal.zzxh;
import com.google.android.gms.internal.zzxi;
import com.google.android.gms.internal.zzxj;
import com.google.android.gms.internal.zzxl;
import com.google.android.gms.internal.zzxm;
import com.google.android.gms.internal.zzxn;
import com.google.android.gms.internal.zzxo;
import com.google.android.gms.internal.zzxp;
import com.google.android.gms.internal.zzxq;
import com.google.android.gms.internal.zzxr;
import com.google.android.gms.internal.zzxs;
import com.google.android.gms.internal.zzxt;
import com.google.android.gms.internal.zzxu;
import com.google.android.gms.internal.zzxv;
import com.google.android.gms.internal.zzxw;
import com.google.android.gms.internal.zzxx;
import com.google.android.gms.internal.zzxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UIMediaController
implements SessionManagerListener<CastSession>,
RemoteMediaClient.Listener {
    private final Activity mActivity;
    private final SessionManager zzaoU;
    private final Map<View, List<UIController>> zzasp = new HashMap<View, List<UIController>>();
    private final Set<zzxw> zzasq = new HashSet<zzxw>();
    private RemoteMediaClient.Listener zzasr;
    private RemoteMediaClient zzapk;

    public UIMediaController(Activity activity) {
        this.mActivity = activity;
        this.zzaoU = CastContext.getSharedInstance((Context)activity).getSessionManager();
        this.zzaoU.addSessionManagerListener(this, CastSession.class);
        this.zza(this.zzaoU.getCurrentCastSession());
    }

    public boolean isActive() {
        zzac.zzdn((String)"Must be called from the main thread.");
        return this.zzapk != null;
    }

    public RemoteMediaClient getRemoteMediaClient() {
        zzac.zzdn((String)"Must be called from the main thread.");
        return this.zzapk;
    }

    public void setPostRemoteMediaClientListener(RemoteMediaClient.Listener listener) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zzasr = listener;
    }

    public void dispose() {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zztv();
        this.zzasp.clear();
        this.zzaoU.removeSessionManagerListener(this, CastSession.class);
        this.zzasr = null;
    }

    public void bindImageViewToPlayPauseToggle(@NonNull ImageView imageView, @NonNull Drawable drawable2, @NonNull Drawable drawable3, Drawable drawable4, View view, boolean bl) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzxp(imageView, (Context)this.mActivity, drawable2, drawable3, drawable4, view, bl));
    }

    public void bindViewToSkipNext(View view, int n) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zza(view, new zzxt(view, n));
    }

    public void bindViewToSkipPrev(View view, int n) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zza(view, new zzxu(view, n));
    }

    public void bindViewToForward(View view, long l) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zza(view, new zzxs(view, l));
    }

    public void bindViewToRewind(View view, long l) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.bindViewToForward(view, -l);
    }

    public void bindViewToLoadingIndicator(View view) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zza(view, new zzxl(view));
    }

    public void bindProgressBar(ProgressBar progressBar) {
        this.bindProgressBar(progressBar, 1000L);
    }

    public void bindProgressBar(ProgressBar progressBar, long l) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zza((View)progressBar, new zzxq(progressBar, l));
    }

    public void bindSeekBar(SeekBar seekBar) {
        this.bindSeekBar(seekBar, 1000L);
    }

    public void bindSeekBar(SeekBar seekBar, long l) {
        zzac.zzdn((String)"Must be called from the main thread.");
        SeekBar.OnSeekBarChangeListener onSeekBarChangeListener = new SeekBar.OnSeekBarChangeListener(){

            public void onStopTrackingTouch(SeekBar seekBar) {
                for (zzxw zzxw2 : UIMediaController.this.zzasq) {
                    zzxw2.zzan(true);
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
                for (zzxw zzxw2 : UIMediaController.this.zzasq) {
                    zzxw2.zzan(false);
                }
            }

            public void onProgressChanged(SeekBar seekBar, int n, boolean bl) {
                if (bl) {
                    for (zzxw zzxw2 : UIMediaController.this.zzasq) {
                        zzxw2.zzD(n);
                    }
                }
            }
        };
        this.zza((View)seekBar, new zzxr(seekBar, l, onSeekBarChangeListener));
    }

    public void bindTextViewToStreamPosition(TextView textView, boolean bl) {
        this.bindTextViewToStreamPosition(textView, bl, 1000L);
    }

    public void bindTextViewToStreamPosition(TextView textView, boolean bl, long l) {
        zzac.zzdn((String)"Must be called from the main thread.");
        zzxw zzxw2 = new zzxw(textView, l, this.mActivity.getString(R.string.cast_invalid_stream_position_text));
        if (bl) {
            this.zzasq.add(zzxw2);
        }
        this.zza((View)textView, zzxw2);
    }

    public void bindTextViewToStreamDuration(TextView textView) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzxv(textView, this.mActivity.getString(R.string.cast_invalid_stream_duration_text), null));
    }

    public void bindTextViewToStreamDuration(TextView textView, View view) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzxv(textView, this.mActivity.getString(R.string.cast_invalid_stream_duration_text), view));
    }

    public void bindViewToLaunchExpandedController(View view) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zza(view, new zzxj(view, this.mActivity));
    }

    public void bindViewToClosedCaption(View view) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zza(view, new zzxg(view, this.mActivity));
    }

    public void bindImageViewToMuteToggle(ImageView imageView) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzxo(imageView, (Context)this.mActivity));
    }

    public void bindTextViewToMetadataOfCurrentItem(TextView textView, String string2) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.bindTextViewToMetadataOfCurrentItem(textView, Collections.singletonList(string2));
    }

    public void bindTextViewToMetadataOfCurrentItem(TextView textView, List<String> list) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzxn(textView, list));
    }

    @Deprecated
    public void bindImageViewToImageOfCurrentItem(ImageView imageView, int n, @DrawableRes int n2) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzxi(imageView, (Context)this.mActivity, new ImageHints(n, 0, 0), n2, null));
    }

    @Deprecated
    public void bindImageViewToImageOfCurrentItem(ImageView imageView, int n, View view) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzxi(imageView, (Context)this.mActivity, new ImageHints(n, 0, 0), 0, view));
    }

    public void bindImageViewToImageOfCurrentItem(ImageView imageView, @NonNull ImageHints imageHints, @DrawableRes int n) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzxi(imageView, (Context)this.mActivity, imageHints, n, null));
    }

    public void bindImageViewToImageOfCurrentItem(ImageView imageView, @NonNull ImageHints imageHints, View view) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzxi(imageView, (Context)this.mActivity, imageHints, 0, view));
    }

    public void bindViewVisibilityToMediaSession(View view, int n) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zza(view, new zzxy(view, n));
    }

    public void bindTextViewToMetadataOfPreloadedItem(TextView textView, String string2) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.bindTextViewToMetadataOfPreloadedItem(textView, Collections.singletonList(string2));
    }

    public void bindTextViewToMetadataOfPreloadedItem(TextView textView, List<String> list) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzxm(textView, list));
    }

    @Deprecated
    public void bindImageViewToImageOfPreloadedItem(ImageView imageView, int n, @DrawableRes int n2) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzxh(imageView, (Context)this.mActivity, new ImageHints(n, 0, 0), n2));
    }

    public void bindImageViewToImageOfPreloadedItem(ImageView imageView, @NonNull ImageHints imageHints, @DrawableRes int n) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzxh(imageView, (Context)this.mActivity, imageHints, n));
    }

    public void bindViewVisibilityToPreloadingEvent(View view, int n) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zza(view, new zzxx(view, n));
    }

    public void bindViewToUIController(View view, UIController uIController) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zza(view, uIController);
    }

    @Override
    public void onSessionStarting(CastSession castSession) {
    }

    @Override
    public void onSessionStarted(CastSession castSession, String string2) {
        this.zza(castSession);
    }

    @Override
    public void onSessionResuming(CastSession castSession, String string2) {
    }

    @Override
    public void onSessionResumed(CastSession castSession, boolean bl) {
        this.zza(castSession);
    }

    @Override
    public void onSessionStartFailed(CastSession castSession, int n) {
        this.zztv();
    }

    @Override
    public void onSessionEnding(CastSession castSession) {
    }

    @Override
    public void onSessionEnded(CastSession castSession, int n) {
        this.zztv();
    }

    @Override
    public void onSessionResumeFailed(CastSession castSession, int n) {
        this.zztv();
    }

    @Override
    public void onSessionSuspended(CastSession castSession, int n) {
    }

    @Override
    public void onStatusUpdated() {
        this.zztw();
        if (this.zzasr != null) {
            this.zzasr.onStatusUpdated();
        }
    }

    @Override
    public void onMetadataUpdated() {
        this.zztw();
        if (this.zzasr != null) {
            this.zzasr.onMetadataUpdated();
        }
    }

    @Override
    public void onQueueStatusUpdated() {
        this.zztw();
        if (this.zzasr != null) {
            this.zzasr.onQueueStatusUpdated();
        }
    }

    @Override
    public void onPreloadStatusUpdated() {
        this.zztw();
        if (this.zzasr != null) {
            this.zzasr.onPreloadStatusUpdated();
        }
    }

    @Override
    public void onAdBreakStatusUpdated() {
        this.zztw();
        if (this.zzasr != null) {
            this.zzasr.onAdBreakStatusUpdated();
        }
    }

    @Override
    public void onSendingRemoteMediaRequest() {
        for (List<UIController> list : this.zzasp.values()) {
            for (UIController uIController : list) {
                uIController.onSendingRemoteMediaRequest();
            }
        }
        if (this.zzasr != null) {
            this.zzasr.onSendingRemoteMediaRequest();
        }
    }

    private void zza(Session session) {
        if (this.isActive() || !(session instanceof CastSession) || !session.isConnected()) {
            return;
        }
        CastSession castSession = (CastSession)session;
        this.zzapk = castSession.getRemoteMediaClient();
        if (this.zzapk != null) {
            this.zzapk.addListener(this);
            for (List<UIController> list : this.zzasp.values()) {
                for (UIController uIController : list) {
                    uIController.onSessionConnected(castSession);
                }
            }
            this.zztw();
        }
    }

    private void zztv() {
        if (!this.isActive()) {
            return;
        }
        for (List<UIController> list : this.zzasp.values()) {
            for (UIController uIController : list) {
                uIController.onSessionEnded();
            }
        }
        this.zzapk.removeListener(this);
        this.zzapk = null;
    }

    private void zza(View view, UIController uIController) {
        List<UIController> list = this.zzasp.get(view);
        if (list == null) {
            list = new ArrayList<UIController>();
            this.zzasp.put(view, list);
        }
        list.add(uIController);
        if (this.isActive()) {
            uIController.onSessionConnected(this.zzaoU.getCurrentCastSession());
            this.zztw();
        }
    }

    private void zztw() {
        for (List<UIController> list : this.zzasp.values()) {
            for (UIController uIController : list) {
                uIController.onMediaStatusUpdated();
            }
        }
    }
}

