/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.AdBreakInfo;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzaad;
import com.google.android.gms.internal.zzyn;
import com.google.android.gms.internal.zzyq;
import com.google.android.gms.internal.zzza;
import com.google.android.gms.internal.zzzb;
import com.google.android.gms.internal.zzzc;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

public class RemoteMediaClient
implements Cast.MessageReceivedCallback {
    private final Object zzrJ;
    private final Handler mHandler;
    private final zzza zzaoZ;
    private final zza zzasC;
    private final Cast.CastApi zzaql;
    private GoogleApiClient zzasD;
    private final List<Listener> mListeners = new CopyOnWriteArrayList<Listener>();
    private final Map<ProgressListener, zzd> zzasE = new ConcurrentHashMap<ProgressListener, zzd>();
    private final Map<Long, zzd> zzasF = new ConcurrentHashMap<Long, zzd>();
    private ParseAdsInfoCallback zzasG;
    public static final String NAMESPACE = zzza.NAMESPACE;
    public static final int RESUME_STATE_UNCHANGED = 0;
    public static final int RESUME_STATE_PLAY = 1;
    public static final int RESUME_STATE_PAUSE = 2;
    public static final int STATUS_SUCCEEDED = 0;
    public static final int STATUS_FAILED = 2100;
    public static final int STATUS_REPLACED = 2103;

    public RemoteMediaClient(@NonNull zzza zzza2, @NonNull Cast.CastApi castApi) {
        this.zzrJ = new Object();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.zzasC = new zza();
        this.zzaql = castApi;
        this.zzaoZ = (zzza)zzac.zzw((Object)zzza2);
        this.zzaoZ.zza(new zzza.zza(){

            public void onStatusUpdated() {
                this.zztI();
                RemoteMediaClient.this.zztH();
                for (Listener listener : RemoteMediaClient.this.mListeners) {
                    listener.onStatusUpdated();
                }
            }

            public void onMetadataUpdated() {
                this.zztI();
                for (Listener listener : RemoteMediaClient.this.mListeners) {
                    listener.onMetadataUpdated();
                }
            }

            public void onQueueStatusUpdated() {
                for (Listener listener : RemoteMediaClient.this.mListeners) {
                    listener.onQueueStatusUpdated();
                }
            }

            public void onPreloadStatusUpdated() {
                for (Listener listener : RemoteMediaClient.this.mListeners) {
                    listener.onPreloadStatusUpdated();
                }
            }

            public void onAdBreakStatusUpdated() {
                for (Listener listener : RemoteMediaClient.this.mListeners) {
                    listener.onAdBreakStatusUpdated();
                }
            }

            private void zztI() {
                MediaStatus mediaStatus;
                if (RemoteMediaClient.this.zzasG != null && (mediaStatus = RemoteMediaClient.this.getMediaStatus()) != null) {
                    mediaStatus.zzam(RemoteMediaClient.this.zzasG.parseIsPlayingAdFromMediaStatus(mediaStatus));
                    List<AdBreakInfo> list = RemoteMediaClient.this.zzasG.parseAdBreaksFromMediaStatus(mediaStatus);
                    MediaInfo mediaInfo = RemoteMediaClient.this.getMediaInfo();
                    if (mediaInfo != null) {
                        mediaInfo.zzA(list);
                    }
                }
            }
        });
        this.zzaoZ.zza((zzzb)this.zzasC);
    }

    public void zzd(GoogleApiClient googleApiClient) throws IOException {
        if (this.zzasD == googleApiClient) {
            return;
        }
        if (this.zzasD != null) {
            this.zzaoZ.zzuz();
            this.zzaql.removeMessageReceivedCallbacks(this.zzasD, this.getNamespace());
            this.zzasC.zzc(null);
            this.mHandler.removeCallbacksAndMessages(null);
        }
        this.zzasD = googleApiClient;
        if (this.zzasD != null) {
            this.zzasC.zzc(this.zzasD);
        }
    }

    public void zztF() throws IOException {
        if (this.zzasD != null) {
            this.zzaql.setMessageReceivedCallbacks(this.zzasD, this.getNamespace(), (Cast.MessageReceivedCallback)this);
        }
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo) {
        return this.load(mediaInfo, true, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl) {
        return this.load(mediaInfo, bl, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl, long l) {
        return this.load(mediaInfo, bl, l, null, null);
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl, long l, JSONObject jSONObject) {
        return this.load(mediaInfo, bl, l, null, jSONObject);
    }

    public PendingResult<MediaChannelResult> load(final MediaInfo mediaInfo, final boolean bl, final long l, final long[] lArray, final JSONObject jSONObject) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zztG();
        return this.zza(new zzb(this.zzasD){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaClient.this.zzrJ;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzaoZ.zza(this.zzapH, mediaInfo, bl, l, lArray, jSONObject);
                    }
                    catch (IOException | IllegalStateException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> pause() {
        return this.pause(null);
    }

    public PendingResult<MediaChannelResult> pause(final JSONObject jSONObject) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zztG();
        return this.zza(new zzb(this.zzasD){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaClient.this.zzrJ;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzaoZ.zza(this.zzapH, jSONObject);
                    }
                    catch (zzza.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> stop() {
        return this.stop(null);
    }

    public PendingResult<MediaChannelResult> stop(final JSONObject jSONObject) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zztG();
        return this.zza(new zzb(this.zzasD){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaClient.this.zzrJ;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzaoZ.zzb(this.zzapH, jSONObject);
                    }
                    catch (zzza.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> play() {
        return this.play(null);
    }

    public PendingResult<MediaChannelResult> play(final JSONObject jSONObject) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zztG();
        return this.zza(new zzb(this.zzasD){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaClient.this.zzrJ;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzaoZ.zzc(this.zzapH, jSONObject);
                    }
                    catch (zzza.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> seek(long l) {
        return this.seek(l, 0, null);
    }

    public PendingResult<MediaChannelResult> seek(long l, int n) {
        return this.seek(l, n, null);
    }

    public PendingResult<MediaChannelResult> seek(final long l, final int n, final JSONObject jSONObject) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zztG();
        return this.zza(new zzb(this.zzasD){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaClient.this.zzrJ;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzaoZ.zza(this.zzapH, l, n, jSONObject);
                    }
                    catch (zzza.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamVolume(double d) throws IllegalArgumentException {
        return this.setStreamVolume(d, null);
    }

    public PendingResult<MediaChannelResult> setStreamVolume(final double d, final JSONObject jSONObject) throws IllegalArgumentException {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zztG();
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        return this.zza(new zzb(this.zzasD){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaClient.this.zzrJ;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzaoZ.zza(this.zzapH, d, jSONObject);
                    }
                    catch (zzza.zzb | IOException | IllegalArgumentException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamMute(boolean bl) {
        return this.setStreamMute(bl, null);
    }

    public PendingResult<MediaChannelResult> setStreamMute(final boolean bl, final JSONObject jSONObject) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zztG();
        return this.zza(new zzb(this.zzasD){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaClient.this.zzrJ;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzaoZ.zza(this.zzapH, bl, jSONObject);
                    }
                    catch (zzza.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> requestStatus() {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zztG();
        return this.zza(new zzb(this.zzasD){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaClient.this.zzrJ;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzaoZ.zza(this.zzapH);
                    }
                    catch (IOException iOException) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setActiveMediaTracks(final long[] lArray) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zztG();
        if (lArray == null) {
            throw new IllegalArgumentException("trackIds cannot be null");
        }
        return this.zza(new zzb(this.zzasD){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaClient.this.zzrJ;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzaoZ.zza(this.zzapH, lArray);
                    }
                    catch (zzza.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setTextTrackStyle(final TextTrackStyle textTrackStyle) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zztG();
        if (textTrackStyle == null) {
            throw new IllegalArgumentException("trackStyle cannot be null");
        }
        return this.zza(new zzb(this.zzasD){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaClient.this.zzrJ;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzaoZ.zza(this.zzapH, textTrackStyle);
                    }
                    catch (zzza.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueLoad(MediaQueueItem[] mediaQueueItemArray, int n, int n2, JSONObject jSONObject) throws IllegalArgumentException {
        return this.queueLoad(mediaQueueItemArray, n, n2, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueLoad(final MediaQueueItem[] mediaQueueItemArray, final int n, final int n2, final long l, final JSONObject jSONObject) throws IllegalArgumentException {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zztG();
        return this.zza(new zzb(this.zzasD){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaClient.this.zzrJ;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzaoZ.zza(this.zzapH, mediaQueueItemArray, n, n2, l, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueInsertItems(final MediaQueueItem[] mediaQueueItemArray, final int n, final JSONObject jSONObject) throws IllegalArgumentException {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zztG();
        return this.zza(new zzb(this.zzasD){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaClient.this.zzrJ;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzaoZ.zza(this.zzapH, mediaQueueItemArray, n, 0, -1, -1L, jSONObject);
                    }
                    catch (zzza.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueAppendItem(MediaQueueItem mediaQueueItem, JSONObject jSONObject) throws IllegalArgumentException {
        return this.queueInsertItems(new MediaQueueItem[]{mediaQueueItem}, 0, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(MediaQueueItem mediaQueueItem, int n, JSONObject jSONObject) {
        return this.queueInsertAndPlayItem(mediaQueueItem, n, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(final MediaQueueItem mediaQueueItem, final int n, final long l, final JSONObject jSONObject) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zztG();
        return this.zza(new zzb(this.zzasD){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaClient.this.zzrJ;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzaoZ.zza(this.zzapH, new MediaQueueItem[]{mediaQueueItem}, n, 0, 0, l, jSONObject);
                    }
                    catch (zzza.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueUpdateItems(final MediaQueueItem[] mediaQueueItemArray, final JSONObject jSONObject) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zztG();
        return this.zza(new zzb(this.zzasD){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaClient.this.zzrJ;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzaoZ.zza(this.zzapH, 0, -1L, mediaQueueItemArray, 0, null, jSONObject);
                    }
                    catch (zzza.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueRemoveItems(final int[] nArray, final JSONObject jSONObject) throws IllegalArgumentException {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zztG();
        return this.zza(new zzb(this.zzasD){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaClient.this.zzrJ;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzaoZ.zza(this.zzapH, nArray, jSONObject);
                    }
                    catch (zzza.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueReorderItems(final int[] nArray, final int n, final JSONObject jSONObject) throws IllegalArgumentException {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zztG();
        return this.zza(new zzb(this.zzasD){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaClient.this.zzrJ;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzaoZ.zza(this.zzapH, nArray, n, jSONObject);
                    }
                    catch (zzza.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queuePrev(final JSONObject jSONObject) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zztG();
        return this.zza(new zzb(this.zzasD){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaClient.this.zzrJ;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzaoZ.zza(this.zzapH, 0, -1L, null, -1, null, jSONObject);
                    }
                    catch (zzza.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueNext(final JSONObject jSONObject) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zztG();
        return this.zza(new zzb(this.zzasD){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaClient.this.zzrJ;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzaoZ.zza(this.zzapH, 0, -1L, null, 1, null, jSONObject);
                    }
                    catch (zzza.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueSetRepeatMode(final int n, final JSONObject jSONObject) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zztG();
        return this.zza(new zzb(this.zzasD){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaClient.this.zzrJ;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzaoZ.zza(this.zzapH, 0, -1L, null, 0, Integer.valueOf(n), jSONObject);
                    }
                    catch (zzza.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueRemoveItem(final int n, final JSONObject jSONObject) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zztG();
        return this.zza(new zzb(this.zzasD){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaClient.this.zzrJ;
                synchronized (object) {
                    if (RemoteMediaClient.this.zzbU(n) == -1) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(0)));
                        return;
                    }
                    try {
                        RemoteMediaClient.this.zzaoZ.zza(this.zzapH, new int[]{n}, jSONObject);
                    }
                    catch (zzza.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(int n, JSONObject jSONObject) {
        return this.queueJumpToItem(n, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(final int n, final long l, final JSONObject jSONObject) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zztG();
        return this.zza(new zzb(this.zzasD){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaClient.this.zzrJ;
                synchronized (object) {
                    if (RemoteMediaClient.this.zzbU(n) == -1) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(0)));
                        return;
                    }
                    try {
                        RemoteMediaClient.this.zzaoZ.zza(this.zzapH, n, l, null, 0, null, jSONObject);
                    }
                    catch (zzza.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueMoveItemToNewIndex(final int n, final int n2, final JSONObject jSONObject) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zztG();
        return this.zza(new zzb(this.zzasD){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaClient.this.zzrJ;
                synchronized (object) {
                    int n4 = RemoteMediaClient.this.zzbU(n);
                    if (n4 == -1) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(0)));
                        return;
                    }
                    if (n2 < 0) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2001, String.format(Locale.ROOT, "Invalid request: Invalid newIndex %d.", n2))));
                        return;
                    }
                    if (n4 == n2) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(0)));
                        return;
                    }
                    int n22 = n2 > n4 ? n2 + 1 : n2;
                    MediaQueueItem mediaQueueItem = RemoteMediaClient.this.getMediaStatus().getQueueItem(n22);
                    int n3 = 0;
                    if (mediaQueueItem != null) {
                        n3 = mediaQueueItem.getItemId();
                    }
                    try {
                        RemoteMediaClient.this.zzaoZ.zza(this.zzapH, new int[]{n}, n3, jSONObject);
                    }
                    catch (zzza.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    private int zzbU(int n) {
        zzac.zzdj((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        for (int i = 0; i < mediaStatus.getQueueItemCount(); ++i) {
            if (mediaStatus.getQueueItem(i).getItemId() != n) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getApproximateStreamPosition() {
        Object object = this.zzrJ;
        synchronized (object) {
            zzac.zzdj((String)"Must be called from the main thread.");
            return this.zzaoZ.getApproximateStreamPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStreamDuration() {
        Object object = this.zzrJ;
        synchronized (object) {
            zzac.zzdj((String)"Must be called from the main thread.");
            return this.zzaoZ.getStreamDuration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaStatus getMediaStatus() {
        Object object = this.zzrJ;
        synchronized (object) {
            zzac.zzdj((String)"Must be called from the main thread.");
            return this.zzaoZ.getMediaStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaInfo getMediaInfo() {
        Object object = this.zzrJ;
        synchronized (object) {
            zzac.zzdj((String)"Must be called from the main thread.");
            return this.zzaoZ.getMediaInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlayerState() {
        Object object = this.zzrJ;
        synchronized (object) {
            zzac.zzdj((String)"Must be called from the main thread.");
            MediaStatus mediaStatus = this.getMediaStatus();
            return mediaStatus != null ? mediaStatus.getPlayerState() : 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdleReason() {
        Object object = this.zzrJ;
        synchronized (object) {
            zzac.zzdj((String)"Must be called from the main thread.");
            MediaStatus mediaStatus = this.getMediaStatus();
            return mediaStatus != null ? mediaStatus.getIdleReason() : 0;
        }
    }

    public boolean isLiveStream() {
        zzac.zzdj((String)"Must be called from the main thread.");
        MediaInfo mediaInfo = this.getMediaInfo();
        return mediaInfo != null && mediaInfo.getStreamType() == 2;
    }

    public boolean isPlaying() {
        zzac.zzdj((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.getPlayerState() == 2;
    }

    public boolean isPaused() {
        zzac.zzdj((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && (mediaStatus.getPlayerState() == 3 || this.isLiveStream() && this.getIdleReason() == 2);
    }

    public boolean isBuffering() {
        zzac.zzdj((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.getPlayerState() == 4;
    }

    public boolean isLoadingNextItem() {
        zzac.zzdj((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.getLoadingItemId() != 0;
    }

    public MediaQueueItem getCurrentItem() {
        zzac.zzdj((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus == null ? null : mediaStatus.getQueueItemById(mediaStatus.getCurrentItemId());
    }

    public MediaQueueItem getLoadingItem() {
        zzac.zzdj((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus == null ? null : mediaStatus.getQueueItemById(mediaStatus.getLoadingItemId());
    }

    public MediaQueueItem getPreloadedItem() {
        zzac.zzdj((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus == null ? null : mediaStatus.getQueueItemById(mediaStatus.getPreloadedItemId());
    }

    public void togglePlayback() {
        zzac.zzdj((String)"Must be called from the main thread.");
        int n = this.getPlayerState();
        if (n == 4 || n == 2) {
            this.pause();
        } else {
            this.play();
        }
    }

    public boolean hasMediaSession() {
        zzac.zzdj((String)"Must be called from the main thread.");
        return this.isBuffering() || this.isPlaying() || this.isPaused() || this.isLoadingNextItem();
    }

    public void addListener(Listener listener) {
        zzac.zzdj((String)"Must be called from the main thread.");
        if (listener != null) {
            this.mListeners.add(listener);
        }
    }

    public void removeListener(Listener listener) {
        zzac.zzdj((String)"Must be called from the main thread.");
        if (listener != null) {
            this.mListeners.remove(listener);
        }
    }

    public boolean addProgressListener(ProgressListener progressListener, long l) {
        zzac.zzdj((String)"Must be called from the main thread.");
        if (progressListener == null || this.zzasE.containsKey(progressListener)) {
            return false;
        }
        zzd zzd2 = this.zzasF.get(l);
        if (zzd2 == null) {
            zzd2 = new zzd(l);
            this.zzasF.put(l, zzd2);
        }
        zzd2.zza(progressListener);
        this.zzasE.put(progressListener, zzd2);
        if (this.hasMediaSession()) {
            zzd2.start();
        }
        return true;
    }

    public void removeProgressListener(ProgressListener progressListener) {
        zzac.zzdj((String)"Must be called from the main thread.");
        zzd zzd2 = this.zzasE.remove(progressListener);
        if (zzd2 != null) {
            zzd2.zzb(progressListener);
            if (!zzd2.zztK()) {
                this.zzasF.remove(zzd2.zztJ());
                zzd2.stop();
            }
        }
    }

    public void setParseAdsInfoCallback(ParseAdsInfoCallback parseAdsInfoCallback) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zzasG = parseAdsInfoCallback;
    }

    public boolean isPlayingAd() {
        zzac.zzdj((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.isPlayingAd();
    }

    public String getNamespace() {
        zzac.zzdj((String)"Must be called from the main thread.");
        return this.zzaoZ.getNamespace();
    }

    public void onMessageReceived(CastDevice castDevice, String string2, String string3) {
        this.zzaoZ.zzcP(string3);
    }

    private void zztG() throws IllegalStateException {
        if (this.zzasD == null) {
            throw new IllegalStateException("No connection");
        }
    }

    private zzb zza(zzb zzb2) {
        try {
            this.zzasD.zzb((zzaad.zza)zzb2);
            return zzb2;
        }
        catch (IllegalStateException illegalStateException) {
            try {
                zzb2.zzb((MediaChannelResult)zzb2.zzc(new Status(2100)));
                return zzb2;
            }
            catch (Throwable throwable) {
                return zzb2;
            }
        }
    }

    private void zza(Set<ProgressListener> set) {
        block5: {
            HashSet<ProgressListener> hashSet;
            block6: {
                block4: {
                    if (this.isBuffering() || this.isPaused()) {
                        return;
                    }
                    hashSet = new HashSet<ProgressListener>(set);
                    if (!this.isPlaying()) break block4;
                    for (ProgressListener progressListener : hashSet) {
                        progressListener.onProgressUpdated(this.getApproximateStreamPosition(), this.getStreamDuration());
                    }
                    break block5;
                }
                if (!this.isLoadingNextItem()) break block6;
                MediaQueueItem mediaQueueItem = this.getLoadingItem();
                if (mediaQueueItem == null || mediaQueueItem.getMedia() == null) break block5;
                for (ProgressListener progressListener : hashSet) {
                    progressListener.onProgressUpdated(0L, mediaQueueItem.getMedia().getStreamDuration());
                }
                break block5;
            }
            for (ProgressListener progressListener : hashSet) {
                progressListener.onProgressUpdated(0L, 0L);
            }
        }
    }

    private void zztH() {
        for (zzd zzd2 : this.zzasF.values()) {
            if (this.hasMediaSession() && !zzd2.isStarted()) {
                zzd2.start();
            } else if (!this.hasMediaSession() && zzd2.isStarted()) {
                zzd2.stop();
            }
            if (!zzd2.isStarted() || !this.isBuffering() && !this.isPaused() && !this.isLoadingNextItem()) continue;
            this.zza(zzd2.zzasL);
        }
    }

    private class zzd {
        private final Set<ProgressListener> zzasL = new HashSet<ProgressListener>();
        private final long zzasM;
        private final Runnable zzasN;
        private boolean zzasO;

        public zzd(long l) {
            this.zzasM = l;
            this.zzasN = new TimerTask(){

                @Override
                public void run() {
                    RemoteMediaClient.this.zza(zzd.this.zzasL);
                    RemoteMediaClient.this.mHandler.postDelayed((Runnable)this, zzd.this.zzasM);
                }
            };
        }

        public long zztJ() {
            return this.zzasM;
        }

        public void zza(ProgressListener progressListener) {
            this.zzasL.add(progressListener);
        }

        public void zzb(ProgressListener progressListener) {
            this.zzasL.remove(progressListener);
        }

        public boolean zztK() {
            return !this.zzasL.isEmpty();
        }

        public void start() {
            RemoteMediaClient.this.mHandler.removeCallbacks(this.zzasN);
            this.zzasO = true;
            RemoteMediaClient.this.mHandler.postDelayed(this.zzasN, this.zzasM);
        }

        public void stop() {
            RemoteMediaClient.this.mHandler.removeCallbacks(this.zzasN);
            this.zzasO = false;
        }

        public boolean isStarted() {
            return this.zzasO;
        }
    }

    static abstract class zzb
    extends zzyn<MediaChannelResult> {
        zzzc zzapH = new zzzc(){

            public void zzD(long l) {
                zzb.this.zzb((MediaChannelResult)zzb.this.zzc(new Status(2103)));
            }

            public void zza(long l, int n, Object object) {
                JSONObject jSONObject = null;
                if (object instanceof JSONObject) {
                    jSONObject = (JSONObject)object;
                }
                zzb.this.zzb(new zzc(new Status(n), jSONObject));
            }
        };

        zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public MediaChannelResult zzr(final Status status) {
            return new MediaChannelResult(this){

                public Status getStatus() {
                    return status;
                }

                @Override
                public JSONObject getCustomData() {
                    return null;
                }
            };
        }

        protected void zza(zzyq zzyq2) {
        }

        public /* synthetic */ void setResult(Object object) {
            super.zzb((Result)((MediaChannelResult)object));
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzr(status);
        }
    }

    private static final class zzc
    implements MediaChannelResult {
        private final Status zzair;
        private final JSONObject zzamO;

        zzc(Status status, JSONObject jSONObject) {
            this.zzair = status;
            this.zzamO = jSONObject;
        }

        public Status getStatus() {
            return this.zzair;
        }

        @Override
        public JSONObject getCustomData() {
            return this.zzamO;
        }
    }

    public static interface MediaChannelResult
    extends Result {
        public JSONObject getCustomData();
    }

    private class com.google.android.gms.cast.framework.media.RemoteMediaClient$zza
    implements zzzb {
        private GoogleApiClient zzapD;
        private long zzapE = 0L;

        public void zzc(GoogleApiClient googleApiClient) {
            this.zzapD = googleApiClient;
        }

        public long zzsA() {
            return ++this.zzapE;
        }

        public void zza(String string2, String string3, long l, String string4) throws IOException {
            if (this.zzapD == null) {
                throw new IOException("No GoogleApiClient available");
            }
            for (Listener listener : RemoteMediaClient.this.mListeners) {
                listener.onSendingRemoteMediaRequest();
            }
            RemoteMediaClient.this.zzaql.sendMessage(this.zzapD, string2, string3).setResultCallback((ResultCallback)new zza(l));
        }

        private final class zza
        implements ResultCallback<Status> {
            private final long zzapF;

            zza(long l) {
                this.zzapF = l;
            }

            public void zzp(@NonNull Status status) {
                if (!status.isSuccess()) {
                    RemoteMediaClient.this.zzaoZ.zzb(this.zzapF, status.getStatusCode());
                }
            }

            public /* synthetic */ void onResult(@NonNull Result result) {
                this.zzp((Status)result);
            }
        }
    }

    public static interface ParseAdsInfoCallback {
        public boolean parseIsPlayingAdFromMediaStatus(MediaStatus var1);

        public List<AdBreakInfo> parseAdBreaksFromMediaStatus(MediaStatus var1);
    }

    public static interface ProgressListener {
        public void onProgressUpdated(long var1, long var3);
    }

    public static interface Listener {
        public void onStatusUpdated();

        public void onMetadataUpdated();

        public void onQueueStatusUpdated();

        public void onPreloadStatusUpdated();

        public void onSendingRemoteMediaRequest();

        public void onAdBreakStatusUpdated();
    }
}

