/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.zzb;
import com.google.android.gms.common.internal.safeparcel.zza;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastOptions
extends zza {
    public static final Parcelable.Creator<CastOptions> CREATOR = new zzb();
    private final String zzaqc;
    private final List<String> zzaqd;
    private final boolean zzaqe;
    private final LaunchOptions zzaog;
    private final boolean zzaqf;
    private final CastMediaOptions zzaqg;
    private final boolean zzaqh;
    private final double zzaqi;

    CastOptions(String string, List<String> list, boolean bl, LaunchOptions launchOptions, boolean bl2, CastMediaOptions castMediaOptions, boolean bl3, double d) {
        this.zzaqc = TextUtils.isEmpty((CharSequence)string) ? "" : string;
        int n = list == null ? 0 : list.size();
        this.zzaqd = new ArrayList<String>(n);
        if (n > 0) {
            this.zzaqd.addAll(list);
        }
        this.zzaqe = bl;
        this.zzaog = launchOptions == null ? new LaunchOptions() : launchOptions;
        this.zzaqf = bl2;
        this.zzaqg = castMediaOptions;
        this.zzaqh = bl3;
        this.zzaqi = d;
    }

    public String getReceiverApplicationId() {
        return this.zzaqc;
    }

    public List<String> getSupportedNamespaces() {
        return Collections.unmodifiableList(this.zzaqd);
    }

    public boolean getStopReceiverApplicationWhenEndingSession() {
        return this.zzaqe;
    }

    public LaunchOptions getLaunchOptions() {
        return this.zzaog;
    }

    public boolean getResumeSavedSession() {
        return this.zzaqf;
    }

    public CastMediaOptions getCastMediaOptions() {
        return this.zzaqg;
    }

    public boolean getEnableReconnectionService() {
        return this.zzaqh;
    }

    public double getVolumeDeltaBeforeIceCreamSandwich() {
        return this.zzaqi;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    public static final class Builder {
        private String zzaqc;
        private List<String> zzaqd = new ArrayList<String>();
        private boolean zzaqe;
        private LaunchOptions zzaog = new LaunchOptions();
        private boolean zzaqf = true;
        private CastMediaOptions zzaqg = new CastMediaOptions.Builder().build();
        private boolean zzaqh = true;
        private double zzaqi = 0.05f;

        public Builder setReceiverApplicationId(String string) {
            this.zzaqc = string;
            return this;
        }

        public Builder setSupportedNamespaces(List<String> list) {
            this.zzaqd = list;
            return this;
        }

        public Builder setStopReceiverApplicationWhenEndingSession(boolean bl) {
            this.zzaqe = bl;
            return this;
        }

        public Builder setLaunchOptions(LaunchOptions launchOptions) {
            this.zzaog = launchOptions;
            return this;
        }

        public Builder setResumeSavedSession(boolean bl) {
            this.zzaqf = bl;
            return this;
        }

        public Builder setCastMediaOptions(CastMediaOptions castMediaOptions) {
            this.zzaqg = castMediaOptions;
            return this;
        }

        public Builder setEnableReconnectionService(boolean bl) {
            this.zzaqh = bl;
            return this;
        }

        public Builder setVolumeDeltaBeforeIceCreamSandwich(double d) throws IllegalArgumentException {
            if (d <= 0.0 || d > 0.5) {
                throw new IllegalArgumentException("volumeDelta must be greater than 0 and less or equal to 0.5");
            }
            this.zzaqi = d;
            return this;
        }

        public CastOptions build() {
            return new CastOptions(this.zzaqc, this.zzaqd, this.zzaqe, this.zzaog, this.zzaqf, this.zzaqg, this.zzaqh, this.zzaqi);
        }
    }
}

