/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.StringRes;
import android.support.v7.app.MediaRouteButton;
import android.view.MenuItem;
import android.view.View;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzt;
import com.google.android.gms.internal.zzxb;
import com.google.android.gms.internal.zzxc;

public interface IntroductoryOverlay {
    public void show();

    public void remove();

    public static class Builder {
        private Activity mActivity;
        private View zzaqv;
        private int zzaqw;
        private String zzaqx;
        private OnOverlayDismissedListener zzaqy;
        private boolean zzaqz;
        private float zzaqA;
        private String zzaqB;

        @TargetApi(value=11)
        public Builder(Activity activity, MenuItem menuItem) {
            this.mActivity = (Activity)zzac.zzw((Object)activity);
            zzt.zzze();
            this.zzaqv = ((MenuItem)zzac.zzw((Object)menuItem)).getActionView();
        }

        public Builder(Activity activity, MediaRouteButton mediaRouteButton) {
            this.mActivity = (Activity)zzac.zzw((Object)activity);
            this.zzaqv = (View)zzac.zzw((Object)mediaRouteButton);
        }

        public Builder setOverlayColor(@ColorRes int n) {
            this.zzaqw = this.mActivity.getResources().getColor(n);
            return this;
        }

        public Builder setTitleText(String string2) {
            this.zzaqx = string2;
            return this;
        }

        public Builder setTitleText(@StringRes int n) {
            this.zzaqx = this.mActivity.getResources().getString(n);
            return this;
        }

        public Builder setOnOverlayDismissedListener(OnOverlayDismissedListener onOverlayDismissedListener) {
            this.zzaqy = onOverlayDismissedListener;
            return this;
        }

        public Builder setSingleTime() {
            this.zzaqz = true;
            return this;
        }

        public Builder setFocusRadiusId(@DimenRes int n) {
            this.zzaqA = this.mActivity.getResources().getDimension(n);
            return this;
        }

        public Builder setFocusRadius(float f) {
            this.zzaqA = f;
            return this;
        }

        public Builder setButtonText(String string2) {
            this.zzaqB = string2;
            return this;
        }

        public Builder setButtonText(@StringRes int n) {
            this.zzaqB = this.mActivity.getResources().getString(n);
            return this;
        }

        public Activity getActivity() {
            return this.mActivity;
        }

        public View zzsR() {
            return this.zzaqv;
        }

        public OnOverlayDismissedListener zzsS() {
            return this.zzaqy;
        }

        public int zzsT() {
            return this.zzaqw;
        }

        public boolean zzsU() {
            return this.zzaqz;
        }

        public String zzsV() {
            return this.zzaqx;
        }

        public String zzsW() {
            return this.zzaqB;
        }

        public float zzsX() {
            return this.zzaqA;
        }

        public IntroductoryOverlay build() {
            if (zzt.zzzi()) {
                return new zzxb(this);
            }
            return new zzxc(this);
        }
    }

    public static class zza {
        public static void zzau(Context context) {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
            sharedPreferences.edit().putBoolean("googlecast-introOverlayShown", true).apply();
        }

        public static boolean zzav(Context context) {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
            return sharedPreferences.getBoolean("googlecast-introOverlayShown", false);
        }
    }

    public static interface OnOverlayDismissedListener {
        public void onOverlayDismissed();
    }
}

