/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.uicontroller;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzxl;
import com.google.android.gms.internal.zzxm;
import com.google.android.gms.internal.zzxn;
import com.google.android.gms.internal.zzxo;
import com.google.android.gms.internal.zzxq;
import com.google.android.gms.internal.zzxr;
import com.google.android.gms.internal.zzxs;
import com.google.android.gms.internal.zzxt;
import com.google.android.gms.internal.zzxu;
import com.google.android.gms.internal.zzxv;
import com.google.android.gms.internal.zzxw;
import com.google.android.gms.internal.zzxx;
import com.google.android.gms.internal.zzxy;
import com.google.android.gms.internal.zzxz;
import com.google.android.gms.internal.zzya;
import com.google.android.gms.internal.zzyb;
import com.google.android.gms.internal.zzyc;
import com.google.android.gms.internal.zzyd;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UIMediaController
implements SessionManagerListener<CastSession>,
RemoteMediaClient.Listener {
    private final Activity mActivity;
    private final SessionManager zzapY;
    private final Map<View, List<UIController>> zzatt = new HashMap<View, List<UIController>>();
    private final Set<zzyb> zzatu = new HashSet<zzyb>();
    private RemoteMediaClient.Listener zzatv;
    private RemoteMediaClient zzaqo;

    public UIMediaController(Activity activity) {
        this.mActivity = activity;
        this.zzapY = CastContext.getSharedInstance((Context)activity).getSessionManager();
        this.zzapY.addSessionManagerListener(this, CastSession.class);
        this.zza(this.zzapY.getCurrentCastSession());
    }

    public boolean isActive() {
        zzac.zzdj((String)"Must be called from the main thread.");
        return this.zzaqo != null;
    }

    public RemoteMediaClient getRemoteMediaClient() {
        zzac.zzdj((String)"Must be called from the main thread.");
        return this.zzaqo;
    }

    public void setPostRemoteMediaClientListener(RemoteMediaClient.Listener listener) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zzatv = listener;
    }

    public void dispose() {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zztU();
        this.zzatt.clear();
        this.zzapY.removeSessionManagerListener(this, CastSession.class);
        this.zzatv = null;
    }

    public void bindImageViewToPlayPauseToggle(@NonNull ImageView imageView, @NonNull Drawable drawable2, @NonNull Drawable drawable3, Drawable drawable4, View view, boolean bl) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzxu(imageView, (Context)this.mActivity, drawable2, drawable3, drawable4, view, bl));
    }

    public void bindViewToSkipNext(View view, int n) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zza(view, new zzxy(view, n));
    }

    public void bindViewToSkipPrev(View view, int n) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zza(view, new zzxz(view, n));
    }

    public void bindViewToForward(View view, long l) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zza(view, new zzxx(view, l));
    }

    public void bindViewToRewind(View view, long l) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.bindViewToForward(view, -l);
    }

    public void bindViewToLoadingIndicator(View view) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zza(view, new zzxq(view));
    }

    public void bindProgressBar(ProgressBar progressBar) {
        this.bindProgressBar(progressBar, 1000L);
    }

    public void bindProgressBar(ProgressBar progressBar, long l) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zza((View)progressBar, new zzxv(progressBar, l));
    }

    public void bindSeekBar(SeekBar seekBar) {
        this.bindSeekBar(seekBar, 1000L);
    }

    public void bindSeekBar(SeekBar seekBar, long l) {
        zzac.zzdj((String)"Must be called from the main thread.");
        SeekBar.OnSeekBarChangeListener onSeekBarChangeListener = new SeekBar.OnSeekBarChangeListener(){

            public void onStopTrackingTouch(SeekBar seekBar) {
                for (zzyb zzyb2 : UIMediaController.this.zzatu) {
                    zzyb2.zzap(true);
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
                for (zzyb zzyb2 : UIMediaController.this.zzatu) {
                    zzyb2.zzap(false);
                }
            }

            public void onProgressChanged(SeekBar seekBar, int n, boolean bl) {
                if (bl) {
                    for (zzyb zzyb2 : UIMediaController.this.zzatu) {
                        zzyb2.zzE(n);
                    }
                }
            }
        };
        this.zza((View)seekBar, new zzxw(seekBar, l, onSeekBarChangeListener));
    }

    public void bindTextViewToStreamPosition(TextView textView, boolean bl) {
        this.bindTextViewToStreamPosition(textView, bl, 1000L);
    }

    public void bindTextViewToStreamPosition(TextView textView, boolean bl, long l) {
        zzac.zzdj((String)"Must be called from the main thread.");
        zzyb zzyb2 = new zzyb(textView, l, this.mActivity.getString(R.string.cast_invalid_stream_position_text));
        if (bl) {
            this.zzatu.add(zzyb2);
        }
        this.zza((View)textView, zzyb2);
    }

    public void bindTextViewToStreamDuration(TextView textView) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzya(textView, this.mActivity.getString(R.string.cast_invalid_stream_duration_text), null));
    }

    public void bindTextViewToStreamDuration(TextView textView, View view) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzya(textView, this.mActivity.getString(R.string.cast_invalid_stream_duration_text), view));
    }

    public void bindViewToLaunchExpandedController(View view) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zza(view, new zzxo(view, this.mActivity));
    }

    public void bindViewToClosedCaption(View view) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zza(view, new zzxl(view, this.mActivity));
    }

    public void bindImageViewToMuteToggle(ImageView imageView) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzxt(imageView, (Context)this.mActivity));
    }

    public void bindTextViewToMetadataOfCurrentItem(TextView textView, String string2) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.bindTextViewToMetadataOfCurrentItem(textView, Collections.singletonList(string2));
    }

    public void bindTextViewToMetadataOfCurrentItem(TextView textView, List<String> list) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzxs(textView, list));
    }

    @Deprecated
    public void bindImageViewToImageOfCurrentItem(ImageView imageView, int n, @DrawableRes int n2) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzxn(imageView, (Context)this.mActivity, new ImageHints(n, 0, 0), n2, null));
    }

    @Deprecated
    public void bindImageViewToImageOfCurrentItem(ImageView imageView, int n, View view) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzxn(imageView, (Context)this.mActivity, new ImageHints(n, 0, 0), 0, view));
    }

    public void bindImageViewToImageOfCurrentItem(ImageView imageView, @NonNull ImageHints imageHints, @DrawableRes int n) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzxn(imageView, (Context)this.mActivity, imageHints, n, null));
    }

    public void bindImageViewToImageOfCurrentItem(ImageView imageView, @NonNull ImageHints imageHints, View view) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzxn(imageView, (Context)this.mActivity, imageHints, 0, view));
    }

    public void bindViewVisibilityToMediaSession(View view, int n) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zza(view, new zzyd(view, n));
    }

    public void bindTextViewToMetadataOfPreloadedItem(TextView textView, String string2) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.bindTextViewToMetadataOfPreloadedItem(textView, Collections.singletonList(string2));
    }

    public void bindTextViewToMetadataOfPreloadedItem(TextView textView, List<String> list) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzxr(textView, list));
    }

    @Deprecated
    public void bindImageViewToImageOfPreloadedItem(ImageView imageView, int n, @DrawableRes int n2) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzxm(imageView, (Context)this.mActivity, new ImageHints(n, 0, 0), n2));
    }

    public void bindImageViewToImageOfPreloadedItem(ImageView imageView, @NonNull ImageHints imageHints, @DrawableRes int n) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzxm(imageView, (Context)this.mActivity, imageHints, n));
    }

    public void bindViewVisibilityToPreloadingEvent(View view, int n) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zza(view, new zzyc(view, n));
    }

    public void bindViewToUIController(View view, UIController uIController) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.zza(view, uIController);
    }

    @Override
    public void onSessionStarting(CastSession castSession) {
    }

    @Override
    public void onSessionStarted(CastSession castSession, String string2) {
        this.zza(castSession);
    }

    @Override
    public void onSessionResuming(CastSession castSession, String string2) {
    }

    @Override
    public void onSessionResumed(CastSession castSession, boolean bl) {
        this.zza(castSession);
    }

    @Override
    public void onSessionStartFailed(CastSession castSession, int n) {
        this.zztU();
    }

    @Override
    public void onSessionEnding(CastSession castSession) {
    }

    @Override
    public void onSessionEnded(CastSession castSession, int n) {
        this.zztU();
    }

    @Override
    public void onSessionResumeFailed(CastSession castSession, int n) {
        this.zztU();
    }

    @Override
    public void onSessionSuspended(CastSession castSession, int n) {
    }

    @Override
    public void onStatusUpdated() {
        this.zztV();
        if (this.zzatv != null) {
            this.zzatv.onStatusUpdated();
        }
    }

    @Override
    public void onMetadataUpdated() {
        this.zztV();
        if (this.zzatv != null) {
            this.zzatv.onMetadataUpdated();
        }
    }

    @Override
    public void onQueueStatusUpdated() {
        this.zztV();
        if (this.zzatv != null) {
            this.zzatv.onQueueStatusUpdated();
        }
    }

    @Override
    public void onPreloadStatusUpdated() {
        this.zztV();
        if (this.zzatv != null) {
            this.zzatv.onPreloadStatusUpdated();
        }
    }

    @Override
    public void onAdBreakStatusUpdated() {
        this.zztV();
        if (this.zzatv != null) {
            this.zzatv.onAdBreakStatusUpdated();
        }
    }

    @Override
    public void onSendingRemoteMediaRequest() {
        for (List<UIController> list : this.zzatt.values()) {
            for (UIController uIController : list) {
                uIController.onSendingRemoteMediaRequest();
            }
        }
        if (this.zzatv != null) {
            this.zzatv.onSendingRemoteMediaRequest();
        }
    }

    private void zza(Session session) {
        if (this.isActive() || !(session instanceof CastSession) || !session.isConnected()) {
            return;
        }
        CastSession castSession = (CastSession)session;
        this.zzaqo = castSession.getRemoteMediaClient();
        if (this.zzaqo != null) {
            this.zzaqo.addListener(this);
            for (List<UIController> list : this.zzatt.values()) {
                for (UIController uIController : list) {
                    uIController.onSessionConnected(castSession);
                }
            }
            this.zztV();
        }
    }

    private void zztU() {
        if (!this.isActive()) {
            return;
        }
        for (List<UIController> list : this.zzatt.values()) {
            for (UIController uIController : list) {
                uIController.onSessionEnded();
            }
        }
        this.zzaqo.removeListener(this);
        this.zzaqo = null;
    }

    private void zza(View view, UIController uIController) {
        List<UIController> list = this.zzatt.get(view);
        if (list == null) {
            list = new ArrayList<UIController>();
            this.zzatt.put(view, list);
        }
        list.add(uIController);
        if (this.isActive()) {
            uIController.onSessionConnected(this.zzapY.getCurrentCastSession());
            this.zztV();
        }
    }

    private void zztV() {
        for (List<UIController> list : this.zzatt.values()) {
            for (UIController uIController : list) {
                uIController.onMediaStatusUpdated();
            }
        }
    }
}

