/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import com.google.android.gms.R;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.internal.zzyz;
import java.io.IOException;

public class zzxt
extends UIController {
    private static final zzyz zzapV = new zzyz("MuteToggleUIController");
    private final ImageView zzatC;
    private final String zzatO;
    private final String zzatP;
    private final Context zzPB;
    private final Cast.Listener zzanj;
    private final View.OnClickListener zzatA;

    public zzxt(ImageView imageView, Context context) {
        this.zzatC = imageView;
        this.zzPB = context.getApplicationContext();
        this.zzatO = this.zzPB.getString(R.string.cast_mute);
        this.zzatP = this.zzPB.getString(R.string.cast_unmute);
        this.zzanj = new Cast.Listener(){

            public void onVolumeChanged() {
                zzxt.this.zztW();
            }
        };
        this.zzatA = new View.OnClickListener(){

            public void onClick(View view) {
                CastSession castSession = CastContext.getSharedInstance(zzxt.this.zzPB).getSessionManager().getCurrentCastSession();
                if (castSession != null && castSession.isConnected()) {
                    try {
                        if (castSession.isMute()) {
                            castSession.setMute(false);
                            zzxt.this.zzan(true);
                        } else {
                            castSession.setMute(true);
                            zzxt.this.zzan(false);
                        }
                    }
                    catch (IOException | IllegalArgumentException exception) {
                        zzapV.zzc("Unable to call CastSession.setMute(boolean).", new Object[]{exception});
                    }
                }
            }
        };
    }

    @Override
    public void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzatC.setOnClickListener(this.zzatA);
        castSession.addCastListener(this.zzanj);
        this.zztW();
    }

    @Override
    public void onSessionEnded() {
        this.zzatC.setOnClickListener(null);
        super.onSessionEnded();
    }

    @Override
    public void onMediaStatusUpdated() {
        this.zzatC.setEnabled(true);
    }

    @Override
    public void onSendingRemoteMediaRequest() {
        this.zzatC.setEnabled(false);
    }

    private void zztW() {
        CastSession castSession = CastContext.getSharedInstance(this.zzPB).getSessionManager().getCurrentCastSession();
        if (castSession != null && castSession.isConnected()) {
            this.zzatC.setEnabled(true);
            if (castSession.isMute()) {
                this.zzan(false);
            } else {
                this.zzan(true);
            }
        } else {
            this.zzatC.setEnabled(false);
        }
    }

    private void zzan(boolean bl) {
        this.zzatC.setSelected(bl);
        this.zzatC.setContentDescription((CharSequence)(bl ? this.zzatO : this.zzatP));
    }
}

