/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.view.KeyEvent;
import com.google.android.gms.cast.framework.AppVisibilityListener;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.CastStateListener;
import com.google.android.gms.cast.framework.OptionsProvider;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionProvider;
import com.google.android.gms.cast.framework.zza;
import com.google.android.gms.cast.framework.zzd;
import com.google.android.gms.cast.framework.zzg;
import com.google.android.gms.cast.framework.zzj;
import com.google.android.gms.cast.framework.zzn;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzt;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.zzwv;
import com.google.android.gms.internal.zzww;
import com.google.android.gms.internal.zzxe;
import com.google.android.gms.internal.zzyz;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public final class CastContext {
    private static final zzyz zzapV = new zzyz("CastContext");
    public static final String OPTIONS_PROVIDER_CLASS_NAME_KEY = "com.google.android.gms.cast.framework.OPTIONS_PROVIDER_CLASS_NAME";
    private static CastContext zzapW;
    private final Context zzPB;
    private final zzg zzapX;
    private final SessionManager zzapY;
    private final zzd zzapZ;
    private final CastOptions zzaqa;
    private zzxe zzaqb;

    public static CastContext getSharedInstance(@NonNull Context context) throws IllegalStateException {
        zzac.zzdj((String)"Must be called from the main thread.");
        if (zzapW == null) {
            OptionsProvider optionsProvider = CastContext.zzat(context.getApplicationContext());
            zzapW = new CastContext(context, optionsProvider.getCastOptions(context.getApplicationContext()), optionsProvider.getAdditionalSessionProviders(context.getApplicationContext()));
        }
        return zzapW;
    }

    private static OptionsProvider zzat(Context context) throws IllegalStateException {
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = applicationInfo.metaData;
            String string = bundle.getString(OPTIONS_PROVIDER_CLASS_NAME_KEY);
            if (string == null) {
                throw new IllegalStateException("The fully qualified name of the implementation of OptionsProvider must be provided as a metadata in the AndroidManifest.xml with key com.google.android.gms.cast.framework.OPTIONS_PROVIDER_CLASS_NAME.");
            }
            return (OptionsProvider)Class.forName(string).newInstance();
        }
        catch (PackageManager.NameNotFoundException | ClassNotFoundException | IllegalAccessException | InstantiationException | NullPointerException throwable) {
            throw new IllegalStateException("Failed to initialize CastContext.", throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private CastContext(Context context, CastOptions castOptions, List<SessionProvider> list) {
        void var7_12;
        this.zzPB = context.getApplicationContext();
        this.zzaqa = castOptions;
        this.zzaqb = new zzxe(MediaRouter.getInstance((Context)this.zzPB));
        HashMap<String, IBinder> hashMap = new HashMap<String, IBinder>();
        zzww zzww2 = new zzww(this.zzPB, castOptions, this.zzaqb);
        hashMap.put(zzww2.getCategory(), zzww2.zzsY());
        if (list != null) {
            for (SessionProvider object2 : list) {
                zzac.zzb((Object)object2, (Object)"Additional SessionProvider must not be null.");
                String string = zzac.zzh((String)object2.getCategory(), (Object)"Category for SessionProvider must not be null or empty string.");
                zzac.zzb((!hashMap.containsKey(string) ? 1 : 0) != 0, (Object)String.format("SessionProvider for category %s already added", string));
                hashMap.put(string, object2.zzsY());
            }
        }
        this.zzapX = zzwv.zza(this.zzPB, castOptions, this.zzaqb, hashMap);
        Object object3 = null;
        try {
            object3 = this.zzapX.zzsI();
        }
        catch (RemoteException remoteException) {
            zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getDiscoveryManagerImpl", zzg.class.getSimpleName()});
        }
        this.zzapZ = object3 == null ? null : new zzd((zzj)object3);
        Object var7_10 = null;
        try {
            zzn zzn2 = this.zzapX.zzsH();
        }
        catch (RemoteException remoteException) {
            zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getSessionManagerImpl", zzg.class.getSimpleName()});
        }
        this.zzapY = var7_12 == null ? null : new SessionManager((zzn)var7_12);
    }

    public CastOptions getCastOptions() throws IllegalStateException {
        zzac.zzdj((String)"Must be called from the main thread.");
        return this.zzaqa;
    }

    public SessionManager getSessionManager() throws IllegalStateException {
        zzac.zzdj((String)"Must be called from the main thread.");
        return this.zzapY;
    }

    public MediaRouteSelector getMergedSelector() throws IllegalStateException {
        zzac.zzdj((String)"Must be called from the main thread.");
        try {
            return MediaRouteSelector.fromBundle((Bundle)this.zzapX.zzsG());
        }
        catch (RemoteException remoteException) {
            zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getMergedSelectorAsBundle", zzg.class.getSimpleName()});
            return null;
        }
    }

    public int getCastState() {
        zzac.zzdj((String)"Must be called from the main thread.");
        return this.zzapY.getCastState();
    }

    public boolean isAppVisible() throws IllegalStateException {
        zzac.zzdj((String)"Must be called from the main thread.");
        try {
            return this.zzapX.isAppVisible();
        }
        catch (RemoteException remoteException) {
            zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isApplicationVisible", zzg.class.getSimpleName()});
            return false;
        }
    }

    public void addAppVisibilityListener(AppVisibilityListener appVisibilityListener) throws IllegalStateException, NullPointerException {
        zzac.zzdj((String)"Must be called from the main thread.");
        zzac.zzw((Object)appVisibilityListener);
        try {
            this.zzapX.zza(new zza(appVisibilityListener));
        }
        catch (RemoteException remoteException) {
            zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addVisibilityChangeListener", zzg.class.getSimpleName()});
        }
    }

    public void removeAppVisibilityListener(AppVisibilityListener appVisibilityListener) throws IllegalStateException {
        zzac.zzdj((String)"Must be called from the main thread.");
        if (appVisibilityListener == null) {
            return;
        }
        try {
            this.zzapX.zzb(new zza(appVisibilityListener));
        }
        catch (RemoteException remoteException) {
            zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addVisibilityChangeListener", zzg.class.getSimpleName()});
        }
    }

    public void addCastStateListener(CastStateListener castStateListener) throws IllegalStateException, NullPointerException {
        zzac.zzdj((String)"Must be called from the main thread.");
        zzac.zzw((Object)castStateListener);
        this.zzapY.addCastStateListener(castStateListener);
    }

    public void removeCastStateListener(CastStateListener castStateListener) throws IllegalStateException {
        zzac.zzdj((String)"Must be called from the main thread.");
        if (castStateListener == null) {
            return;
        }
        this.zzapY.removeCastStateListener(castStateListener);
    }

    public zzd zzsD() {
        zzac.zzdj((String)"Must be called from the main thread.");
        return this.zzapZ;
    }

    @Deprecated
    public void registerLifecycleCallbacksBeforeIceCreamSandwich(@NonNull FragmentActivity fragmentActivity, Bundle bundle) {
    }

    public boolean onDispatchVolumeKeyEventBeforeJellyBean(KeyEvent keyEvent) {
        zzac.zzdj((String)"Must be called from the main thread.");
        if (zzt.zzzi()) {
            return false;
        }
        CastSession castSession = this.zzapY.getCurrentCastSession();
        if (castSession == null || !castSession.isConnected()) {
            return false;
        }
        double d = this.getCastOptions().getVolumeDeltaBeforeIceCreamSandwich();
        boolean bl = keyEvent.getAction() == 0;
        switch (keyEvent.getKeyCode()) {
            case 24: {
                this.zza(castSession, d, bl);
                return true;
            }
            case 25: {
                this.zza(castSession, -d, bl);
                return true;
            }
        }
        return false;
    }

    private boolean zza(CastSession castSession, double d, boolean bl) {
        if (bl) {
            try {
                double d2 = castSession.getVolume() + d;
                if (d2 > 1.0) {
                    d2 = 1.0;
                }
                castSession.setVolume(d2);
            }
            catch (IOException | IllegalStateException exception) {
                zzapV.zzc("Unable to call CastSession.setVolume(double).", new Object[]{exception});
            }
        }
        return true;
    }

    public IObjectWrapper zzsE() {
        try {
            return this.zzapX.zzsJ();
        }
        catch (RemoteException remoteException) {
            zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedThis", zzg.class.getSimpleName()});
            return null;
        }
    }
}

