/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import com.google.android.gms.cast.framework.zzm;
import com.google.android.gms.cast.framework.zzq;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.internal.zzwv;
import com.google.android.gms.internal.zzyz;

public abstract class Session {
    private static final zzyz zzapV = new zzyz("Session");
    private final zzm zzaqD;
    private final zza zzaqE = new zza();

    protected Session(Context context, String string2, String string3) {
        this.zzaqD = zzwv.zza(context, string2, string3, this.zzaqE);
    }

    protected abstract void start(Bundle var1);

    protected abstract void resume(Bundle var1);

    protected abstract void end(boolean var1);

    public long getSessionRemainingTimeMs() {
        zzac.zzdj((String)"Must be called from the main thread.");
        return 0L;
    }

    public final String getCategory() {
        zzac.zzdj((String)"Must be called from the main thread.");
        try {
            return this.zzaqD.getCategory();
        }
        catch (RemoteException remoteException) {
            zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getCategory", zzm.class.getSimpleName()});
            return null;
        }
    }

    public final String getSessionId() {
        zzac.zzdj((String)"Must be called from the main thread.");
        try {
            return this.zzaqD.getSessionId();
        }
        catch (RemoteException remoteException) {
            zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getSessionId", zzm.class.getSimpleName()});
            return null;
        }
    }

    public boolean isConnected() {
        zzac.zzdj((String)"Must be called from the main thread.");
        try {
            return this.zzaqD.isConnected();
        }
        catch (RemoteException remoteException) {
            zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isConnected", zzm.class.getSimpleName()});
            return false;
        }
    }

    public boolean isConnecting() {
        zzac.zzdj((String)"Must be called from the main thread.");
        try {
            return this.zzaqD.isConnecting();
        }
        catch (RemoteException remoteException) {
            zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isConnecting", zzm.class.getSimpleName()});
            return false;
        }
    }

    public boolean isDisconnecting() {
        zzac.zzdj((String)"Must be called from the main thread.");
        try {
            return this.zzaqD.isDisconnecting();
        }
        catch (RemoteException remoteException) {
            zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isDisconnecting", zzm.class.getSimpleName()});
            return false;
        }
    }

    public boolean isDisconnected() {
        zzac.zzdj((String)"Must be called from the main thread.");
        try {
            return this.zzaqD.isDisconnected();
        }
        catch (RemoteException remoteException) {
            zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isDisconnected", zzm.class.getSimpleName()});
            return true;
        }
    }

    public boolean isResuming() {
        zzac.zzdj((String)"Must be called from the main thread.");
        try {
            return this.zzaqD.isResuming();
        }
        catch (RemoteException remoteException) {
            zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isResuming", zzm.class.getSimpleName()});
            return false;
        }
    }

    public boolean isSuspended() {
        zzac.zzdj((String)"Must be called from the main thread.");
        try {
            return this.zzaqD.isSuspended();
        }
        catch (RemoteException remoteException) {
            zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isSuspended", zzm.class.getSimpleName()});
            return false;
        }
    }

    protected final void notifySessionStarted(String string2) {
        try {
            this.zzaqD.notifySessionStarted(string2);
        }
        catch (RemoteException remoteException) {
            zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifySessionStarted", zzm.class.getSimpleName()});
        }
    }

    protected final void notifyFailedToStartSession(int n) {
        try {
            this.zzaqD.notifyFailedToStartSession(n);
        }
        catch (RemoteException remoteException) {
            zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifyFailedToStartSession", zzm.class.getSimpleName()});
        }
    }

    protected final void notifySessionEnded(int n) {
        try {
            this.zzaqD.notifySessionEnded(n);
        }
        catch (RemoteException remoteException) {
            zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifySessionEnded", zzm.class.getSimpleName()});
        }
    }

    protected final void notifySessionResumed(boolean bl) {
        try {
            this.zzaqD.notifySessionResumed(bl);
        }
        catch (RemoteException remoteException) {
            zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifySessionResumed", zzm.class.getSimpleName()});
        }
    }

    protected final void notifyFailedToResumeSession(int n) {
        try {
            this.zzaqD.notifyFailedToResumeSession(n);
        }
        catch (RemoteException remoteException) {
            zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifyFailedToResumeSession", zzm.class.getSimpleName()});
        }
    }

    protected final void notifySessionSuspended(int n) {
        try {
            this.zzaqD.notifySessionSuspended(n);
        }
        catch (RemoteException remoteException) {
            zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifySessionSuspended", zzm.class.getSimpleName()});
        }
    }

    public final IObjectWrapper zzsN() {
        try {
            return this.zzaqD.zzsN();
        }
        catch (RemoteException remoteException) {
            zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedObject", zzm.class.getSimpleName()});
            return null;
        }
    }

    private class zza
    extends zzq.zza {
        private zza() {
        }

        @Override
        public int zzsB() {
            return 10260208;
        }

        @Override
        public IObjectWrapper zzsQ() {
            return zzd.zzA((Object)Session.this);
        }

        @Override
        public void start(Bundle bundle) {
            Session.this.start(bundle);
        }

        @Override
        public void resume(Bundle bundle) {
            Session.this.resume(bundle);
        }

        @Override
        public void end(boolean bl) {
            Session.this.end(bl);
        }

        @Override
        public long getSessionRemainingTimeMs() {
            return Session.this.getSessionRemainingTimeMs();
        }
    }
}

