/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;

public class zzxu
extends UIController {
    private final ImageView zzatC;
    private final View zzatR;
    private final boolean zzatS;
    private final Drawable zzatT;
    private final String zzatU;
    private final Drawable zzatV;
    private final String zzatW;
    private final Drawable zzatX;
    private final String zzatY;
    private final View.OnClickListener zzatA;

    public zzxu(@NonNull ImageView imageView, Context context, @NonNull Drawable drawable2, @NonNull Drawable drawable3, Drawable drawable4, View view, boolean bl) {
        this.zzatC = imageView;
        this.zzatT = drawable2;
        this.zzatV = drawable3;
        this.zzatX = drawable4 != null ? drawable4 : drawable3;
        this.zzatU = context.getString(R.string.cast_play);
        this.zzatW = context.getString(R.string.cast_pause);
        this.zzatY = context.getString(R.string.cast_stop);
        this.zzatR = view;
        this.zzatS = bl;
        this.zzatA = new View.OnClickListener(){

            public void onClick(View view) {
                RemoteMediaClient remoteMediaClient = zzxu.this.getRemoteMediaClient();
                if (remoteMediaClient != null && remoteMediaClient.hasMediaSession()) {
                    remoteMediaClient.togglePlayback();
                }
            }
        };
    }

    @Override
    public void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzatC.setOnClickListener(this.zzatA);
        this.zztV();
    }

    @Override
    public void onSessionEnded() {
        this.zzatC.setOnClickListener(null);
        super.onSessionEnded();
    }

    @Override
    public void onMediaStatusUpdated() {
        this.zztV();
    }

    @Override
    public void onSendingRemoteMediaRequest() {
        this.zzan(true);
    }

    private void zztV() {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            return;
        }
        if (remoteMediaClient.isPaused()) {
            this.zza(this.zzatT, this.zzatU);
        } else if (remoteMediaClient.isPlaying()) {
            if (remoteMediaClient.isLiveStream()) {
                this.zza(this.zzatX, this.zzatY);
            } else {
                this.zza(this.zzatV, this.zzatW);
            }
        } else if (remoteMediaClient.isBuffering()) {
            this.zzan(false);
        } else if (remoteMediaClient.isLoadingNextItem()) {
            this.zzan(true);
        }
    }

    private void zza(Drawable drawable2, String string2) {
        this.zzatC.setImageDrawable(drawable2);
        this.zzatC.setContentDescription((CharSequence)string2);
        this.zzatC.setVisibility(0);
        this.zzatC.setEnabled(true);
        if (this.zzatR != null) {
            this.zzatR.setVisibility(8);
        }
    }

    private void zzan(boolean bl) {
        if (this.zzatR != null) {
            this.zzatR.setVisibility(0);
        }
        this.zzatC.setVisibility(this.zzatS ? 4 : 0);
        this.zzatC.setEnabled(!bl);
    }
}

