/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.zzb;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastOptions
extends zza {
    public static final Parcelable.Creator<CastOptions> CREATOR = new zzb();
    private final String zzarU;
    private final List<String> zzarV;
    private final boolean zzarW;
    private final LaunchOptions zzapY;
    private final boolean zzarX;
    private final CastMediaOptions zzarY;
    private final boolean zzarZ;
    private final double zzasa;

    CastOptions(String string, List<String> list, boolean bl, LaunchOptions launchOptions, boolean bl2, CastMediaOptions castMediaOptions, boolean bl3, double d) {
        this.zzarU = TextUtils.isEmpty((CharSequence)string) ? "" : string;
        int n = list == null ? 0 : list.size();
        this.zzarV = new ArrayList<String>(n);
        if (n > 0) {
            this.zzarV.addAll(list);
        }
        this.zzarW = bl;
        this.zzapY = launchOptions == null ? new LaunchOptions() : launchOptions;
        this.zzarX = bl2;
        this.zzarY = castMediaOptions;
        this.zzarZ = bl3;
        this.zzasa = d;
    }

    public String getReceiverApplicationId() {
        return this.zzarU;
    }

    public List<String> getSupportedNamespaces() {
        return Collections.unmodifiableList(this.zzarV);
    }

    public boolean getStopReceiverApplicationWhenEndingSession() {
        return this.zzarW;
    }

    public LaunchOptions getLaunchOptions() {
        return this.zzapY;
    }

    public boolean getResumeSavedSession() {
        return this.zzarX;
    }

    public CastMediaOptions getCastMediaOptions() {
        return this.zzarY;
    }

    public boolean getEnableReconnectionService() {
        return this.zzarZ;
    }

    public double getVolumeDeltaBeforeIceCreamSandwich() {
        return this.zzasa;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        CastOptions castOptions = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (String)castOptions.getReceiverApplicationId(), (boolean)false);
        zzd.zzb((Parcel)parcel2, (int)3, castOptions.getSupportedNamespaces(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (boolean)castOptions.getStopReceiverApplicationWhenEndingSession());
        zzd.zza((Parcel)parcel2, (int)5, (Parcelable)castOptions.getLaunchOptions(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (boolean)castOptions.getResumeSavedSession());
        zzd.zza((Parcel)parcel2, (int)7, (Parcelable)castOptions.getCastMediaOptions(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)8, (boolean)castOptions.getEnableReconnectionService());
        zzd.zza((Parcel)parcel2, (int)9, (double)castOptions.getVolumeDeltaBeforeIceCreamSandwich());
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public static final class Builder {
        private String zzarU;
        private List<String> zzarV = new ArrayList<String>();
        private boolean zzarW;
        private LaunchOptions zzapY = new LaunchOptions();
        private boolean zzarX = true;
        private CastMediaOptions zzarY = new CastMediaOptions.Builder().build();
        private boolean zzarZ = true;
        private double zzasa = 0.05f;

        public final Builder setReceiverApplicationId(String string) {
            this.zzarU = string;
            return this;
        }

        public final Builder setSupportedNamespaces(List<String> list) {
            this.zzarV = list;
            return this;
        }

        public final Builder setStopReceiverApplicationWhenEndingSession(boolean bl) {
            this.zzarW = bl;
            return this;
        }

        public final Builder setLaunchOptions(LaunchOptions launchOptions) {
            this.zzapY = launchOptions;
            return this;
        }

        public final Builder setResumeSavedSession(boolean bl) {
            this.zzarX = bl;
            return this;
        }

        public final Builder setCastMediaOptions(CastMediaOptions castMediaOptions) {
            this.zzarY = castMediaOptions;
            return this;
        }

        public final Builder setEnableReconnectionService(boolean bl) {
            this.zzarZ = bl;
            return this;
        }

        public final Builder setVolumeDeltaBeforeIceCreamSandwich(double d) throws IllegalArgumentException {
            if (d <= 0.0 || d > 0.5) {
                throw new IllegalArgumentException("volumeDelta must be greater than 0 and less or equal to 0.5");
            }
            this.zzasa = d;
            return this;
        }

        public final CastOptions build() {
            return new CastOptions(this.zzarU, this.zzarV, this.zzarW, this.zzapY, this.zzarX, this.zzarY, this.zzarZ, this.zzasa);
        }
    }
}

