/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.zzj;
import com.google.android.gms.cast.framework.zzm;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.internal.zzavv;
import com.google.android.gms.internal.zzavx;
import com.google.android.gms.internal.zzawz;
import com.google.android.gms.internal.zzbaa;
import com.google.android.gms.internal.zzbab;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CastSession
extends Session {
    private static final zzbaa zzarM = new zzbaa("CastSession");
    private final Context zzarO;
    private final Set<Cast.Listener> zzasb = new HashSet<Cast.Listener>();
    private final zzm zzasc;
    private final CastOptions zzarS;
    private final Cast.CastApi zzasd;
    private final zzavx zzase;
    private final zzawz zzasf;
    private GoogleApiClient zzapw;
    private RemoteMediaClient zzasg;
    private CastDevice zzash;
    private Cast.ApplicationConnectionResult zzasi;

    public CastSession(Context context, String string2, String string3, CastOptions castOptions, Cast.CastApi castApi, zzavx zzavx2, zzawz zzawz2) {
        super(context, string2, string3);
        this.zzarO = context.getApplicationContext();
        this.zzarS = castOptions;
        this.zzasd = castApi;
        this.zzase = zzavx2;
        this.zzasf = zzawz2;
        this.zzasc = zzavv.zza(context, castOptions, this.zznu(), new zzb(this, null));
    }

    @Override
    protected void start(Bundle bundle) {
        this.zzj(bundle);
    }

    @Override
    protected void resume(Bundle bundle) {
        this.zzj(bundle);
    }

    @Override
    protected void end(boolean bl) {
        try {
            this.zzasc.zzb(bl, 0);
        }
        catch (RemoteException remoteException) {
            zzarM.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"disconnectFromDevice", zzm.class.getSimpleName()});
        }
        this.notifySessionEnded(0);
    }

    public RemoteMediaClient getRemoteMediaClient() {
        zzbr.zzcz((String)"Must be called from the main thread.");
        return this.zzasg;
    }

    public CastDevice getCastDevice() {
        zzbr.zzcz((String)"Must be called from the main thread.");
        return this.zzash;
    }

    public void requestStatus() throws IOException, IllegalStateException {
        zzbr.zzcz((String)"Must be called from the main thread.");
        if (this.zzapw != null) {
            this.zzasd.requestStatus(this.zzapw);
        }
    }

    public int getActiveInputState() throws IllegalStateException {
        zzbr.zzcz((String)"Must be called from the main thread.");
        if (this.zzapw != null) {
            return this.zzasd.getActiveInputState(this.zzapw);
        }
        return -1;
    }

    public int getStandbyState() throws IllegalStateException {
        zzbr.zzcz((String)"Must be called from the main thread.");
        if (this.zzapw != null) {
            return this.zzasd.getStandbyState(this.zzapw);
        }
        return -1;
    }

    public ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        zzbr.zzcz((String)"Must be called from the main thread.");
        if (this.zzapw != null) {
            return this.zzasd.getApplicationMetadata(this.zzapw);
        }
        return null;
    }

    public String getApplicationStatus() throws IllegalStateException {
        zzbr.zzcz((String)"Must be called from the main thread.");
        if (this.zzapw != null) {
            return this.zzasd.getApplicationStatus(this.zzapw);
        }
        return null;
    }

    public void setVolume(double d) throws IOException {
        zzbr.zzcz((String)"Must be called from the main thread.");
        if (this.zzapw != null) {
            this.zzasd.setVolume(this.zzapw, d);
        }
    }

    public double getVolume() throws IllegalStateException {
        zzbr.zzcz((String)"Must be called from the main thread.");
        if (this.zzapw != null) {
            return this.zzasd.getVolume(this.zzapw);
        }
        return 0.0;
    }

    public void setMute(boolean bl) throws IOException, IllegalStateException {
        zzbr.zzcz((String)"Must be called from the main thread.");
        if (this.zzapw != null) {
            this.zzasd.setMute(this.zzapw, bl);
        }
    }

    public boolean isMute() throws IllegalStateException {
        zzbr.zzcz((String)"Must be called from the main thread.");
        if (this.zzapw != null) {
            return this.zzasd.isMute(this.zzapw);
        }
        return false;
    }

    public Cast.ApplicationConnectionResult getApplicationConnectionResult() {
        zzbr.zzcz((String)"Must be called from the main thread.");
        return this.zzasi;
    }

    public void setMessageReceivedCallbacks(String string2, Cast.MessageReceivedCallback messageReceivedCallback) throws IOException, IllegalStateException {
        zzbr.zzcz((String)"Must be called from the main thread.");
        if (this.zzapw != null) {
            this.zzasd.setMessageReceivedCallbacks(this.zzapw, string2, messageReceivedCallback);
        }
    }

    public void removeMessageReceivedCallbacks(String string2) throws IOException, IllegalArgumentException {
        zzbr.zzcz((String)"Must be called from the main thread.");
        if (this.zzapw != null) {
            this.zzasd.removeMessageReceivedCallbacks(this.zzapw, string2);
        }
    }

    public PendingResult<Status> sendMessage(String string2, String string3) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        if (this.zzapw != null) {
            return this.zzasd.sendMessage(this.zzapw, string2, string3);
        }
        return null;
    }

    public void addCastListener(Cast.Listener listener) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        if (listener != null) {
            this.zzasb.add(listener);
        }
    }

    public void removeCastListener(Cast.Listener listener) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        if (listener != null) {
            this.zzasb.remove(listener);
        }
    }

    private final void zzj(Bundle bundle) {
        zzd zzd2;
        this.zzash = CastDevice.getFromBundle((Bundle)bundle);
        if (this.zzash == null) {
            if (this.isResuming()) {
                this.notifyFailedToResumeSession(8);
                return;
            }
            this.notifyFailedToStartSession(8);
            return;
        }
        if (this.zzapw != null) {
            this.zzapw.disconnect();
            this.zzapw = null;
        }
        zzarM.zzb("Acquiring a connection to Google Play Services for %s", new Object[]{this.zzash});
        zzd zzd3 = zzd2 = new zzd(this, null);
        zzd zzd4 = zzd2;
        zzc zzc2 = new zzc(this, null);
        CastOptions castOptions = this.zzarS;
        CastDevice castDevice = this.zzash;
        Context context = this.zzarO;
        Bundle bundle2 = new Bundle();
        bundle2.putBoolean("com.google.android.gms.cast.EXTRA_CAST_FRAMEWORK_NOTIFICATION_ENABLED", castOptions != null && castOptions.getCastMediaOptions() != null && castOptions.getCastMediaOptions().getNotificationOptions() != null);
        this.zzapw = new GoogleApiClient.Builder(context).addApi(Cast.API, (Api.ApiOptions.HasOptions)new Cast.CastOptions.Builder(castDevice, (Cast.Listener)zzc2).zzi(bundle2).build()).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)zzd4).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)zzd3).build();
        this.zzapw.connect();
    }

    private final void zzY(int n) {
        this.zzasf.zzab(n);
        if (this.zzapw != null) {
            this.zzapw.disconnect();
            this.zzapw = null;
        }
        this.zzash = null;
        if (this.zzasg != null) {
            try {
                this.zzasg.zzc(null);
            }
            catch (IOException iOException) {
                zzarM.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
            }
            this.zzasg = null;
        }
        this.zzasi = null;
    }

    @Override
    public long getSessionRemainingTimeMs() {
        zzbr.zzcz((String)"Must be called from the main thread.");
        if (this.zzasg == null) {
            return 0L;
        }
        return this.zzasg.getStreamDuration() - this.zzasg.getApproximateStreamPosition();
    }

    final class zzb
    extends zzj {
        private /* synthetic */ CastSession zzask;

        private zzb(CastSession castSession) {
            this.zzask = castSession;
        }

        @Override
        public final void zzt(String string, String string2) {
            this.zzask.zzasd.joinApplication(this.zzask.zzapw, string, string2).setResultCallback((ResultCallback)new zza(this.zzask, "joinApplication"));
        }

        @Override
        public final void zza(String string, LaunchOptions launchOptions) {
            this.zzask.zzasd.launchApplication(this.zzask.zzapw, string, launchOptions).setResultCallback((ResultCallback)new zza(this.zzask, "launchApplication"));
        }

        @Override
        public final void zzcc(String string) {
            this.zzask.zzasd.stopApplication(this.zzask.zzapw, string);
        }

        @Override
        public final void zzY(int n) {
            this.zzask.zzY(n);
        }

        /* synthetic */ zzb(CastSession castSession, com.google.android.gms.cast.framework.zzc zzc2) {
            this(castSession);
        }
    }

    final class zza
    implements ResultCallback<Cast.ApplicationConnectionResult> {
        private String zzasj;
        private /* synthetic */ CastSession zzask;

        zza(CastSession castSession, String string2) {
            this.zzask = castSession;
            this.zzasj = string2;
        }

        public final /* synthetic */ void onResult(@NonNull Result result) {
            Cast.ApplicationConnectionResult applicationConnectionResult = (Cast.ApplicationConnectionResult)result;
            zza zza2 = this;
            zza2.zzask.zzasi = applicationConnectionResult;
            try {
                if (applicationConnectionResult.getStatus().isSuccess()) {
                    zzarM.zzb("%s() -> success result", new Object[]{zza2.zzasj});
                    zza2.zzask.zzasg = new RemoteMediaClient(new zzbab(null), zza2.zzask.zzasd);
                    try {
                        zza2.zzask.zzasg.zzc(zza2.zzask.zzapw);
                        zza2.zzask.zzasg.zznV();
                        zza2.zzask.zzasg.requestStatus();
                        zza2.zzask.zzasf.zza(zza2.zzask.zzasg, zza2.zzask.getCastDevice());
                    }
                    catch (IOException iOException) {
                        zzarM.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
                        zza2.zzask.zzasg = null;
                    }
                    zza2.zzask.zzasc.zza(applicationConnectionResult.getApplicationMetadata(), applicationConnectionResult.getApplicationStatus(), applicationConnectionResult.getSessionId(), applicationConnectionResult.getWasLaunched());
                    return;
                }
                zzarM.zzb("%s() -> failure result", new Object[]{zza2.zzasj});
                zza2.zzask.zzasc.zzZ(applicationConnectionResult.getStatus().getStatusCode());
                return;
            }
            catch (RemoteException remoteException) {
                zzarM.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"methods", zzm.class.getSimpleName()});
                return;
            }
        }
    }

    final class zzc
    extends Cast.Listener {
        private /* synthetic */ CastSession zzask;

        private zzc(CastSession castSession) {
            this.zzask = castSession;
        }

        public final void onApplicationDisconnected(int n) {
            this.zzask.zzY(n);
            this.zzask.notifySessionEnded(n);
            Iterator iterator = new HashSet(this.zzask.zzasb).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onApplicationDisconnected(n);
            }
        }

        public final void onApplicationStatusChanged() {
            Iterator iterator = new HashSet(this.zzask.zzasb).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onApplicationStatusChanged();
            }
        }

        public final void onApplicationMetadataChanged(ApplicationMetadata applicationMetadata) {
            Iterator iterator = new HashSet(this.zzask.zzasb).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onApplicationMetadataChanged(applicationMetadata);
            }
        }

        public final void onActiveInputStateChanged(int n) {
            Iterator iterator = new HashSet(this.zzask.zzasb).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onActiveInputStateChanged(n);
            }
        }

        public final void onStandbyStateChanged(int n) {
            Iterator iterator = new HashSet(this.zzask.zzasb).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onStandbyStateChanged(n);
            }
        }

        public final void onVolumeChanged() {
            Iterator iterator = new HashSet(this.zzask.zzasb).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onVolumeChanged();
            }
        }

        /* synthetic */ zzc(CastSession castSession, com.google.android.gms.cast.framework.zzc zzc2) {
            this(castSession);
        }
    }

    final class zzd
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private /* synthetic */ CastSession zzask;

        private zzd(CastSession castSession) {
            this.zzask = castSession;
        }

        public final void onConnected(Bundle bundle) {
            try {
                if (this.zzask.zzasg != null) {
                    try {
                        this.zzask.zzasg.zznV();
                        this.zzask.zzasg.requestStatus();
                    }
                    catch (IOException iOException) {
                        zzarM.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
                        this.zzask.zzasg = null;
                    }
                }
                this.zzask.zzasc.onConnected(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                zzarM.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnected", zzm.class.getSimpleName()});
                return;
            }
        }

        public final void onConnectionSuspended(int n) {
            try {
                this.zzask.zzasc.onConnectionSuspended(n);
                return;
            }
            catch (RemoteException remoteException) {
                zzarM.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnectionSuspended", zzm.class.getSimpleName()});
                return;
            }
        }

        public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            try {
                this.zzask.zzasc.onConnectionFailed(connectionResult);
                return;
            }
            catch (RemoteException remoteException) {
                zzarM.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnectionFailed", zzm.class.getSimpleName()});
                return;
            }
        }

        /* synthetic */ zzd(CastSession castSession, com.google.android.gms.cast.framework.zzc zzc2) {
            this(castSession);
        }
    }
}

