/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.IntroductoryOverlay;
import com.google.android.gms.internal.zzawe;
import com.google.android.gms.internal.zzawj;
import com.google.android.gms.internal.zzawl;

public final class zzawi
extends RelativeLayout
implements IntroductoryOverlay {
    private final boolean zzasE;
    private Activity mActivity;
    private int zzasJ;
    private boolean zzasG;
    private IntroductoryOverlay.OnOverlayDismissedListener zzasq;
    private final zzawl zzasK;

    public zzawi(IntroductoryOverlay.Builder builder) {
        this(builder, null, R.attr.castIntroOverlayStyle);
    }

    @TargetApi(value=14)
    private zzawi(IntroductoryOverlay.Builder builder, AttributeSet attributeSet, int n) {
        super((Context)builder.getActivity(), null, n);
        TypedArray typedArray;
        Object object;
        this.mActivity = builder.getActivity();
        this.zzasE = builder.zznB();
        this.zzasq = builder.zznz();
        TypedArray typedArray2 = this.mActivity.getTheme().obtainStyledAttributes(null, R.styleable.CastIntroOverlay, n, R.style.CastIntroOverlay);
        if (builder.zzny() != null) {
            Rect rect = new Rect();
            builder.zzny().getGlobalVisibleRect(rect);
            this.zzasK = new zzawl(null);
            this.zzasK.x = rect.centerX();
            this.zzasK.y = rect.centerY();
            object = new PorterDuffXfermode(PorterDuff.Mode.MULTIPLY);
            typedArray = new Paint();
            typedArray.setColor(-1);
            typedArray.setAlpha(0);
            typedArray.setXfermode((Xfermode)object);
            typedArray.setAntiAlias(true);
            this.zzasK.zzasN = typedArray;
            this.zzasK.zzasO = builder.zznE();
            if (this.zzasK.zzasO == 0.0f) {
                this.zzasK.zzasO = typedArray2.getDimension(R.styleable.CastIntroOverlay_castFocusRadius, 0.0f);
            }
        } else {
            this.zzasK = null;
        }
        LayoutInflater.from((Context)this.mActivity).inflate(R.layout.cast_intro_overlay, (ViewGroup)this);
        this.zzasJ = builder.zznA();
        if (this.zzasJ == 0) {
            this.zzasJ = typedArray2.getColor(R.styleable.CastIntroOverlay_castBackgroundColor, Color.argb((int)0, (int)0, (int)0, (int)0));
        }
        TextView textView = (TextView)this.findViewById(R.id.textTitle);
        if (!TextUtils.isEmpty((CharSequence)builder.zznC())) {
            textView.setText((CharSequence)builder.zznC());
            int n2 = typedArray2.getResourceId(R.styleable.CastIntroOverlay_castTitleTextAppearance, 0);
            if (n2 != 0) {
                textView.setTextAppearance((Context)this.mActivity, n2);
            }
        }
        typedArray = typedArray2;
        object = builder.zznD();
        zzawi zzawi2 = this;
        Object object2 = object;
        if (TextUtils.isEmpty((CharSequence)object)) {
            object2 = typedArray.getString(R.styleable.CastIntroOverlay_castButtonText);
        }
        int n3 = typedArray.getColor(R.styleable.CastIntroOverlay_castButtonBackgroundColor, Color.argb((int)0, (int)0, (int)0, (int)0));
        Button button = (Button)zzawi2.findViewById(R.id.button);
        button.setText((CharSequence)object2);
        button.getBackground().setColorFilter(n3, PorterDuff.Mode.MULTIPLY);
        int n4 = typedArray.getResourceId(R.styleable.CastIntroOverlay_castButtonTextAppearance, 0);
        if (n4 != 0) {
            button.setTextAppearance((Context)zzawi2.mActivity, n4);
        }
        button.setOnClickListener((View.OnClickListener)new zzawj(zzawi2));
        typedArray2.recycle();
        this.setFitsSystemWindows(true);
    }

    @Override
    public final void show() {
        if (this.mActivity == null) {
            return;
        }
        if (zzawe.zzao((Context)this.mActivity)) {
            return;
        }
        if (this.zzasE && IntroductoryOverlay.zza.zzam((Context)this.mActivity)) {
            this.mActivity = null;
            this.zzasq = null;
            return;
        }
        if (!this.zzasG) {
            this.zzasG = true;
            ((ViewGroup)this.mActivity.getWindow().getDecorView()).addView((View)this);
        }
    }

    @Override
    public final void remove() {
        if (this.mActivity != null) {
            ((ViewGroup)this.mActivity.getWindow().getDecorView()).removeView((View)this);
            this.mActivity = null;
        }
        this.zzasq = null;
    }

    protected final void dispatchDraw(Canvas canvas) {
        Bitmap bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas2 = new Canvas(bitmap);
        canvas2.drawColor(this.zzasJ);
        if (this.zzasK != null) {
            canvas2.drawCircle((float)this.zzasK.x, (float)this.zzasK.y, this.zzasK.zzasO, this.zzasK.zzasN);
        }
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        bitmap.recycle();
        super.dispatchDraw(canvas);
    }

    public final boolean onTouchEvent(MotionEvent motionEvent) {
        return true;
    }

    protected final void onDetachedFromWindow() {
        if (this.mActivity != null) {
            this.mActivity = null;
        }
        super.onDetachedFromWindow();
    }

    private final void zznK() {
        IntroductoryOverlay.zza.zzal((Context)this.mActivity);
        if (this.zzasq != null) {
            this.zzasq.onOverlayDismissed();
            this.zzasq = null;
        }
        this.remove();
    }

    static /* synthetic */ void zza(zzawi zzawi2) {
        zzawi2.zznK();
    }
}

